/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.record;

import com.alibaba.fluss.memory.MemorySegment;
import com.alibaba.fluss.memory.MemorySegmentOutputView;
import com.alibaba.fluss.record.DefaultLogRecord;
import com.alibaba.fluss.record.LogTestBase;
import com.alibaba.fluss.record.RowKind;
import com.alibaba.fluss.row.BinaryString;
import com.alibaba.fluss.row.InternalRow;
import com.alibaba.fluss.row.TestInternalRowGenerator;
import com.alibaba.fluss.row.indexed.IndexedRow;
import com.alibaba.fluss.row.indexed.IndexedRowWriter;
import com.alibaba.fluss.types.DataType;
import java.io.IOException;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class DefaultLogRecordTest
extends LogTestBase {
    DefaultLogRecordTest() {
    }

    @Test
    void testBase() throws IOException {
        DataType[] fieldTypes = this.baseRowType.getChildren().toArray(new DataType[0]);
        IndexedRow row = new IndexedRow(fieldTypes);
        IndexedRowWriter writer = new IndexedRowWriter(this.baseRowType.getChildren().toArray(new DataType[0]));
        writer.writeInt(10);
        writer.writeString(BinaryString.fromString((String)"abc"));
        row.pointTo(writer.segment(), 0, writer.position());
        DefaultLogRecord.writeTo((MemorySegmentOutputView)this.outputView, (RowKind)RowKind.APPEND_ONLY, (InternalRow)row);
        DefaultLogRecord defaultLogRecord = DefaultLogRecord.readFrom((MemorySegment)MemorySegment.wrap((byte[])this.outputView.getCopyOfBuffer()), (int)0, (long)1000L, (long)10001L, (DataType[])fieldTypes);
        Assertions.assertThat((int)defaultLogRecord.getSizeInBytes()).isEqualTo(17);
        Assertions.assertThat((long)defaultLogRecord.logOffset()).isEqualTo(1000L);
        Assertions.assertThat((long)defaultLogRecord.timestamp()).isEqualTo(10001L);
        Assertions.assertThat((Comparable)defaultLogRecord.getRowKind()).isEqualTo((Object)RowKind.APPEND_ONLY);
        Assertions.assertThat((Object)defaultLogRecord.getRow()).isEqualTo((Object)row);
    }

    @Test
    void testWriteToAndReadFromWithRandomData() throws IOException {
        IndexedRow row = TestInternalRowGenerator.genIndexedRowForAllType();
        DefaultLogRecord.writeTo((MemorySegmentOutputView)this.outputView, (RowKind)RowKind.APPEND_ONLY, (InternalRow)row);
        DataType[] allColTypes = TestInternalRowGenerator.createAllRowType().getChildren().toArray(new DataType[0]);
        DefaultLogRecord defaultLogRecord = DefaultLogRecord.readFrom((MemorySegment)MemorySegment.wrap((byte[])this.outputView.getCopyOfBuffer()), (int)0, (long)1000L, (long)10001L, (DataType[])allColTypes);
        Assertions.assertThat((long)defaultLogRecord.logOffset()).isEqualTo(1000L);
        Assertions.assertThat((long)defaultLogRecord.timestamp()).isEqualTo(10001L);
        Assertions.assertThat((Comparable)defaultLogRecord.getRowKind()).isEqualTo((Object)RowKind.APPEND_ONLY);
        Assertions.assertThat((Object)defaultLogRecord.getRow()).isEqualTo((Object)row);
    }
}

