/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.record;

import com.alibaba.fluss.record.FileLogInputStream;
import com.alibaba.fluss.record.FileLogRecords;
import com.alibaba.fluss.record.LogRecord;
import com.alibaba.fluss.record.LogRecordBatch;
import com.alibaba.fluss.record.LogRecordReadContext;
import com.alibaba.fluss.record.LogTestBase;
import com.alibaba.fluss.record.TestData;
import com.alibaba.fluss.testutils.DataTestUtils;
import com.alibaba.fluss.types.RowType;
import com.alibaba.fluss.utils.CloseableIterator;
import java.io.File;
import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class FileLogInputStreamTest
extends LogTestBase {
    @TempDir
    private File tempDir;

    @Test
    void testWriteTo() throws Exception {
        try (FileLogRecords fileLogRecords = FileLogRecords.open((File)new File(this.tempDir, "test.tmp"));){
            fileLogRecords.append(DataTestUtils.genMemoryLogRecordsWithBaseOffset(0L, Collections.singletonList(new Object[]{0, "abc"})));
            fileLogRecords.flush();
            FileLogInputStream logInputStream = new FileLogInputStream(fileLogRecords, 0, fileLogRecords.sizeInBytes());
            FileLogInputStream.FileChannelLogRecordBatch batch = logInputStream.nextBatch();
            Assertions.assertThat((Object)batch).isNotNull();
            Assertions.assertThat((byte)batch.magic()).isEqualTo((byte)0);
            LogRecordBatch recordBatch = batch.loadFullBatch();
            try (LogRecordReadContext readContext = LogRecordReadContext.createArrowReadContext((RowType)TestData.DATA1_ROW_TYPE, (int)1);
                 CloseableIterator iterator = recordBatch.records((LogRecordBatch.ReadContext)readContext);){
                Assertions.assertThat((boolean)iterator.hasNext()).isTrue();
                LogRecord record = (LogRecord)iterator.next();
                Assertions.assertThat((int)record.getRow().getFieldCount()).isEqualTo(2);
                Assertions.assertThat((boolean)iterator.hasNext()).isFalse();
            }
        }
    }
}

