/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.record;

import com.alibaba.fluss.exception.InvalidColumnProjectionException;
import com.alibaba.fluss.record.BytesViewLogRecords;
import com.alibaba.fluss.record.FileLogProjection;
import com.alibaba.fluss.record.FileLogRecords;
import com.alibaba.fluss.record.LogRecord;
import com.alibaba.fluss.record.LogRecordBatch;
import com.alibaba.fluss.record.LogRecordReadContext;
import com.alibaba.fluss.record.RowKind;
import com.alibaba.fluss.record.TestData;
import com.alibaba.fluss.row.InternalRow;
import com.alibaba.fluss.testutils.DataTestUtils;
import com.alibaba.fluss.types.RowType;
import com.alibaba.fluss.utils.CloseableIterator;
import java.io.File;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class FileLogProjectionTest {
    @TempDir
    private File tempDir;

    FileLogProjectionTest() {
    }

    @Test
    void testSetCurrentProjection() {
        FileLogProjection projection = new FileLogProjection();
        projection.setCurrentProjection(1L, TestData.DATA2_ROW_TYPE, new int[]{0, 2});
        FileLogProjection.ProjectionInfo info1 = projection.currentProjection;
        Assertions.assertThat((Object)info1).isNotNull();
        Assertions.assertThat((int[])info1.nodesProjection.stream().toArray()).isEqualTo((Object)new int[]{0, 2});
        Assertions.assertThat((int[])info1.buffersProjection.stream().toArray()).isEqualTo((Object)new int[]{0, 1, 5, 6, 7});
        Assertions.assertThat((Map)projection.projectionsCache).hasSize(1);
        Assertions.assertThat(projection.projectionsCache.get(1L)).isSameAs((Object)info1);
        projection.setCurrentProjection(2L, TestData.DATA2_ROW_TYPE, new int[]{1});
        FileLogProjection.ProjectionInfo info2 = projection.currentProjection;
        Assertions.assertThat((Object)info2).isNotNull();
        Assertions.assertThat((int[])info2.nodesProjection.stream().toArray()).isEqualTo((Object)new int[]{1});
        Assertions.assertThat((int[])info2.buffersProjection.stream().toArray()).isEqualTo((Object)new int[]{2, 3, 4});
        Assertions.assertThat((Map)projection.projectionsCache).hasSize(2);
        Assertions.assertThat(projection.projectionsCache.get(2L)).isSameAs((Object)info2);
        projection.setCurrentProjection(1L, TestData.DATA2_ROW_TYPE, new int[]{0, 2});
        ((ObjectAssert)Assertions.assertThat((Object)projection.currentProjection).isNotNull()).isSameAs((Object)info1);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> projection.setCurrentProjection(1L, TestData.DATA1_ROW_TYPE, new int[]{1})).isInstanceOf(InvalidColumnProjectionException.class)).hasMessage("The schema and projection should be identical for the same table id.");
    }

    @Test
    void testIllegalSetCurrentProjection() {
        FileLogProjection projection = new FileLogProjection();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> projection.setCurrentProjection(1L, TestData.DATA2_ROW_TYPE, new int[]{3})).isInstanceOf(InvalidColumnProjectionException.class)).hasMessage("Projected fields [3] is out of bound for schema with 3 fields.");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> projection.setCurrentProjection(1L, TestData.DATA2_ROW_TYPE, new int[]{1, 0})).isInstanceOf(InvalidColumnProjectionException.class)).hasMessage("The projection indexes should be in field order, but is [1, 0]");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> projection.setCurrentProjection(1L, TestData.DATA2_ROW_TYPE, new int[]{0, 0, 0})).isInstanceOf(InvalidColumnProjectionException.class)).hasMessage("The projection indexes should not contain duplicated fields, but is [0, 0, 0]");
    }

    static Stream<Arguments> projectedFieldsArgs() {
        return Stream.of(Arguments.of((Object[])new Object[]{new int[]{0}}), Arguments.arguments((Object[])new Object[]{new int[]{1}}), Arguments.arguments((Object[])new Object[]{new int[]{0, 1}}));
    }

    @ParameterizedTest
    @MethodSource(value={"projectedFieldsArgs"})
    void testProject(int[] projectedFields) throws Exception {
        FileLogRecords fileLogRecords = this.createFileLogRecords(TestData.DATA1_ROW_TYPE, TestData.DATA1, TestData.ANOTHER_DATA1);
        List<Object[]> results = this.doProjection(new FileLogProjection(), fileLogRecords, TestData.DATA1_ROW_TYPE, projectedFields, Integer.MAX_VALUE);
        ArrayList<Object[]> allData = new ArrayList<Object[]>();
        allData.addAll(TestData.DATA1);
        allData.addAll(TestData.ANOTHER_DATA1);
        ArrayList<Object[]> expected = new ArrayList<Object[]>();
        Assertions.assertThat((int)results.size()).isEqualTo(allData.size());
        for (Object[] data : allData) {
            Object[] objs = new Object[projectedFields.length];
            for (int j = 0; j < projectedFields.length; ++j) {
                objs[j] = data[projectedFields[j]];
            }
            expected.add(objs);
        }
        FileLogProjectionTest.assertEquals(results, expected);
    }

    @Test
    void testIllegalByteOrder() throws Exception {
        FileLogRecords fileLogRecords = this.createFileLogRecords(TestData.DATA1_ROW_TYPE, TestData.DATA1, TestData.ANOTHER_DATA1);
        FileLogProjection projection = new FileLogProjection();
        projection.getLogHeaderBuffer().order(ByteOrder.BIG_ENDIAN);
        List<Object[]> results = this.doProjection(projection, fileLogRecords, TestData.DATA1_ROW_TYPE, new int[]{0}, Integer.MAX_VALUE);
        Assertions.assertThat(results).isEmpty();
    }

    @Test
    void testProjectSizeLimited() throws Exception {
        ArrayList<Object[]> allData = new ArrayList<Object[]>();
        allData.addAll(TestData.DATA1);
        allData.addAll(TestData.ANOTHER_DATA1);
        FileLogRecords fileLogRecords = this.createFileLogRecords(TestData.DATA1_ROW_TYPE, TestData.DATA1, TestData.ANOTHER_DATA1);
        int totalSize = fileLogRecords.sizeInBytes();
        boolean hasEmpty = false;
        boolean hasHalf = false;
        boolean hasFull = false;
        for (int i = 4; i >= 1; --i) {
            int maxBytes = totalSize / i;
            List<Object[]> results = this.doProjection(new FileLogProjection(), fileLogRecords, TestData.DATA1_ROW_TYPE, new int[]{0, 1}, maxBytes);
            if (results.isEmpty()) {
                hasEmpty = true;
                continue;
            }
            if (results.size() == TestData.DATA1.size()) {
                hasHalf = true;
                FileLogProjectionTest.assertEquals(results, TestData.DATA1);
                continue;
            }
            if (results.size() == allData.size()) {
                hasFull = true;
                FileLogProjectionTest.assertEquals(results, allData);
                continue;
            }
            Assertions.fail((String)("Unexpected result size: " + results.size()));
        }
        Assertions.assertThat((boolean)hasEmpty).isTrue();
        Assertions.assertThat((boolean)hasHalf).isTrue();
        Assertions.assertThat((boolean)hasFull).isTrue();
    }

    @SafeVarargs
    private final FileLogRecords createFileLogRecords(RowType rowType, List<Object[]> ... inputs) throws Exception {
        FileLogRecords fileLogRecords = FileLogRecords.open((File)new File(this.tempDir, "test.tmp"));
        long offsetBase = 0L;
        for (List<Object[]> input : inputs) {
            fileLogRecords.append(DataTestUtils.createRecordsWithoutBaseLogOffset(rowType, 1, offsetBase, System.currentTimeMillis(), input));
            offsetBase += (long)input.size();
        }
        fileLogRecords.flush();
        return fileLogRecords;
    }

    private List<Object[]> doProjection(FileLogProjection projection, FileLogRecords fileLogRecords, RowType rowType, int[] projectedFields, int fetchMaxBytes) throws Exception {
        projection.setCurrentProjection(1L, rowType, projectedFields);
        RowType projectedType = rowType.project(projectedFields);
        BytesViewLogRecords project = projection.project(fileLogRecords.channel(), 0, fileLogRecords.sizeInBytes(), fetchMaxBytes);
        Assertions.assertThat((int)project.sizeInBytes()).isLessThanOrEqualTo(fetchMaxBytes);
        ArrayList<Object[]> results = new ArrayList<Object[]>();
        long expectedOffset = 0L;
        try (LogRecordReadContext context = LogRecordReadContext.createArrowReadContext((RowType)projectedType, (int)1);){
            for (LogRecordBatch batch : project.batches()) {
                CloseableIterator records = batch.records((LogRecordBatch.ReadContext)context);
                Throwable throwable = null;
                try {
                    while (records.hasNext()) {
                        LogRecord record = (LogRecord)records.next();
                        Assertions.assertThat((long)record.logOffset()).isEqualTo(expectedOffset);
                        Assertions.assertThat((Comparable)record.getRowKind()).isEqualTo((Object)RowKind.APPEND_ONLY);
                        InternalRow row = record.getRow();
                        Assertions.assertThat((int)row.getFieldCount()).isEqualTo(projectedFields.length);
                        Object[] objs = new Object[projectedFields.length];
                        block24: for (int i = 0; i < projectedFields.length; ++i) {
                            if (row.isNullAt(i)) {
                                objs[i] = null;
                                continue;
                            }
                            switch (projectedType.getTypeAt(i).getTypeRoot()) {
                                case INTEGER: {
                                    objs[i] = row.getInt(i);
                                    continue block24;
                                }
                                case STRING: {
                                    objs[i] = row.getString(i).toString();
                                    continue block24;
                                }
                                default: {
                                    throw new IllegalArgumentException("Unsupported type: " + projectedType.getTypeAt(i));
                                }
                            }
                        }
                        results.add(objs);
                        ++expectedOffset;
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (records == null) continue;
                    if (throwable != null) {
                        try {
                            records.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    records.close();
                }
            }
        }
        return results;
    }

    private static void assertEquals(List<Object[]> actual, List<Object[]> expected) {
        Assertions.assertThat((int)actual.size()).isEqualTo(expected.size());
        for (int i = 0; i < actual.size(); ++i) {
            Assertions.assertThat((Object[])actual.get(i)).isEqualTo((Object)expected.get(i));
        }
    }
}

