/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.record;

import com.alibaba.fluss.exception.FlussRuntimeException;
import com.alibaba.fluss.record.FileLogRecords;
import com.alibaba.fluss.record.LogRecordBatch;
import com.alibaba.fluss.record.LogRecords;
import com.alibaba.fluss.record.LogTestBase;
import com.alibaba.fluss.record.MemoryLogRecords;
import com.alibaba.fluss.record.TestData;
import com.alibaba.fluss.record.TimestampAndOffset;
import com.alibaba.fluss.shaded.guava32.com.google.common.collect.Lists;
import com.alibaba.fluss.testutils.DataTestUtils;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class FileLogRecordsTest
extends LogTestBase {
    @TempDir
    private File tempDir;
    private List<MemoryLogRecords> values;
    private FileLogRecords fileLogRecords;

    @BeforeEach
    void setup() throws Exception {
        this.values = Arrays.asList(DataTestUtils.genMemoryLogRecordsWithBaseOffset(0L, Collections.singletonList(new Object[]{0, " abcd"})), DataTestUtils.genMemoryLogRecordsWithBaseOffset(1L, Collections.singletonList(new Object[]{1, " efgh"})), DataTestUtils.genMemoryLogRecordsWithBaseOffset(2L, Collections.singletonList(new Object[]{2, " hijk"})));
        this.fileLogRecords = this.createFileLogRecords();
    }

    @AfterEach
    void tearDown() throws Exception {
        this.fileLogRecords.close();
    }

    @Test
    void testAppendProtectsFromOverflow() throws Exception {
        File fileMock = (File)Mockito.mock(File.class);
        FileChannel fileChannelMock = (FileChannel)Mockito.mock(FileChannel.class);
        Mockito.when((Object)fileChannelMock.size()).thenReturn((Object)Integer.MAX_VALUE);
        FileLogRecords records = new FileLogRecords(fileMock, fileChannelMock, 0, Integer.MAX_VALUE, false);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> records.append(DataTestUtils.genMemoryLogRecordsWithBaseOffset(1L, Collections.singletonList(new Object[]{1, "efgh"})))).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("bytes is too large for segment with current file position");
    }

    @Test
    void testOpenOversizeFile() throws Exception {
        File fileMock = (File)Mockito.mock(File.class);
        FileChannel fileChannelMock = (FileChannel)Mockito.mock(FileChannel.class);
        Mockito.when((Object)fileChannelMock.size()).thenReturn((Object)0x80000004L);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new FileLogRecords(fileMock, fileChannelMock, 0, 100, false)).isInstanceOf(FlussRuntimeException.class)).hasMessageContaining("larger than the maximum allowed segment size");
    }

    @Test
    void testOutOfRangeSlice() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.fileLogRecords.slice(this.fileLogRecords.sizeInBytes() + 1, 15).sizeInBytes()).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("exceeds end position of FileRecords");
    }

    @Test
    void testFileSize() throws Exception {
        Assertions.assertThat((int)this.fileLogRecords.sizeInBytes()).isEqualTo(this.fileLogRecords.channel().size());
        for (int i = 3; i < 13; ++i) {
            this.fileLogRecords.append(DataTestUtils.genMemoryLogRecordsWithBaseOffset(i, Collections.singletonList(new Object[]{i, "ijkl"})));
            Assertions.assertThat((int)this.fileLogRecords.sizeInBytes()).isEqualTo(this.fileLogRecords.channel().size());
        }
    }

    @Test
    void testIterationOverPartialAndTruncation() throws Exception {
        this.testPartialWrite(0, this.fileLogRecords);
        this.testPartialWrite(2, this.fileLogRecords);
        this.testPartialWrite(4, this.fileLogRecords);
        this.testPartialWrite(5, this.fileLogRecords);
        this.testPartialWrite(6, this.fileLogRecords);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testSliceSizeLimitWithConcurrentWrite() throws Exception {
        FileLogRecords log = FileLogRecords.open((File)new File(this.tempDir, "test2.tmp"));
        ExecutorService executor = Executors.newFixedThreadPool(2);
        int maxSizeInBytes = 16384;
        try {
            Future<Object> readerCompletion = executor.submit(() -> {
                while (log.sizeInBytes() < maxSizeInBytes) {
                    int currentSize = log.sizeInBytes();
                    FileLogRecords slice = log.slice(0, currentSize);
                    Assertions.assertThat((int)slice.sizeInBytes()).isEqualTo(currentSize);
                }
                return null;
            });
            Future<Object> writerCompletion = executor.submit(() -> {
                while (log.sizeInBytes() < maxSizeInBytes) {
                    this.append(log, this.values);
                }
                return null;
            });
            writerCompletion.get();
            readerCompletion.get();
        }
        finally {
            executor.shutdownNow();
        }
    }

    @Test
    void testIterationDoesntChangePosition() throws IOException {
        long position = this.fileLogRecords.channel().position();
        Iterator fileLogRecordsIterator = this.fileLogRecords.batches().iterator();
        for (MemoryLogRecords value : this.values) {
            Assertions.assertThat((boolean)fileLogRecordsIterator.hasNext()).isTrue();
            DataTestUtils.assertLogRecordBatchEquals(TestData.DATA1_ROW_TYPE, (LogRecordBatch)fileLogRecordsIterator.next(), (LogRecordBatch)value.batchIterator().next());
        }
        Assertions.assertThat((long)this.fileLogRecords.channel().position()).isEqualTo(position);
    }

    @Test
    void testRead() throws Exception {
        FileLogRecords read = this.fileLogRecords.slice(0, this.fileLogRecords.sizeInBytes());
        Assertions.assertThat((int)read.sizeInBytes()).isEqualTo(this.fileLogRecords.sizeInBytes());
        DataTestUtils.assertLogRecordsEquals(TestData.DATA1_ROW_TYPE, (LogRecords)read, (LogRecords)this.fileLogRecords);
        List<LogRecordBatch> items = FileLogRecordsTest.batches(read);
        LogRecordBatch first = items.get(0);
        read = this.fileLogRecords.slice(first.sizeInBytes(), this.fileLogRecords.sizeInBytes() - first.sizeInBytes());
        Assertions.assertThat((int)read.sizeInBytes()).isEqualTo(this.fileLogRecords.sizeInBytes() - first.sizeInBytes());
        Assertions.assertThat(FileLogRecordsTest.batches(read)).isEqualTo(items.subList(1, items.size()));
        read = this.fileLogRecords.slice(first.sizeInBytes(), this.fileLogRecords.sizeInBytes());
        Assertions.assertThat((int)read.sizeInBytes()).isEqualTo(this.fileLogRecords.sizeInBytes() - first.sizeInBytes());
        Assertions.assertThat(FileLogRecordsTest.batches(read)).isEqualTo(items.subList(1, items.size()));
        read = this.fileLogRecords.slice(first.sizeInBytes(), Integer.MAX_VALUE);
        Assertions.assertThat((int)read.sizeInBytes()).isEqualTo(this.fileLogRecords.sizeInBytes() - first.sizeInBytes());
        Assertions.assertThat(FileLogRecordsTest.batches(read)).isEqualTo(items.subList(1, items.size()));
        read = this.fileLogRecords.slice(1, this.fileLogRecords.sizeInBytes() - 1).slice(first.sizeInBytes() - 1, this.fileLogRecords.sizeInBytes());
        Assertions.assertThat((int)read.sizeInBytes()).isEqualTo(this.fileLogRecords.sizeInBytes() - first.sizeInBytes());
        Assertions.assertThat(FileLogRecordsTest.batches(read)).isEqualTo(items.subList(1, items.size()));
        read = this.fileLogRecords.slice(1, this.fileLogRecords.sizeInBytes() - 1).slice(first.sizeInBytes() - 1, Integer.MAX_VALUE);
        Assertions.assertThat((int)read.sizeInBytes()).isEqualTo(this.fileLogRecords.sizeInBytes() - first.sizeInBytes());
        Assertions.assertThat(FileLogRecordsTest.batches(read)).isEqualTo(items.subList(1, items.size()));
        LogRecordBatch second = items.get(1);
        read = this.fileLogRecords.slice(first.sizeInBytes(), second.sizeInBytes());
        Assertions.assertThat((int)read.sizeInBytes()).isEqualTo(second.sizeInBytes());
        Assertions.assertThat(FileLogRecordsTest.batches(read)).isEqualTo(Collections.singletonList(second));
    }

    @Test
    void testSearch() throws Exception {
        this.fileLogRecords.append(DataTestUtils.genMemoryLogRecordsWithBaseOffset(50L, Collections.singletonList(new Object[]{0, " test"})));
        List<LogRecordBatch> batches = FileLogRecordsTest.batches(this.fileLogRecords);
        int position = 0;
        int message1Size = batches.get(0).sizeInBytes();
        Assertions.assertThat((Object)this.fileLogRecords.searchForOffsetWithSize(0L, 0)).isEqualTo((Object)new FileLogRecords.LogOffsetPosition(0L, position, message1Size));
        int message2Size = batches.get(1).sizeInBytes();
        Assertions.assertThat((Object)this.fileLogRecords.searchForOffsetWithSize(1L, 0)).isEqualTo((Object)new FileLogRecords.LogOffsetPosition(1L, position += message1Size, message2Size));
        Assertions.assertThat((Object)this.fileLogRecords.searchForOffsetWithSize(1L, position)).isEqualTo((Object)new FileLogRecords.LogOffsetPosition(1L, position, message2Size));
        int message4Size = batches.get(3).sizeInBytes();
        Assertions.assertThat((Object)this.fileLogRecords.searchForOffsetWithSize(3L, position += message2Size + batches.get(2).sizeInBytes())).isEqualTo((Object)new FileLogRecords.LogOffsetPosition(50L, position, message4Size));
        Assertions.assertThat((Object)this.fileLogRecords.searchForOffsetWithSize(50L, position)).isEqualTo((Object)new FileLogRecords.LogOffsetPosition(50L, position, message4Size));
    }

    @Test
    void testIteratorWithLimits() throws Exception {
        LogRecordBatch batch = FileLogRecordsTest.batches(this.fileLogRecords).get(1);
        int start = this.fileLogRecords.searchForOffsetWithSize((long)1L, (int)0).position;
        int size = batch.sizeInBytes();
        FileLogRecords slice = this.fileLogRecords.slice(start, size);
        Assertions.assertThat(FileLogRecordsTest.batches(slice)).isEqualTo(Collections.singletonList(batch));
        FileLogRecords slice2 = this.fileLogRecords.slice(start, size - 1);
        Assertions.assertThat(FileLogRecordsTest.batches(slice2)).isEqualTo(Collections.emptyList());
    }

    @Test
    void testTruncate() throws Exception {
        LogRecordBatch batch = FileLogRecordsTest.batches(this.fileLogRecords).get(0);
        int end = this.fileLogRecords.searchForOffsetWithSize((long)1L, (int)0).position;
        this.fileLogRecords.truncateTo(end);
        Assertions.assertThat(FileLogRecordsTest.batches(this.fileLogRecords)).isEqualTo(Collections.singletonList(batch));
        Assertions.assertThat((int)this.fileLogRecords.sizeInBytes()).isEqualTo(batch.sizeInBytes());
    }

    @Test
    void testTruncateNotCalledIfSizeIsSameAsTargetSize() throws Exception {
        FileChannel channelMock = (FileChannel)Mockito.mock(FileChannel.class);
        Mockito.when((Object)channelMock.size()).thenReturn((Object)42L);
        Mockito.when((Object)channelMock.position(42L)).thenReturn(null);
        FileLogRecords fileRecords = new FileLogRecords(new File(this.tempDir, "test2.tmp"), channelMock, 0, Integer.MAX_VALUE, false);
        fileRecords.truncateTo(42);
        ((FileChannel)Mockito.verify((Object)channelMock, (VerificationMode)Mockito.atLeastOnce())).size();
        ((FileChannel)Mockito.verify((Object)channelMock, (VerificationMode)Mockito.times((int)0))).truncate(ArgumentMatchers.anyLong());
    }

    @Test
    void testTruncateNotCalledIfSizeIsBiggerThanTargetSize() throws Exception {
        FileChannel channelMock = (FileChannel)Mockito.mock(FileChannel.class);
        Mockito.when((Object)channelMock.size()).thenReturn((Object)42L);
        FileLogRecords fileRecords = new FileLogRecords(new File(this.tempDir, "test2.tmp"), channelMock, 0, Integer.MAX_VALUE, false);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> fileRecords.truncateTo(43)).isInstanceOf(FlussRuntimeException.class)).hasMessageContaining("Attempt to truncate log segment");
        ((FileChannel)Mockito.verify((Object)channelMock, (VerificationMode)Mockito.atLeastOnce())).size();
    }

    @Test
    void testTruncateIfSizeIsDifferentToTargetSize() throws Exception {
        FileChannel channelMock = (FileChannel)Mockito.mock(FileChannel.class);
        Mockito.when((Object)channelMock.size()).thenReturn((Object)42L);
        Mockito.when((Object)channelMock.truncate(ArgumentMatchers.anyLong())).thenReturn((Object)channelMock);
        FileLogRecords fileRecords = new FileLogRecords(new File(this.tempDir, "test2.tmp"), channelMock, 0, Integer.MAX_VALUE, false);
        fileRecords.truncateTo(23);
        ((FileChannel)Mockito.verify((Object)channelMock, (VerificationMode)Mockito.atLeastOnce())).size();
        ((FileChannel)Mockito.verify((Object)channelMock)).truncate(23L);
    }

    @Test
    void testPreallocateTrue() throws Exception {
        File tempFile = new File(this.tempDir, "test2.tmp");
        FileLogRecords log = FileLogRecords.open((File)tempFile, (boolean)false, (int)0x100000, (boolean)true);
        long position = log.channel().position();
        int size = log.sizeInBytes();
        Assertions.assertThat((long)position).isEqualTo(0L);
        Assertions.assertThat((int)size).isEqualTo(0);
        Assertions.assertThat((long)tempFile.length()).isEqualTo(0x100000L);
    }

    @Test
    void testPreallocateFalse() throws Exception {
        File tempFile = new File(this.tempDir, "test2.tmp");
        FileLogRecords log = FileLogRecords.open((File)tempFile, (boolean)false, (int)0x100000, (boolean)false);
        long position = log.channel().position();
        int size = log.sizeInBytes();
        Assertions.assertThat((long)position).isEqualTo(0L);
        Assertions.assertThat((int)size).isEqualTo(0);
        Assertions.assertThat((long)tempFile.length()).isEqualTo(0L);
    }

    @Test
    void testPreallocateClearShutdown() throws Exception {
        File tempFile = new File(this.tempDir, "test2.tmp");
        FileLogRecords log = FileLogRecords.open((File)tempFile, (boolean)false, (int)0x100000, (boolean)true);
        this.append(log, this.values);
        int oldPosition = (int)log.channel().position();
        int oldSize = log.sizeInBytes();
        Assertions.assertThat((int)oldPosition).isEqualTo(this.fileLogRecords.sizeInBytes());
        Assertions.assertThat((int)oldSize).isEqualTo(this.fileLogRecords.sizeInBytes());
        log.close();
        File tempReopen = new File(tempFile.getAbsolutePath());
        FileLogRecords setReopen = FileLogRecords.open((File)tempReopen, (boolean)true, (int)0x100000, (boolean)true);
        int position = (int)setReopen.channel().position();
        int size = setReopen.sizeInBytes();
        Assertions.assertThat((int)position).isEqualTo(oldPosition);
        Assertions.assertThat((int)size).isEqualTo(oldPosition);
        Assertions.assertThat((long)tempReopen.length()).isEqualTo((long)oldPosition);
    }

    @Test
    void testSearchForTimestamp() throws Exception {
        FileLogRecords log = FileLogRecords.open((File)new File(this.tempDir, "test2.tmp"));
        log.append(DataTestUtils.genLogRecordsWithBaseOffsetAndTimestamp(0L, 10L, TestData.DATA1));
        log.append(DataTestUtils.genLogRecordsWithBaseOffsetAndTimestamp(10L, 20L, TestData.DATA1));
        log.append(DataTestUtils.genLogRecordsWithBaseOffsetAndTimestamp(20L, 30L, TestData.DATA1));
        Assertions.assertThat((Object)log.searchForTimestamp(9L, 0, 0L)).isEqualTo((Object)new TimestampAndOffset(10L, 0L));
        Assertions.assertThat((Object)log.searchForTimestamp(10L, 0, 0L)).isEqualTo((Object)new TimestampAndOffset(10L, 0L));
        Assertions.assertThat((Object)log.searchForTimestamp(22L, 0, 0L)).isEqualTo((Object)new TimestampAndOffset(30L, 20L));
        Assertions.assertThat((Object)log.searchForTimestamp(30L, 0, 0L)).isEqualTo((Object)new TimestampAndOffset(30L, 20L));
        Assertions.assertThat((Object)log.searchForTimestamp(32L, 0, 0L)).isNull();
    }

    @Test
    void testLargestTimestampAfter() throws Exception {
        FileLogRecords log = FileLogRecords.open((File)new File(this.tempDir, "test2.tmp"));
        log.append(DataTestUtils.genLogRecordsWithBaseOffsetAndTimestamp(0L, 10L, TestData.DATA1));
        log.append(DataTestUtils.genLogRecordsWithBaseOffsetAndTimestamp(10L, 20L, TestData.DATA1));
        this.assertFoundTimestamp(new TimestampAndOffset(20L, 10L), log.largestTimestampAfter(0));
    }

    private void assertFoundTimestamp(TimestampAndOffset expected, TimestampAndOffset actual) {
        Assertions.assertThat((Object)actual).isNotNull();
        Assertions.assertThat((long)actual.getTimestamp()).isEqualTo(expected.getTimestamp());
        Assertions.assertThat((long)actual.getOffset()).isEqualTo(expected.getOffset());
    }

    private FileLogRecords createFileLogRecords() throws Exception {
        FileLogRecords fileRecords = FileLogRecords.open((File)new File(this.tempDir, "test.tmp"));
        this.append(fileRecords, this.values);
        fileRecords.flush();
        return fileRecords;
    }

    private void append(FileLogRecords fileLogRecords, List<MemoryLogRecords> values) throws Exception {
        for (MemoryLogRecords records : values) {
            fileLogRecords.append(records);
        }
        fileLogRecords.flush();
    }

    private void testPartialWrite(int size, FileLogRecords fileRecords) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(size);
        for (int i = 0; i < size; ++i) {
            buffer.put((byte)0);
        }
        buffer.rewind();
        fileRecords.channel().write(buffer);
        this.assertLogRecordsListEquals(this.values, (LogRecords)fileRecords);
    }

    private static List<LogRecordBatch> batches(FileLogRecords fileLogRecords) {
        return Lists.newArrayList((Iterable)fileLogRecords.batches());
    }
}

