/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.record;

import com.alibaba.fluss.memory.MemorySegmentOutputView;
import com.alibaba.fluss.metadata.KvFormat;
import com.alibaba.fluss.record.DefaultKvRecordBatch;
import com.alibaba.fluss.record.KvRecord;
import com.alibaba.fluss.record.KvRecordBatch;
import com.alibaba.fluss.row.BinaryRow;
import com.alibaba.fluss.row.InternalRow;
import com.alibaba.fluss.row.compacted.CompactedRow;
import com.alibaba.fluss.row.encode.KeyEncoder;
import com.alibaba.fluss.testutils.DataTestUtils;
import com.alibaba.fluss.types.RowType;
import com.alibaba.fluss.utils.BytesUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class KvRecordTestUtils {
    private KvRecordTestUtils() {
    }

    private static class SimpleTestKvRecord
    implements KvRecord {
        private final byte[] key;
        private final BinaryRow row;

        SimpleTestKvRecord(byte[] key, @Nullable BinaryRow row) {
            this.key = key;
            this.row = row;
        }

        public ByteBuffer getKey() {
            return ByteBuffer.wrap(this.key);
        }

        public BinaryRow getRow() {
            return this.row;
        }

        public int getSizeInBytes() {
            throw new UnsupportedOperationException();
        }
    }

    public static class PKBasedKvRecordFactory {
        private final RowType rowType;
        private final KeyEncoder keyEncoder;

        private PKBasedKvRecordFactory(RowType rowType, int[] pkIndex) {
            this.rowType = rowType;
            this.keyEncoder = new KeyEncoder(rowType, pkIndex);
        }

        public static PKBasedKvRecordFactory of(RowType rowType, int[] pkIndex) {
            return new PKBasedKvRecordFactory(rowType, pkIndex);
        }

        public KvRecord ofRecord(@Nonnull Object[] value) {
            CompactedRow row = DataTestUtils.compactedRow(this.rowType, value);
            return new SimpleTestKvRecord(this.keyEncoder.encode((InternalRow)row), (BinaryRow)row);
        }
    }

    public static class KvRecordFactory {
        private final RowType rowType;

        private KvRecordFactory(RowType rowType) {
            this.rowType = rowType;
        }

        public static KvRecordFactory of(RowType rowType) {
            return new KvRecordFactory(rowType);
        }

        public KvRecord ofRecord(byte[] key, @Nullable Object[] value) {
            if (value == null) {
                return new SimpleTestKvRecord(key, null);
            }
            return new SimpleTestKvRecord(key, (BinaryRow)DataTestUtils.compactedRow(this.rowType, value));
        }

        public KvRecord ofRecord(String key, @Nullable Object[] value) {
            return this.ofRecord(key.getBytes(), value);
        }
    }

    public static class KvRecordBatchFactory {
        private final int schemaId;

        KvRecordBatchFactory(int schemaId) {
            this.schemaId = schemaId;
        }

        public static KvRecordBatchFactory of(int schemaId) {
            return new KvRecordBatchFactory(schemaId);
        }

        public KvRecordBatch ofRecords(KvRecord ... kvRecord) throws IOException {
            return this.ofRecords(Arrays.asList(kvRecord));
        }

        public KvRecordBatch ofRecords(List<KvRecord> records) throws IOException {
            return this.ofRecords(records, -1L, -1);
        }

        public KvRecordBatch ofRecords(List<KvRecord> records, long writeClientId, int batchSequenceId) throws IOException {
            MemorySegmentOutputView outputView = new MemorySegmentOutputView(100);
            DefaultKvRecordBatch.Builder builder = DefaultKvRecordBatch.Builder.builder((int)this.schemaId, (MemorySegmentOutputView)outputView, (KvFormat)KvFormat.COMPACTED);
            for (KvRecord kvRecord : records) {
                builder.append(BytesUtils.toArray((ByteBuffer)kvRecord.getKey()), (InternalRow)kvRecord.getRow());
            }
            builder.setWriterState(writeClientId, batchSequenceId);
            DefaultKvRecordBatch kvRecords = builder.build();
            kvRecords.ensureValid();
            return kvRecords;
        }
    }
}

