/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.record;

import com.alibaba.fluss.record.FileLogRecords;
import com.alibaba.fluss.record.LogRecordBatch;
import com.alibaba.fluss.record.LogTestBase;
import com.alibaba.fluss.record.MemoryLogRecords;
import com.alibaba.fluss.row.TestInternalRowGenerator;
import com.alibaba.fluss.row.indexed.IndexedRow;
import com.alibaba.fluss.testutils.DataTestUtils;
import com.alibaba.fluss.types.RowType;
import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

final class LogRecordsTest
extends LogTestBase {
    @TempDir
    private File tempDir;
    private File file;
    private FileChannel fileChannel;
    private FileLogRecords fileLogRecords;

    LogRecordsTest() {
    }

    @Override
    @BeforeEach
    protected void before() throws IOException {
        super.before();
        this.file = new File(this.tempDir, "test.log");
        this.file.createNewFile();
        this.fileChannel = FileChannel.open(this.file.toPath(), StandardOpenOption.READ, StandardOpenOption.WRITE);
    }

    @Test
    void testSimpleData() throws Exception {
        Object[] objects1 = new Object[]{1, "1"};
        Object[] objects2 = new Object[]{2, "2"};
        List<IndexedRow> rows1 = Arrays.asList(DataTestUtils.row(this.baseRowType, objects1), DataTestUtils.row(this.baseRowType, objects2));
        MemoryLogRecords memoryLogRecords1 = DataTestUtils.genIndexedMemoryLogRecords(rows1);
        this.fileLogRecords = new FileLogRecords(this.file, this.fileChannel, 0, Integer.MAX_VALUE, false);
        this.fileLogRecords.append(memoryLogRecords1);
        Iterator iterator = this.fileLogRecords.batches().iterator();
        Iterator memoryIterator = memoryLogRecords1.batches().iterator();
        Assertions.assertThat((boolean)iterator.hasNext()).isTrue();
        Assertions.assertThat((boolean)memoryIterator.hasNext()).isTrue();
        this.assertIndexedLogRecordBatchAndRowEquals((LogRecordBatch)iterator.next(), (LogRecordBatch)memoryIterator.next(), this.baseRowType, rows1);
        Assertions.assertThat((boolean)iterator.hasNext()).isFalse();
        Assertions.assertThat((boolean)memoryIterator.hasNext()).isFalse();
    }

    @Test
    void testAllTypeData() throws Exception {
        RowType allRowType = TestInternalRowGenerator.createAllRowType();
        List<IndexedRow> rows1 = this.createAllTypeRowDataList();
        MemoryLogRecords memoryLogRecords1 = DataTestUtils.genIndexedMemoryLogRecords(rows1);
        this.fileLogRecords = new FileLogRecords(this.file, this.fileChannel, 0, Integer.MAX_VALUE, false);
        this.fileLogRecords.append(memoryLogRecords1);
        Iterator iterator = this.fileLogRecords.batches().iterator();
        Iterator memoryIterator = memoryLogRecords1.batches().iterator();
        Assertions.assertThat((boolean)iterator.hasNext()).isTrue();
        Assertions.assertThat((boolean)memoryIterator.hasNext()).isTrue();
        this.assertIndexedLogRecordBatchAndRowEquals((LogRecordBatch)iterator.next(), (LogRecordBatch)memoryIterator.next(), allRowType, rows1);
        Assertions.assertThat((boolean)iterator.hasNext()).isFalse();
        Assertions.assertThat((boolean)memoryIterator.hasNext()).isFalse();
    }

    @AfterEach
    public void after() throws IOException {
        if (this.fileLogRecords != null) {
            this.fileLogRecords.close();
        }
    }
}

