/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.record;

import com.alibaba.fluss.config.Configuration;
import com.alibaba.fluss.memory.MemorySegmentOutputView;
import com.alibaba.fluss.record.DefaultLogRecord;
import com.alibaba.fluss.record.LogRecord;
import com.alibaba.fluss.record.LogRecordBatch;
import com.alibaba.fluss.record.LogRecordReadContext;
import com.alibaba.fluss.record.LogRecords;
import com.alibaba.fluss.record.MemoryLogRecords;
import com.alibaba.fluss.record.RowKind;
import com.alibaba.fluss.record.TestData;
import com.alibaba.fluss.row.TestInternalRowGenerator;
import com.alibaba.fluss.row.indexed.IndexedRow;
import com.alibaba.fluss.testutils.ListLogRecords;
import com.alibaba.fluss.testutils.LogRecordsAssert;
import com.alibaba.fluss.types.RowType;
import com.alibaba.fluss.utils.CloseableIterator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.BeforeEach;

public abstract class LogTestBase {
    protected final short schemaId = 1;
    protected final byte magic = 0;
    protected final long baseLogOffset = 0L;
    protected final int position = 0;
    protected final RowType baseRowType = TestData.DATA1_ROW_TYPE;
    protected final MemorySegmentOutputView outputView = new MemorySegmentOutputView(100);
    protected Configuration conf;

    @BeforeEach
    protected void before() throws IOException {
        this.conf = new Configuration();
    }

    protected List<IndexedRow> createAllTypeRowDataList() {
        ArrayList<IndexedRow> allTypeRows = new ArrayList<IndexedRow>();
        for (int i = 0; i < 50; ++i) {
            IndexedRow row = TestInternalRowGenerator.genIndexedRowForAllType();
            allTypeRows.add(row);
        }
        return allTypeRows;
    }

    public static void assertLogRecordsListEquals(List<MemoryLogRecords> expected, LogRecords actual, RowType rowType) {
        LogRecordsAssert.assertThatLogRecords(actual).withSchema(rowType).isEqualTo(new ListLogRecords(expected));
    }

    protected void assertLogRecordsListEquals(List<MemoryLogRecords> expected, LogRecords actual) {
        LogTestBase.assertLogRecordsListEquals(expected, actual, this.baseRowType);
    }

    protected void assertIndexedLogRecordBatchAndRowEquals(LogRecordBatch actual, LogRecordBatch expected, RowType rowType, List<IndexedRow> rows) {
        this.assertRecordBatchHeaderEquals(actual);
        LogRecordReadContext readContext = LogRecordReadContext.createIndexedReadContext((RowType)rowType, (int)1);
        try (CloseableIterator actualIter = actual.records((LogRecordBatch.ReadContext)readContext);
             CloseableIterator expectIter = expected.records((LogRecordBatch.ReadContext)readContext);){
            int i = 0;
            while (actualIter.hasNext() && expectIter.hasNext()) {
                DefaultLogRecord actualRecord = (DefaultLogRecord)actualIter.next();
                DefaultLogRecord expectedRecord = (DefaultLogRecord)expectIter.next();
                this.assertIndexedRecordEquals((LogRecord)actualRecord, (LogRecord)expectedRecord, rows.get(i), i);
                ++i;
            }
        }
    }

    private void assertIndexedRecordEquals(LogRecord actualRecord, LogRecord expectedRecord, IndexedRow row, int offsetDelta) {
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)actualRecord.getRowKind()).isEqualTo((Object)expectedRecord.getRowKind())).isEqualTo((Object)RowKind.APPEND_ONLY);
        Assertions.assertThat((long)actualRecord.logOffset()).isEqualTo(expectedRecord.logOffset()).isEqualTo(0L + (long)offsetDelta);
        ((ObjectAssert)Assertions.assertThat((Object)actualRecord.getRow()).isEqualTo((Object)expectedRecord.getRow())).isEqualTo((Object)row);
    }

    private void assertRecordBatchHeaderEquals(LogRecordBatch recordBatch) {
        Assertions.assertThat((long)recordBatch.baseLogOffset()).isEqualTo(0L);
        Assertions.assertThat((byte)recordBatch.magic()).isEqualTo((byte)0);
        Assertions.assertThat((boolean)recordBatch.isValid()).isTrue();
        Assertions.assertThat((short)recordBatch.schemaId()).isEqualTo((short)1);
    }
}

