/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.record;

import com.alibaba.fluss.config.ConfigOptions;
import com.alibaba.fluss.config.Configuration;
import com.alibaba.fluss.config.MemorySize;
import com.alibaba.fluss.memory.AbstractPagedOutputView;
import com.alibaba.fluss.memory.LazyMemorySegmentPool;
import com.alibaba.fluss.memory.ManagedPagedOutputView;
import com.alibaba.fluss.memory.MemorySegmentPool;
import com.alibaba.fluss.record.LogRecordBatch;
import com.alibaba.fluss.record.LogRecords;
import com.alibaba.fluss.record.MemoryLogRecords;
import com.alibaba.fluss.record.MemoryLogRecordsArrowBuilder;
import com.alibaba.fluss.record.RowKind;
import com.alibaba.fluss.record.TestData;
import com.alibaba.fluss.row.InternalRow;
import com.alibaba.fluss.row.arrow.ArrowWriter;
import com.alibaba.fluss.row.arrow.ArrowWriterPool;
import com.alibaba.fluss.shaded.arrow.org.apache.arrow.memory.BufferAllocator;
import com.alibaba.fluss.shaded.arrow.org.apache.arrow.memory.RootAllocator;
import com.alibaba.fluss.testutils.DataTestUtils;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.RandomUtils;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class MemoryLogRecordsArrowBuilderTest {
    private BufferAllocator allocator;
    private ArrowWriterPool provider;
    private Configuration conf;

    @BeforeEach
    void setup() {
        this.allocator = new RootAllocator(Long.MAX_VALUE);
        this.provider = new ArrowWriterPool(this.allocator);
        this.conf = new Configuration();
    }

    @AfterEach
    void tearDown() {
        this.provider.close();
        this.allocator.close();
    }

    @Test
    void testAppendWithEmptyRecord() throws Exception {
        int maxSizeInBytes = 1024;
        ArrowWriter writer = this.provider.getOrCreateWriter(1L, 1, maxSizeInBytes, TestData.DATA1_ROW_TYPE);
        MemoryLogRecordsArrowBuilder builder = this.createMemoryLogRecordsArrowBuilder(writer, 10, 100);
        Assertions.assertThat((boolean)builder.isFull()).isFalse();
        Assertions.assertThat((int)builder.getMaxSizeInBytes()).isEqualTo(maxSizeInBytes);
        builder.close();
        builder.serialize();
        builder.setWriterState(1L, 0);
        MemoryLogRecords records = MemoryLogRecords.pointToByteBuffer((ByteBuffer)builder.build().getByteBuf().nioBuffer());
        Iterator iterator = records.batches().iterator();
        Assertions.assertThat((boolean)iterator.hasNext()).isTrue();
        LogRecordBatch batch = (LogRecordBatch)iterator.next();
        Assertions.assertThat((int)batch.getRecordCount()).isEqualTo(0);
        Assertions.assertThat((int)batch.sizeInBytes()).isEqualTo(44);
        Assertions.assertThat((boolean)iterator.hasNext()).isFalse();
    }

    @Test
    void testAppend() throws Exception {
        int maxSizeInBytes = 1024;
        ArrowWriter writer = this.provider.getOrCreateWriter(1L, 1, maxSizeInBytes, TestData.DATA1_ROW_TYPE);
        MemoryLogRecordsArrowBuilder builder = this.createMemoryLogRecordsArrowBuilder(writer, 10, 1024);
        List rowKinds = TestData.DATA1.stream().map(row -> RowKind.APPEND_ONLY).collect(Collectors.toList());
        List rows = TestData.DATA1.stream().map(object -> DataTestUtils.row(TestData.DATA1_ROW_TYPE, object)).collect(Collectors.toList());
        ArrayList<Object[]> expectedResult = new ArrayList<Object[]>();
        while (!builder.isFull()) {
            int rndIndex = RandomUtils.nextInt((int)0, (int)TestData.DATA1.size());
            builder.append((RowKind)rowKinds.get(rndIndex), (InternalRow)rows.get(rndIndex));
            expectedResult.add(TestData.DATA1.get(rndIndex));
        }
        Assertions.assertThat((boolean)builder.isFull()).isTrue();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> builder.append(RowKind.APPEND_ONLY, (InternalRow)rows.get(0))).isInstanceOf(IllegalStateException.class)).hasMessage("The arrow batch size is full and it shouldn't accept writing new rows, it's a bug.");
        builder.setWriterState(1L, 0);
        builder.close();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> builder.append(RowKind.APPEND_ONLY, (InternalRow)rows.get(0))).isInstanceOf(IllegalStateException.class)).hasMessage("Tried to append a record, but MemoryLogRecordsArrowBuilder is closed for record appends");
        builder.serialize();
        Assertions.assertThat((boolean)builder.isClosed()).isTrue();
        MemoryLogRecords records = MemoryLogRecords.pointToByteBuffer((ByteBuffer)builder.build().getByteBuf().nioBuffer());
        DataTestUtils.assertLogRecordsEquals(TestData.DATA1_ROW_TYPE, (LogRecords)records, expectedResult);
    }

    @Test
    void testIllegalArgument() {
        int maxSizeInBytes = 1024;
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            try (ArrowWriter writer = this.provider.getOrCreateWriter(1L, 1, maxSizeInBytes, TestData.DATA1_ROW_TYPE);){
                this.createMemoryLogRecordsArrowBuilder(writer, 10, 30);
            }
        }).isInstanceOf(IllegalArgumentException.class)).hasMessage("The size of first segment of pagedOutputView is too small, need at least 44 bytes.");
    }

    private MemoryLogRecordsArrowBuilder createMemoryLogRecordsArrowBuilder(ArrowWriter writer, int maxPages, int pageSizeInBytes) {
        this.conf.set(ConfigOptions.CLIENT_WRITER_BUFFER_MEMORY_SIZE, (Object)new MemorySize((long)maxPages * (long)pageSizeInBytes));
        this.conf.set(ConfigOptions.CLIENT_WRITER_BUFFER_PAGE_SIZE, (Object)new MemorySize((long)pageSizeInBytes));
        this.conf.set(ConfigOptions.CLIENT_WRITER_BATCH_SIZE, (Object)new MemorySize((long)pageSizeInBytes));
        return MemoryLogRecordsArrowBuilder.builder((long)0L, (int)1, (ArrowWriter)writer, (AbstractPagedOutputView)new ManagedPagedOutputView((MemorySegmentPool)LazyMemorySegmentPool.create((Configuration)this.conf)));
    }
}

