/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.record;

import com.alibaba.fluss.record.LogRecords;
import com.alibaba.fluss.record.MemoryLogRecords;
import com.alibaba.fluss.record.TestData;
import com.alibaba.fluss.testutils.DataTestUtils;
import com.alibaba.fluss.testutils.LogRecordsAssert;
import java.nio.ByteBuffer;
import java.util.function.Function;
import org.junit.jupiter.api.Test;

class MemoryLogRecordsTest {
    MemoryLogRecordsTest() {
    }

    @Test
    void testPointToDirectByteBuffer() throws Exception {
        this.verifyPointToByteBuffer(ByteBuffer::allocateDirect);
    }

    @Test
    void testPointToDirectByteBufferWithShift() throws Exception {
        this.verifyPointToByteBuffer(size -> {
            ByteBuffer buffer = ByteBuffer.allocateDirect(size + 3);
            buffer.put(new byte[]{1, 2, 3});
            buffer.position(3);
            return buffer;
        });
    }

    @Test
    void testPointToHeapByteBuffer() throws Exception {
        this.verifyPointToByteBuffer(ByteBuffer::allocate);
    }

    @Test
    void testPointToHeapByteBufferWithShift() throws Exception {
        this.verifyPointToByteBuffer(size -> {
            ByteBuffer buffer = ByteBuffer.allocate(size + 3);
            buffer.put(new byte[]{1, 2, 3});
            buffer.position(3);
            return buffer;
        });
    }

    void verifyPointToByteBuffer(Function<Integer, ByteBuffer> bufferSupplier) throws Exception {
        int writerId = 1000;
        int seqno = 6;
        long baseOffset = 123L;
        MemoryLogRecords records = DataTestUtils.genMemoryLogRecordsWithWriterId(TestData.DATA1, writerId, seqno, baseOffset);
        ByteBuffer buffer = bufferSupplier.apply(records.sizeInBytes());
        int originPos = buffer.position();
        records.getMemorySegment().get(records.getPosition(), buffer, records.sizeInBytes());
        buffer.position(originPos);
        MemoryLogRecords newRecords = MemoryLogRecords.pointToByteBuffer((ByteBuffer)buffer);
        LogRecordsAssert.assertThatLogRecords((LogRecords)newRecords).hasBatchesCount(1).withSchema(TestData.DATA1_ROW_TYPE).isEqualTo((LogRecords)records);
    }
}

