/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.record;

import com.alibaba.fluss.record.LogRecordBatch;
import com.alibaba.fluss.record.MemoryLogRecords;
import com.alibaba.fluss.record.TestData;
import com.alibaba.fluss.testutils.DataTestUtils;
import java.util.Iterator;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class MemorySegmentLogInputStreamTest {
    @Test
    void testNextBatch() throws Exception {
        MemoryLogRecords memoryLogRecords = DataTestUtils.genMemoryLogRecordsByObject(TestData.DATA1);
        Iterator<LogRecordBatch> iterator = this.getIterator(memoryLogRecords);
        Assertions.assertThat((boolean)iterator.hasNext()).isTrue();
        memoryLogRecords = MemoryLogRecords.EMPTY;
        iterator = this.getIterator(memoryLogRecords);
        Assertions.assertThat((boolean)iterator.hasNext()).isFalse();
        memoryLogRecords = MemoryLogRecords.pointToBytes((byte[])new byte[11]);
        iterator = this.getIterator(memoryLogRecords);
        Assertions.assertThat((boolean)iterator.hasNext()).isFalse();
        memoryLogRecords = MemoryLogRecords.pointToBytes((byte[])new byte[11]);
        iterator = this.getIterator(memoryLogRecords);
        Assertions.assertThat((boolean)iterator.hasNext()).isFalse();
        memoryLogRecords = MemoryLogRecords.pointToBytes((byte[])new byte[12]);
        iterator = this.getIterator(memoryLogRecords);
        Assertions.assertThat((boolean)iterator.hasNext()).isTrue();
        memoryLogRecords = MemoryLogRecords.pointToBytes((byte[])new byte[12]);
        iterator = this.getIterator(memoryLogRecords);
        Assertions.assertThat((boolean)iterator.hasNext()).isTrue();
    }

    private Iterator<LogRecordBatch> getIterator(MemoryLogRecords memoryLogRecords) {
        return memoryLogRecords.batches().iterator();
    }
}

