/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.record.send;

import com.alibaba.fluss.memory.MemorySegment;
import com.alibaba.fluss.record.bytesview.BytesView;
import com.alibaba.fluss.record.bytesview.FileRegionBytesView;
import com.alibaba.fluss.record.bytesview.MemorySegmentBytesView;
import com.alibaba.fluss.record.bytesview.MultiBytesView;
import com.alibaba.fluss.record.send.Send;
import com.alibaba.fluss.record.send.SendWritableOutput;
import com.alibaba.fluss.row.BinaryString;
import com.alibaba.fluss.shaded.netty4.io.netty.buffer.ByteBuf;
import com.alibaba.fluss.shaded.netty4.io.netty.buffer.Unpooled;
import com.alibaba.fluss.testutils.ByteBufChannel;
import com.alibaba.fluss.utils.ProtoCodecUtils;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class SendWritableOutputTest {
    SendWritableOutputTest() {
    }

    @Test
    void testZeroCopyMemorySegment() {
        byte[] data = BinaryString.encodeUTF8((String)"foo");
        MemorySegment zeroCopySegment = MemorySegment.wrap((byte[])data);
        int bufSize = 12;
        ByteBuf buf = Unpooled.buffer((int)bufSize, (int)bufSize);
        SendWritableOutput out = new SendWritableOutput(buf);
        out.writeFixedInt32(5);
        out.writeBytes((BytesView)new MemorySegmentBytesView(zeroCopySegment, 0, data.length));
        out.writeFixedInt64(15L);
        Send send = out.buildSend();
        Assertions.assertThat((int)buf.refCnt()).isEqualTo(2);
        byte[] overwrittenData = BinaryString.encodeUTF8((String)"bar");
        Assertions.assertThat((int)overwrittenData.length).isEqualTo(data.length);
        zeroCopySegment.put(0, overwrittenData, 0, overwrittenData.length);
        ByteBuf outBuf = ByteBufChannel.toByteBuf(send);
        Assertions.assertThat((int)outBuf.readableBytes()).isEqualTo(bufSize + data.length);
        Assertions.assertThat((int)ProtoCodecUtils.readFixedInt32((ByteBuf)outBuf)).isEqualTo(5);
        Assertions.assertThat((String)SendWritableOutputTest.readString(outBuf, data.length)).isEqualTo("bar");
        Assertions.assertThat((long)ProtoCodecUtils.readFixedInt64((ByteBuf)outBuf)).isEqualTo(15L);
        Assertions.assertThat((int)buf.refCnt()).isEqualTo(0);
    }

    @Test
    void testZeroCopyFileRegion(@TempDir Path tempDir) throws IOException {
        Path tempFile = tempDir.resolve("send_zero_copy");
        byte[] data = BinaryString.encodeUTF8((String)"foo");
        Files.write(tempFile, data, new OpenOption[0]);
        FileChannel fileChannel = FileChannel.open(tempFile, new OpenOption[0]);
        FileRegionBytesView fr = new FileRegionBytesView(fileChannel, 0L, data.length);
        Assertions.assertThat((byte[])fr.getByteBuf().array()).isEqualTo((Object)data);
        int bufSize = 12;
        ByteBuf buf = Unpooled.buffer((int)bufSize, (int)bufSize);
        SendWritableOutput out = new SendWritableOutput(buf);
        out.writeFixedInt32(5);
        out.writeBytes((BytesView)fr);
        out.writeFixedInt64(15L);
        Send send = out.buildSend();
        Assertions.assertThat((int)buf.refCnt()).isEqualTo(2);
        byte[] overwrittenData = BinaryString.encodeUTF8((String)"bar");
        Assertions.assertThat((int)overwrittenData.length).isEqualTo(data.length);
        Files.write(tempFile, overwrittenData, new OpenOption[0]);
        ByteBuf outBuf = ByteBufChannel.toByteBuf(send);
        Assertions.assertThat((int)outBuf.readableBytes()).isEqualTo(bufSize + data.length);
        Assertions.assertThat((int)ProtoCodecUtils.readFixedInt32((ByteBuf)outBuf)).isEqualTo(5);
        Assertions.assertThat((String)SendWritableOutputTest.readString(outBuf, data.length)).isEqualTo("bar");
        Assertions.assertThat((long)ProtoCodecUtils.readFixedInt64((ByteBuf)outBuf)).isEqualTo(15L);
        Assertions.assertThat((int)buf.refCnt()).isEqualTo(0);
    }

    @Test
    void testZeroCopyPartialFileRegion(@TempDir Path tempDir) throws IOException {
        Path tempFile = tempDir.resolve("send_zero_copy");
        byte[] foo = BinaryString.encodeUTF8((String)"foo");
        Files.write(tempFile, foo, new OpenOption[0]);
        byte[] bar = BinaryString.encodeUTF8((String)"barbar");
        Files.write(tempFile, bar, StandardOpenOption.APPEND);
        FileChannel fileChannel = FileChannel.open(tempFile, new OpenOption[0]);
        FileRegionBytesView fr = new FileRegionBytesView(fileChannel, (long)foo.length, bar.length);
        int bufSize = 12;
        ByteBuf buf = Unpooled.buffer((int)bufSize, (int)bufSize);
        SendWritableOutput out = new SendWritableOutput(buf);
        out.writeFixedInt32(5);
        out.writeBytes((BytesView)fr);
        out.writeFixedInt64(15L);
        Send send = out.buildSend();
        Assertions.assertThat((int)buf.refCnt()).isEqualTo(2);
        byte[] appendedData = BinaryString.encodeUTF8((String)"baz");
        Files.write(tempFile, appendedData, StandardOpenOption.APPEND);
        ByteBuf outBuf = ByteBufChannel.toByteBuf(send);
        Assertions.assertThat((int)outBuf.readableBytes()).isEqualTo(bufSize + bar.length);
        Assertions.assertThat((int)ProtoCodecUtils.readFixedInt32((ByteBuf)outBuf)).isEqualTo(5);
        Assertions.assertThat((String)SendWritableOutputTest.readString(outBuf, bar.length)).isEqualTo("barbar");
        Assertions.assertThat((long)ProtoCodecUtils.readFixedInt64((ByteBuf)outBuf)).isEqualTo(15L);
        Assertions.assertThat((int)buf.refCnt()).isEqualTo(0);
    }

    @Test
    void testZeroCopyMultiBytesView(@TempDir Path tempDir) throws IOException {
        Path tempFile = tempDir.resolve("send_zero_copy");
        byte[] foo = BinaryString.encodeUTF8((String)"foo");
        Files.write(tempFile, foo, new OpenOption[0]);
        byte[] bar = BinaryString.encodeUTF8((String)"bar");
        Files.write(tempFile, bar, StandardOpenOption.APPEND);
        FileChannel fileChannel = FileChannel.open(tempFile, new OpenOption[0]);
        MemorySegment mem = MemorySegment.wrap((byte[])" world!".getBytes());
        MultiBytesView bv = MultiBytesView.builder().addBytes(fileChannel, 0L, foo.length).addBytes(" HELLO ".getBytes()).addBytes(fileChannel, (long)foo.length, bar.length).addBytes(mem, 0, mem.size()).build();
        Assertions.assertThat((int)bv.getBytesLength()).isEqualTo(20);
        Assertions.assertThat((int)bv.getZeroCopyLength()).isEqualTo(13);
        int bufSize = 12 + (bv.getBytesLength() - bv.getZeroCopyLength());
        ByteBuf buf = Unpooled.buffer((int)bufSize, (int)bufSize);
        SendWritableOutput out = new SendWritableOutput(buf);
        out.writeFixedInt32(5);
        out.writeBytes((BytesView)bv);
        out.writeFixedInt64(15L);
        Send send = out.buildSend();
        Assertions.assertThat((int)buf.refCnt()).isEqualTo(3);
        byte[] overwrittenData = BinaryString.encodeUTF8((String)"FOOBAR");
        Assertions.assertThat((int)overwrittenData.length).isEqualTo(foo.length + bar.length);
        Files.write(tempFile, overwrittenData, new OpenOption[0]);
        mem.put(0, " WORLD!".getBytes());
        ByteBuf outBuf = ByteBufChannel.toByteBuf(send);
        Assertions.assertThat((int)outBuf.readableBytes()).isEqualTo(bufSize + bv.getZeroCopyLength());
        Assertions.assertThat((int)ProtoCodecUtils.readFixedInt32((ByteBuf)outBuf)).isEqualTo(5);
        Assertions.assertThat((String)SendWritableOutputTest.readString(outBuf, bv.getBytesLength())).isEqualTo("FOO HELLO BAR WORLD!");
        Assertions.assertThat((long)ProtoCodecUtils.readFixedInt64((ByteBuf)outBuf)).isEqualTo(15L);
        Assertions.assertThat((int)buf.refCnt()).isEqualTo(0);
    }

    private static String readString(ByteBuf buf, int length) {
        byte[] bytes = new byte[length];
        buf.readBytes(bytes);
        return BinaryString.decodeUTF8((byte[])bytes, (int)0, (int)length);
    }
}

