/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.row;

import com.alibaba.fluss.memory.MemorySegment;
import com.alibaba.fluss.row.BinarySegmentUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class BinarySegmentUtilsTest {
    @Test
    public void testCopy() {
        MemorySegment[] segments = new MemorySegment[]{MemorySegment.wrap((byte[])new byte[]{0, 2, 5}), MemorySegment.wrap((byte[])new byte[]{6, 12, 15})};
        byte[] bytes = BinarySegmentUtils.copyToBytes((MemorySegment[])segments, (int)4, (int)2);
        Assertions.assertThat((byte[])bytes).isEqualTo((Object)new byte[]{12, 15});
    }

    @Test
    public void testEquals() {
        MemorySegment[] segments1 = new MemorySegment[]{MemorySegment.wrap((byte[])new byte[]{0, 2, 5}), MemorySegment.wrap((byte[])new byte[]{6, 12, 15}), MemorySegment.wrap((byte[])new byte[]{1, 1, 1})};
        MemorySegment[] segments2 = new MemorySegment[]{MemorySegment.wrap((byte[])new byte[]{6, 0, 2, 5}), MemorySegment.wrap((byte[])new byte[]{6, 12, 15, 18})};
        Assertions.assertThat((boolean)BinarySegmentUtils.equalsMultiSegments((MemorySegment[])segments1, (int)0, (MemorySegment[])segments2, (int)0, (int)0)).isTrue();
        Assertions.assertThat((boolean)BinarySegmentUtils.equals((MemorySegment[])segments1, (int)0, (MemorySegment[])segments2, (int)1, (int)3)).isTrue();
        Assertions.assertThat((boolean)BinarySegmentUtils.equals((MemorySegment[])segments1, (int)0, (MemorySegment[])segments2, (int)1, (int)6)).isTrue();
        Assertions.assertThat((boolean)BinarySegmentUtils.equals((MemorySegment[])segments1, (int)0, (MemorySegment[])segments2, (int)1, (int)7)).isFalse();
    }

    @Test
    public void testBoundaryEquals() {
        MemorySegment[] segments1 = new MemorySegment[]{MemorySegment.wrap((byte[])new byte[32]), MemorySegment.wrap((byte[])new byte[32])};
        MemorySegment[] segments2 = new MemorySegment[]{MemorySegment.wrap((byte[])new byte[16]), MemorySegment.wrap((byte[])new byte[16]), MemorySegment.wrap((byte[])new byte[16])};
        segments1[0].put(9, (byte)1);
        Assertions.assertThat((boolean)BinarySegmentUtils.equals((MemorySegment[])segments1, (int)0, (MemorySegment[])segments2, (int)14, (int)14)).isFalse();
        segments2[1].put(7, (byte)1);
        Assertions.assertThat((boolean)BinarySegmentUtils.equals((MemorySegment[])segments1, (int)0, (MemorySegment[])segments2, (int)14, (int)14)).isTrue();
        Assertions.assertThat((boolean)BinarySegmentUtils.equals((MemorySegment[])segments1, (int)2, (MemorySegment[])segments2, (int)16, (int)14)).isTrue();
        Assertions.assertThat((boolean)BinarySegmentUtils.equals((MemorySegment[])segments1, (int)2, (MemorySegment[])segments2, (int)16, (int)16)).isTrue();
        segments2[2].put(7, (byte)1);
        Assertions.assertThat((boolean)BinarySegmentUtils.equals((MemorySegment[])segments1, (int)2, (MemorySegment[])segments2, (int)32, (int)14)).isTrue();
    }

    @Test
    public void testBoundaryCopy() {
        MemorySegment[] segments1 = new MemorySegment[]{MemorySegment.wrap((byte[])new byte[32]), MemorySegment.wrap((byte[])new byte[32])};
        segments1[0].put(15, (byte)5);
        segments1[1].put(15, (byte)6);
        byte[] bytes = new byte[64];
        MemorySegment[] segments2 = new MemorySegment[]{MemorySegment.wrap((byte[])bytes)};
        BinarySegmentUtils.copyToBytes((MemorySegment[])segments1, (int)0, (byte[])bytes, (int)0, (int)64);
        Assertions.assertThat((boolean)BinarySegmentUtils.equals((MemorySegment[])segments1, (int)0, (MemorySegment[])segments2, (int)0, (int)64)).isTrue();
        bytes = new byte[64];
        segments2 = new MemorySegment[]{MemorySegment.wrap((byte[])bytes)};
        BinarySegmentUtils.copyToBytes((MemorySegment[])segments1, (int)32, (byte[])bytes, (int)0, (int)14);
        Assertions.assertThat((boolean)BinarySegmentUtils.equals((MemorySegment[])segments1, (int)32, (MemorySegment[])segments2, (int)0, (int)14)).isTrue();
        bytes = new byte[64];
        segments2 = new MemorySegment[]{MemorySegment.wrap((byte[])bytes)};
        BinarySegmentUtils.copyToBytes((MemorySegment[])segments1, (int)34, (byte[])bytes, (int)0, (int)14);
        Assertions.assertThat((boolean)BinarySegmentUtils.equals((MemorySegment[])segments1, (int)34, (MemorySegment[])segments2, (int)0, (int)14)).isTrue();
    }

    @Test
    public void testFind() {
        MemorySegment[] segments1 = new MemorySegment[]{MemorySegment.wrap((byte[])new byte[32]), MemorySegment.wrap((byte[])new byte[32])};
        MemorySegment[] segments2 = new MemorySegment[]{MemorySegment.wrap((byte[])new byte[16]), MemorySegment.wrap((byte[])new byte[16]), MemorySegment.wrap((byte[])new byte[16])};
        Assertions.assertThat((int)BinarySegmentUtils.find((MemorySegment[])segments1, (int)34, (int)0, (MemorySegment[])segments2, (int)0, (int)0)).isEqualTo(34);
        Assertions.assertThat((int)BinarySegmentUtils.find((MemorySegment[])segments1, (int)34, (int)0, (MemorySegment[])segments2, (int)0, (int)15)).isEqualTo(-1);
    }
}

