/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.row;

import com.alibaba.fluss.memory.MemorySegment;
import com.alibaba.fluss.row.BinaryString;
import com.alibaba.fluss.row.Decimal;
import com.alibaba.fluss.testutils.junit.parameterized.ParameterizedTestExtension;
import com.alibaba.fluss.testutils.junit.parameterized.Parameters;
import com.alibaba.fluss.utils.DecimalUtils;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class BinaryStringTest {
    private final BinaryString empty = this.fromString("");
    private final Mode mode;

    public BinaryStringTest(Mode mode) {
        this.mode = mode;
    }

    @Parameters(name="{0}")
    public static List<Mode> getVarSeg() {
        return Arrays.asList(Mode.ONE_SEG, Mode.MULTI_SEGS, Mode.STRING, Mode.RANDOM);
    }

    private BinaryString fromString(String str) {
        BinaryString string = BinaryString.fromString((String)str);
        Mode mode = this.mode;
        if (mode == Mode.RANDOM) {
            int rnd = new Random().nextInt(3);
            if (rnd == 0) {
                mode = Mode.ONE_SEG;
            } else if (rnd == 1) {
                mode = Mode.MULTI_SEGS;
            } else if (rnd == 2) {
                mode = Mode.STRING;
            }
        }
        if (mode == Mode.STRING) {
            return string;
        }
        if (mode == Mode.ONE_SEG || string.getSizeInBytes() < 2) {
            return string;
        }
        int numBytes = string.getSizeInBytes();
        int pad = new Random().nextInt(5);
        int numBytesWithPad = numBytes + pad;
        int segSize = numBytesWithPad / 2 + 1;
        byte[] bytes1 = new byte[segSize];
        byte[] bytes2 = new byte[segSize];
        if (segSize - pad > 0 && numBytes >= segSize - pad) {
            string.getSegments()[0].get(0, bytes1, pad, segSize - pad);
        }
        string.getSegments()[0].get(segSize - pad, bytes2, 0, numBytes - segSize + pad);
        return BinaryString.fromAddress((MemorySegment[])new MemorySegment[]{MemorySegment.wrap((byte[])bytes1), MemorySegment.wrap((byte[])bytes2)}, (int)pad, (int)numBytes);
    }

    private void checkBasic(String str, int len) {
        BinaryString s1 = this.fromString(str);
        BinaryString s2 = BinaryString.fromBytes((byte[])str.getBytes(StandardCharsets.UTF_8));
        Assertions.assertThat((int)len).isEqualTo(s1.numChars());
        Assertions.assertThat((int)len).isEqualTo(s2.numChars());
        Assertions.assertThat((String)str).isEqualTo(s1.toString());
        Assertions.assertThat((String)str).isEqualTo(s2.toString());
        Assertions.assertThat((Comparable)s2).isEqualTo((Object)s1);
        Assertions.assertThat((int)s2.hashCode()).isEqualTo(s1.hashCode());
        Assertions.assertThat((int)s1.compareTo(s2)).isEqualTo(0);
        Assertions.assertThat((boolean)s1.contains(s2)).isTrue();
        Assertions.assertThat((boolean)s2.contains(s1)).isTrue();
        Assertions.assertThat((boolean)s1.startsWith(s1)).isTrue();
        Assertions.assertThat((boolean)s1.endsWith(s1)).isTrue();
    }

    @TestTemplate
    public void basicTest() {
        this.checkBasic("", 0);
        this.checkBasic(",", 1);
        this.checkBasic("hello", 5);
        this.checkBasic("hello world", 11);
        this.checkBasic("Fluss\u4e2d\u6587\u793e\u533a", 9);
        this.checkBasic("\u4e2d \u6587 \u793e \u533a", 7);
        this.checkBasic("\u00a1", 1);
        this.checkBasic("\u043a\u0443", 2);
        this.checkBasic("\ufe3d\ufe4b\uff05", 3);
        this.checkBasic("\ud83e\udd19", 1);
    }

    @TestTemplate
    public void emptyStringTest() {
        Assertions.assertThat((Comparable)this.fromString("")).isEqualTo((Object)this.empty);
        Assertions.assertThat((Comparable)BinaryString.fromBytes((byte[])new byte[0])).isEqualTo((Object)this.empty);
        Assertions.assertThat((int)this.empty.numChars()).isEqualTo(0);
        Assertions.assertThat((int)this.empty.getSizeInBytes()).isEqualTo(0);
    }

    @TestTemplate
    public void compareTo() {
        Assertions.assertThat((int)this.fromString("   ").compareTo(BinaryString.blankString((int)3))).isEqualTo(0);
        Assertions.assertThat((int)this.fromString("").compareTo(this.fromString("a"))).isLessThan(0);
        Assertions.assertThat((int)this.fromString("abc").compareTo(this.fromString("ABC"))).isGreaterThan(0);
        Assertions.assertThat((int)this.fromString("abc0").compareTo(this.fromString("abc"))).isGreaterThan(0);
        Assertions.assertThat((int)this.fromString("abcabcabc").compareTo(this.fromString("abcabcabc"))).isEqualTo(0);
        Assertions.assertThat((int)this.fromString("aBcabcabc").compareTo(this.fromString("Abcabcabc"))).isGreaterThan(0);
        Assertions.assertThat((int)this.fromString("Abcabcabc").compareTo(this.fromString("abcabcabC"))).isLessThan(0);
        Assertions.assertThat((int)this.fromString("abcabcabc").compareTo(this.fromString("abcabcabC"))).isGreaterThan(0);
        Assertions.assertThat((int)this.fromString("abc").compareTo(this.fromString("\u4e16\u754c"))).isLessThan(0);
        Assertions.assertThat((int)this.fromString("\u4f60\u597d").compareTo(this.fromString("\u4e16\u754c"))).isGreaterThan(0);
        Assertions.assertThat((int)this.fromString("\u4f60\u597d123").compareTo(this.fromString("\u4f60\u597d122"))).isGreaterThan(0);
    }

    @TestTemplate
    public void testToBytes() {
        Assertions.assertThat((byte[])this.fromString("hello").toBytes()).isEqualTo((Object)new byte[]{104, 101, 108, 108, 111});
        Assertions.assertThat((byte[])this.fromString("").toBytes()).isEqualTo((Object)new byte[0]);
    }

    @TestTemplate
    public void testMultiSegments() {
        MemorySegment[] segments1 = new MemorySegment[]{MemorySegment.wrap((byte[])new byte[10]), MemorySegment.wrap((byte[])new byte[10])};
        segments1[0].put(5, "abcde".getBytes(StandardCharsets.UTF_8), 0, 5);
        segments1[1].put(0, "aaaaa".getBytes(StandardCharsets.UTF_8), 0, 5);
        MemorySegment[] segments2 = new MemorySegment[]{MemorySegment.wrap((byte[])new byte[5]), MemorySegment.wrap((byte[])new byte[5])};
        segments2[0].put(0, "abcde".getBytes(StandardCharsets.UTF_8), 0, 5);
        segments2[1].put(0, "b".getBytes(StandardCharsets.UTF_8), 0, 1);
        BinaryString binaryString1 = BinaryString.fromAddress((MemorySegment[])segments1, (int)5, (int)10);
        BinaryString binaryString2 = BinaryString.fromAddress((MemorySegment[])segments2, (int)0, (int)6);
        Assertions.assertThat((String)binaryString1.toString()).isEqualTo("abcdeaaaaa");
        Assertions.assertThat((String)binaryString2.toString()).isEqualTo("abcdeb");
        Assertions.assertThat((int)binaryString1.compareTo(binaryString2)).isEqualTo(-1);
        binaryString1 = BinaryString.fromAddress((MemorySegment[])segments1, (int)5, (int)5);
        binaryString2 = BinaryString.fromAddress((MemorySegment[])segments2, (int)0, (int)5);
        Assertions.assertThat((String)binaryString1.toString()).isEqualTo("abcde");
        Assertions.assertThat((String)binaryString2.toString()).isEqualTo("abcde");
        Assertions.assertThat((int)binaryString1.compareTo(binaryString2)).isEqualTo(0);
        binaryString1 = BinaryString.fromAddress((MemorySegment[])segments1, (int)10, (int)5);
        binaryString2 = BinaryString.fromAddress((MemorySegment[])segments2, (int)0, (int)5);
        Assertions.assertThat((String)binaryString1.toString()).isEqualTo("aaaaa");
        Assertions.assertThat((String)binaryString2.toString()).isEqualTo("abcde");
        Assertions.assertThat((int)binaryString1.compareTo(binaryString2)).isEqualTo(-1);
        Assertions.assertThat((int)binaryString2.compareTo(binaryString1)).isEqualTo(1);
        segments2 = new MemorySegment[]{MemorySegment.wrap((byte[])new byte[10])};
        segments2[0].put(4, "abcdeb".getBytes(StandardCharsets.UTF_8), 0, 6);
        binaryString1 = BinaryString.fromAddress((MemorySegment[])segments1, (int)5, (int)10);
        binaryString2 = BinaryString.fromAddress((MemorySegment[])segments2, (int)4, (int)6);
        Assertions.assertThat((String)binaryString1.toString()).isEqualTo("abcdeaaaaa");
        Assertions.assertThat((String)binaryString2.toString()).isEqualTo("abcdeb");
        Assertions.assertThat((int)binaryString1.compareTo(binaryString2)).isEqualTo(-1);
        Assertions.assertThat((int)binaryString2.compareTo(binaryString1)).isEqualTo(1);
    }

    @TestTemplate
    public void contains() {
        Assertions.assertThat((boolean)this.empty.contains(this.empty)).isTrue();
        Assertions.assertThat((boolean)this.fromString("hello").contains(this.fromString("ello"))).isTrue();
        Assertions.assertThat((boolean)this.fromString("hello").contains(this.fromString("vello"))).isFalse();
        Assertions.assertThat((boolean)this.fromString("hello").contains(this.fromString("hellooo"))).isFalse();
        Assertions.assertThat((boolean)this.fromString("\u5927\u5343\u4e16\u754c").contains(this.fromString("\u5343\u4e16\u754c"))).isTrue();
        Assertions.assertThat((boolean)this.fromString("\u5927\u5343\u4e16\u754c").contains(this.fromString("\u4e16\u5343"))).isFalse();
        Assertions.assertThat((boolean)this.fromString("\u5927\u5343\u4e16\u754c").contains(this.fromString("\u5927\u5343\u4e16\u754c\u597d"))).isFalse();
    }

    @TestTemplate
    public void startsWith() {
        Assertions.assertThat((boolean)this.empty.startsWith(this.empty)).isTrue();
        Assertions.assertThat((boolean)this.fromString("hello").startsWith(this.fromString("hell"))).isTrue();
        Assertions.assertThat((boolean)this.fromString("hello").startsWith(this.fromString("ell"))).isFalse();
        Assertions.assertThat((boolean)this.fromString("hello").startsWith(this.fromString("hellooo"))).isFalse();
        Assertions.assertThat((boolean)this.fromString("\u6570\u636e\u7816\u5934").startsWith(this.fromString("\u6570\u636e"))).isTrue();
        Assertions.assertThat((boolean)this.fromString("\u5927\u5343\u4e16\u754c").startsWith(this.fromString("\u5343"))).isFalse();
        Assertions.assertThat((boolean)this.fromString("\u5927\u5343\u4e16\u754c").startsWith(this.fromString("\u5927\u5343\u4e16\u754c\u597d"))).isFalse();
    }

    @TestTemplate
    public void endsWith() {
        Assertions.assertThat((boolean)this.empty.endsWith(this.empty)).isTrue();
        Assertions.assertThat((boolean)this.fromString("hello").endsWith(this.fromString("ello"))).isTrue();
        Assertions.assertThat((boolean)this.fromString("hello").endsWith(this.fromString("ellov"))).isFalse();
        Assertions.assertThat((boolean)this.fromString("hello").endsWith(this.fromString("hhhello"))).isFalse();
        Assertions.assertThat((boolean)this.fromString("\u5927\u5343\u4e16\u754c").endsWith(this.fromString("\u4e16\u754c"))).isTrue();
        Assertions.assertThat((boolean)this.fromString("\u5927\u5343\u4e16\u754c").endsWith(this.fromString("\u4e16"))).isFalse();
        Assertions.assertThat((boolean)this.fromString("\u6570\u636e\u7816\u5934").endsWith(this.fromString("\u6211\u7684\u6570\u636e\u7816\u5934"))).isFalse();
    }

    @TestTemplate
    public void substring() {
        Assertions.assertThat((Comparable)this.fromString("hello").substring(0, 0)).isEqualTo((Object)this.empty);
        Assertions.assertThat((Comparable)this.fromString("hello").substring(1, 3)).isEqualTo((Object)this.fromString("el"));
        Assertions.assertThat((Comparable)this.fromString("\u6570\u636e\u7816\u5934").substring(0, 1)).isEqualTo((Object)this.fromString("\u6570"));
        Assertions.assertThat((Comparable)this.fromString("\u6570\u636e\u7816\u5934").substring(1, 3)).isEqualTo((Object)this.fromString("\u636e\u7816"));
        Assertions.assertThat((Comparable)this.fromString("\u6570\u636e\u7816\u5934").substring(3, 5)).isEqualTo((Object)this.fromString("\u5934"));
        Assertions.assertThat((Comparable)this.fromString("\u07f5\u68b7").substring(0, 2)).isEqualTo((Object)this.fromString("\u07f5\u68b7"));
    }

    @TestTemplate
    public void indexOf() {
        Assertions.assertThat((int)this.empty.indexOf(this.empty, 0)).isEqualTo(0);
        Assertions.assertThat((int)this.empty.indexOf(this.fromString("l"), 0)).isEqualTo(-1);
        Assertions.assertThat((int)this.fromString("hello").indexOf(this.empty, 0)).isEqualTo(0);
        Assertions.assertThat((int)this.fromString("hello").indexOf(this.fromString("l"), 0)).isEqualTo(2);
        Assertions.assertThat((int)this.fromString("hello").indexOf(this.fromString("l"), 3)).isEqualTo(3);
        Assertions.assertThat((int)this.fromString("hello").indexOf(this.fromString("a"), 0)).isEqualTo(-1);
        Assertions.assertThat((int)this.fromString("hello").indexOf(this.fromString("ll"), 0)).isEqualTo(2);
        Assertions.assertThat((int)this.fromString("hello").indexOf(this.fromString("ll"), 4)).isEqualTo(-1);
        Assertions.assertThat((int)this.fromString("\u6570\u636e\u7816\u5934").indexOf(this.fromString("\u636e\u7816"), 0)).isEqualTo(1);
        Assertions.assertThat((int)this.fromString("\u6570\u636e\u7816\u5934").indexOf(this.fromString("\u6570"), 3)).isEqualTo(-1);
        Assertions.assertThat((int)this.fromString("\u6570\u636e\u7816\u5934").indexOf(this.fromString("\u6570"), 0)).isEqualTo(0);
        Assertions.assertThat((int)this.fromString("\u6570\u636e\u7816\u5934").indexOf(this.fromString("\u5934"), 0)).isEqualTo(3);
    }

    @TestTemplate
    public void testToUpperLowerCase() {
        Assertions.assertThat((Comparable)this.fromString("\u6211\u662f\u4e2d\u56fd\u4eba").toLowerCase()).isEqualTo((Object)this.fromString("\u6211\u662f\u4e2d\u56fd\u4eba"));
        Assertions.assertThat((Comparable)this.fromString("\u6211\u662f\u4e2d\u56fd\u4eba").toUpperCase()).isEqualTo((Object)this.fromString("\u6211\u662f\u4e2d\u56fd\u4eba"));
        Assertions.assertThat((Comparable)this.fromString("aBcDeFg").toLowerCase()).isEqualTo((Object)this.fromString("abcdefg"));
        Assertions.assertThat((Comparable)this.fromString("aBcDeFg").toUpperCase()).isEqualTo((Object)this.fromString("ABCDEFG"));
        Assertions.assertThat((Comparable)this.fromString("!@#$%^*").toLowerCase()).isEqualTo((Object)this.fromString("!@#$%^*"));
        Assertions.assertThat((Comparable)this.fromString("!@#$%^*").toLowerCase()).isEqualTo((Object)this.fromString("!@#$%^*"));
    }

    @TestTemplate
    public void testcastFrom() {
        class DecimalTestData {
            private final String str;
            private final int precision;
            private final int scale;

            DecimalTestData(String str, int precision, int scale) {
                this.str = str;
                this.precision = precision;
                this.scale = scale;
            }
        }
        DecimalTestData[] data;
        for (DecimalTestData d : data = new DecimalTestData[]{new DecimalTestData("12.345", 5, 3), new DecimalTestData("-12.345", 5, 3), new DecimalTestData("+12345", 5, 0), new DecimalTestData("-12345", 5, 0), new DecimalTestData("12345.", 5, 0), new DecimalTestData("-12345.", 5, 0), new DecimalTestData(".12345", 5, 5), new DecimalTestData("-.12345", 5, 5), new DecimalTestData("+12.345E3", 5, 0), new DecimalTestData("-12.345e3", 5, 0), new DecimalTestData("12.345e-3", 6, 6), new DecimalTestData("-12.345E-3", 6, 6), new DecimalTestData("12345E3", 8, 0), new DecimalTestData("-12345e3", 8, 0), new DecimalTestData("12345e-3", 5, 3), new DecimalTestData("-12345E-3", 5, 3), new DecimalTestData("+.12345E3", 5, 2), new DecimalTestData("-.12345e3", 5, 2), new DecimalTestData(".12345e-3", 8, 8), new DecimalTestData("-.12345E-3", 8, 8), new DecimalTestData("1234512345.1234", 18, 8), new DecimalTestData("-1234512345.1234", 18, 8), new DecimalTestData("1234512345.1234", 12, 2), new DecimalTestData("-1234512345.1234", 12, 2), new DecimalTestData("1234512345.1299", 12, 2), new DecimalTestData("-1234512345.1299", 12, 2), new DecimalTestData("999999999999999999", 18, 0), new DecimalTestData("1234512345.1234512345", 20, 10), new DecimalTestData("-1234512345.1234512345", 20, 10), new DecimalTestData("1234512345.1234512345", 15, 5), new DecimalTestData("-1234512345.1234512345", 15, 5), new DecimalTestData("12345123451234512345E-10", 20, 10), new DecimalTestData("-12345123451234512345E-10", 20, 10), new DecimalTestData("12345123451234512345E-10", 15, 5), new DecimalTestData("-12345123451234512345E-10", 15, 5), new DecimalTestData("999999999999999999999", 21, 0), new DecimalTestData("-999999999999999999999", 21, 0), new DecimalTestData("0.00000000000000000000123456789123456789", 38, 38), new DecimalTestData("-0.00000000000000000000123456789123456789", 38, 38), new DecimalTestData("0.00000000000000000000123456789123456789", 29, 29), new DecimalTestData("-0.00000000000000000000123456789123456789", 29, 29), new DecimalTestData("123456789123E-27", 18, 18), new DecimalTestData("-123456789123E-27", 18, 18), new DecimalTestData("123456789999E-27", 18, 18), new DecimalTestData("-123456789999E-27", 18, 18), new DecimalTestData("123456789123456789E-36", 18, 18), new DecimalTestData("-123456789123456789E-36", 18, 18), new DecimalTestData("123456789999999999E-36", 18, 18), new DecimalTestData("-123456789999999999E-36", 18, 18)}) {
            Assertions.assertThat((Comparable)DecimalUtils.castFrom((BinaryString)this.fromString(d.str), (int)d.precision, (int)d.scale)).isEqualTo((Object)Decimal.fromBigDecimal((BigDecimal)new BigDecimal(d.str), (int)d.precision, (int)d.scale));
        }
    }

    @TestTemplate
    public void testEmptyString() {
        BinaryString str2 = this.fromString("hahahahah");
        MemorySegment[] segments = new MemorySegment[]{MemorySegment.wrap((byte[])new byte[10]), MemorySegment.wrap((byte[])new byte[10])};
        BinaryString str3 = BinaryString.fromAddress((MemorySegment[])segments, (int)15, (int)0);
        Assertions.assertThat((int)BinaryString.EMPTY_UTF8.compareTo(str2)).isLessThan(0);
        Assertions.assertThat((int)str2.compareTo(BinaryString.EMPTY_UTF8)).isGreaterThan(0);
        Assertions.assertThat((int)BinaryString.EMPTY_UTF8.compareTo(str3)).isEqualTo(0);
        Assertions.assertThat((int)str3.compareTo(BinaryString.EMPTY_UTF8)).isEqualTo(0);
        Assertions.assertThat((Comparable)str2).isNotEqualTo((Object)BinaryString.EMPTY_UTF8);
        Assertions.assertThat((Comparable)BinaryString.EMPTY_UTF8).isNotEqualTo((Object)str2);
        Assertions.assertThat((Comparable)str3).isEqualTo((Object)BinaryString.EMPTY_UTF8);
        Assertions.assertThat((Comparable)BinaryString.EMPTY_UTF8).isEqualTo((Object)str3);
    }

    @TestTemplate
    public void testEncodeWithIllegalCharacter() {
        char[] chars = new char[]{'\u4e9a', '\u9ebb', '|', '\u957f', '\u8896', '|', '\u8fde', '\u8863', '\u88d9', '|', '\ud83d', '|', '\udc57'};
        String str = new String(chars);
        Assertions.assertThat((byte[])BinaryString.encodeUTF8((String)str)).isEqualTo((Object)str.getBytes(StandardCharsets.UTF_8));
    }

    @TestTemplate
    public void testDecodeWithIllegalUtf8Bytes() {
        byte[] bytes = new byte[]{-102, -69, 124, 127, -106, 124, -34, 99, -39, 124, 61, 124, 87};
        String str = new String(bytes, StandardCharsets.UTF_8);
        Assertions.assertThat((String)BinaryString.decodeUTF8((byte[])bytes, (int)0, (int)bytes.length)).isEqualTo(str);
        Assertions.assertThat((String)BinaryString.decodeUTF8((MemorySegment)MemorySegment.wrap((byte[])bytes), (int)0, (int)bytes.length)).isEqualTo(str);
        byte[] newBytes = new byte[bytes.length + 5];
        System.arraycopy(bytes, 0, newBytes, 5, bytes.length);
        Assertions.assertThat((String)BinaryString.decodeUTF8((MemorySegment)MemorySegment.wrap((byte[])newBytes), (int)5, (int)bytes.length)).isEqualTo(str);
    }

    @TestTemplate
    public void skipWrongFirstByte() {
        int[] wrongFirstBytes = new int[]{128, 159, 191, 192, 194, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255};
        byte[] c = new byte[1];
        for (int wrongFirstByte : wrongFirstBytes) {
            c[0] = (byte)wrongFirstByte;
            Assertions.assertThat((int)1).isEqualTo(BinaryString.fromBytes((byte[])c).numChars());
        }
    }

    @TestTemplate
    public void testFromBytes() {
        String s = "hahahe";
        byte[] bytes = Arrays.copyOf(s.getBytes(StandardCharsets.UTF_8), 10);
        Assertions.assertThat((Comparable)BinaryString.fromBytes((byte[])bytes, (int)0, (int)6)).isEqualTo((Object)BinaryString.fromString((String)s));
    }

    private static enum Mode {
        ONE_SEG,
        MULTI_SEGS,
        STRING,
        RANDOM;

    }
}

