/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.row;

import com.alibaba.fluss.row.Decimal;
import com.alibaba.fluss.utils.DecimalUtils;
import java.math.BigDecimal;
import java.util.Objects;
import org.assertj.core.api.Assertions;
import org.assertj.core.data.Offset;
import org.junit.jupiter.api.Test;

public class DecimalTest {
    @Test
    public void testNormal() {
        BigDecimal bigDecimal1 = new BigDecimal("13145678.90123");
        BigDecimal bigDecimal2 = new BigDecimal("1234567890.0987654321");
        Assertions.assertThat((Comparable)Decimal.fromUnscaledBytes((byte[])bigDecimal1.unscaledValue().toByteArray(), (int)15, (int)5)).isEqualTo((Object)Decimal.fromBigDecimal((BigDecimal)bigDecimal1, (int)15, (int)5));
        Assertions.assertThat((Comparable)Decimal.fromUnscaledBytes((byte[])bigDecimal2.unscaledValue().toByteArray(), (int)23, (int)10)).isEqualTo((Object)Decimal.fromBigDecimal((BigDecimal)bigDecimal2, (int)23, (int)10));
        Assertions.assertThat((byte[])Decimal.fromUnscaledBytes((byte[])bigDecimal1.unscaledValue().toByteArray(), (int)15, (int)5).toUnscaledBytes()).isEqualTo((Object)bigDecimal1.unscaledValue().toByteArray());
        Assertions.assertThat((byte[])Decimal.fromUnscaledBytes((byte[])bigDecimal2.unscaledValue().toByteArray(), (int)23, (int)10).toUnscaledBytes()).isEqualTo((Object)bigDecimal2.unscaledValue().toByteArray());
        Decimal decimal1 = Decimal.fromUnscaledLong((long)10L, (int)5, (int)0);
        Decimal decimal2 = Decimal.fromUnscaledLong((long)15L, (int)5, (int)0);
        Assertions.assertThat((int)Decimal.fromBigDecimal((BigDecimal)new BigDecimal(10), (int)5, (int)0).hashCode()).isEqualTo(decimal1.hashCode());
        Assertions.assertThat((Comparable)decimal1.copy()).isEqualTo((Object)decimal1);
        Assertions.assertThat((Comparable)Decimal.fromUnscaledLong((long)decimal1.toUnscaledLong(), (int)5, (int)0)).isEqualTo((Object)decimal1);
        Assertions.assertThat((Comparable)Decimal.fromUnscaledBytes((byte[])decimal1.toUnscaledBytes(), (int)5, (int)0)).isEqualTo((Object)decimal1);
        Assertions.assertThat((int)decimal1.compareTo(decimal2)).isLessThan(0);
        Assertions.assertThat((double)DecimalUtils.doubleValue((Decimal)DecimalUtils.castFrom((double)10.5, (int)5, (int)1))).isEqualTo(10.5);
        Assertions.assertThat((double)DecimalUtils.doubleValue((Decimal)DecimalUtils.castFrom((String)"123456789012345678901234567890123456789", (int)39, (int)0))).isCloseTo(1.2345678901234568E38, Offset.offset((Number)0.01));
        Assertions.assertThat((long)DecimalUtils.add((Decimal)decimal1, (Decimal)decimal2, (int)5, (int)0).toUnscaledLong()).isEqualTo(25L);
        Assertions.assertThat((int)DecimalUtils.add((Decimal)DecimalUtils.castFrom((String)"123456789012345678901234567890123456789", (int)39, (int)0), (Decimal)DecimalUtils.castFrom((String)"123456789012345678901234567890123456789", (int)39, (int)0), (int)39, (int)0).toBigDecimal().intValue()).isEqualTo(1551041066);
        Assertions.assertThat((long)DecimalUtils.castToIntegral((Decimal)decimal1)).isEqualTo(10L);
        Assertions.assertThat((boolean)DecimalUtils.castToBoolean((Decimal)decimal1)).isTrue();
        Assertions.assertThat((Comparable)Decimal.fromBigDecimal((BigDecimal)new BigDecimal(Long.MAX_VALUE), (int)5, (int)0)).isNull();
        Assertions.assertThat((int)Objects.requireNonNull(Decimal.zero((int)5, (int)2)).toBigDecimal().intValue()).isEqualTo(0);
        Assertions.assertThat((int)Objects.requireNonNull(Decimal.zero((int)20, (int)2)).toBigDecimal().intValue()).isEqualTo(0);
        Assertions.assertThat((String)DecimalUtils.castToDecimal((Decimal)DecimalUtils.castFrom((double)5.0, (int)10, (int)1), (int)10, (int)2).toString()).isEqualTo("5.00");
        Assertions.assertThat((long)DecimalUtils.castToIntegral((Decimal)DecimalUtils.castFrom((long)5L, (int)5, (int)0))).isEqualTo(5L);
        Assertions.assertThat((long)DecimalUtils.castToIntegral((Decimal)DecimalUtils.castFrom((String)"5", (int)5, (int)0))).isEqualTo(5L);
        Decimal newDecimal = DecimalUtils.castFrom((Decimal)DecimalUtils.castFrom((long)10L, (int)5, (int)2), (int)10, (int)4);
        Assertions.assertThat((int)newDecimal.precision()).isEqualTo(10);
        Assertions.assertThat((int)newDecimal.scale()).isEqualTo(4);
    }

    @Test
    public void testNotCompact() {
        Decimal decimal1 = Decimal.fromBigDecimal((BigDecimal)new BigDecimal(10), (int)20, (int)0);
        Decimal decimal2 = Decimal.fromBigDecimal((BigDecimal)new BigDecimal(15), (int)20, (int)0);
        Assertions.assertThat((int)Decimal.fromBigDecimal((BigDecimal)new BigDecimal(10), (int)20, (int)0).hashCode()).isEqualTo(decimal1.hashCode());
        Assertions.assertThat((Comparable)decimal1.copy()).isEqualTo((Object)decimal1);
        Assertions.assertThat((Comparable)Decimal.fromBigDecimal((BigDecimal)decimal1.toBigDecimal(), (int)20, (int)0)).isEqualTo((Object)decimal1);
        Assertions.assertThat((Comparable)Decimal.fromUnscaledBytes((byte[])decimal1.toUnscaledBytes(), (int)20, (int)0)).isEqualTo((Object)decimal1);
        Assertions.assertThat((int)decimal1.compareTo(decimal2)).isLessThan(0);
        Assertions.assertThat((double)DecimalUtils.doubleValue((Decimal)DecimalUtils.castFrom((double)10.5, (int)20, (int)1))).isEqualTo(10.5);
        Assertions.assertThat((long)DecimalUtils.add((Decimal)decimal1, (Decimal)decimal2, (int)20, (int)0).toBigDecimal().longValue()).isEqualTo(25L);
        Assertions.assertThat((long)DecimalUtils.castToIntegral((Decimal)decimal1)).isEqualTo(10L);
        Assertions.assertThat((boolean)DecimalUtils.castToBoolean((Decimal)decimal1)).isTrue();
        Assertions.assertThat((Comparable)Decimal.fromBigDecimal((BigDecimal)new BigDecimal(Long.MAX_VALUE), (int)5, (int)0)).isNull();
        Assertions.assertThat((int)Decimal.zero((int)20, (int)2).toBigDecimal().intValue()).isEqualTo(0);
        Assertions.assertThat((int)Decimal.zero((int)20, (int)2).toBigDecimal().intValue()).isEqualTo(0);
        Decimal decimal3 = Decimal.fromBigDecimal((BigDecimal)new BigDecimal(10), (int)18, (int)0);
        Decimal decimal4 = Decimal.fromBigDecimal((BigDecimal)new BigDecimal(15), (int)18, (int)0);
        Assertions.assertThat((int)DecimalUtils.compare((Decimal)DecimalUtils.subtract((Decimal)decimal3, (Decimal)decimal4, (int)19, (int)0), (long)-5L)).isEqualTo(0);
        Assertions.assertThat((int)DecimalUtils.compare((Decimal)DecimalUtils.add((Decimal)decimal3, (Decimal)decimal4, (int)19, (int)0), (long)25L)).isEqualTo(0);
    }

    @Test
    public void testToString() {
        String val = "0.0000000000000000001";
        Assertions.assertThat((String)DecimalUtils.castFrom((String)val, (int)39, (int)(val.length() - 2)).toString()).isEqualTo(val);
        val = "123456789012345678901234567890123456789";
        Assertions.assertThat((String)DecimalUtils.castFrom((String)val, (int)39, (int)0).toString()).isEqualTo(val);
    }
}

