/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.row;

import com.alibaba.fluss.row.BinaryString;
import com.alibaba.fluss.row.Decimal;
import com.alibaba.fluss.row.GenericRow;
import com.alibaba.fluss.row.InternalRow;
import com.alibaba.fluss.row.ProjectedRow;
import com.alibaba.fluss.row.TimestampLtz;
import com.alibaba.fluss.row.TimestampNtz;
import java.math.BigDecimal;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class ProjectedRowTest {
    ProjectedRowTest() {
    }

    @Test
    void testProjectedRows() {
        ProjectedRow projectedRow = ProjectedRow.from((int[])new int[]{2, 0, 1, 4});
        Assertions.assertThat((int)projectedRow.getFieldCount()).isEqualTo(4);
        projectedRow.replaceRow((InternalRow)GenericRow.of((Object[])new Object[]{0L, 1L, 2L, 3L, 4L}));
        Assertions.assertThat((long)projectedRow.getLong(0)).isEqualTo(2L);
        Assertions.assertThat((long)projectedRow.getLong(1)).isEqualTo(0L);
        Assertions.assertThat((long)projectedRow.getLong(2)).isEqualTo(1L);
        Assertions.assertThat((long)projectedRow.getLong(3)).isEqualTo(4L);
        projectedRow.replaceRow((InternalRow)GenericRow.of((Object[])new Object[]{5L, 6L, 7L, 8L, 9L, 10L}));
        Assertions.assertThat((long)projectedRow.getLong(0)).isEqualTo(7L);
        Assertions.assertThat((long)projectedRow.getLong(1)).isEqualTo(5L);
        Assertions.assertThat((long)projectedRow.getLong(2)).isEqualTo(6L);
        Assertions.assertThat((long)projectedRow.getLong(3)).isEqualTo(9L);
        projectedRow.replaceRow((InternalRow)GenericRow.of((Object[])new Object[]{0, 1, 2, 3, 4}));
        Assertions.assertThat((int)projectedRow.getInt(0)).isEqualTo(2);
        Assertions.assertThat((int)projectedRow.getInt(1)).isEqualTo(0);
        Assertions.assertThat((int)projectedRow.getInt(2)).isEqualTo(1);
        Assertions.assertThat((int)projectedRow.getInt(3)).isEqualTo(4);
        projectedRow.replaceRow((InternalRow)GenericRow.of((Object[])new Object[]{(short)5, (short)6, (short)7, (short)8, (short)9, (short)10}));
        Assertions.assertThat((short)projectedRow.getShort(0)).isEqualTo((short)7);
        Assertions.assertThat((short)projectedRow.getShort(1)).isEqualTo((short)5);
        Assertions.assertThat((short)projectedRow.getShort(2)).isEqualTo((short)6);
        Assertions.assertThat((short)projectedRow.getShort(3)).isEqualTo((short)9);
        projectedRow.replaceRow((InternalRow)GenericRow.of((Object[])new Object[]{(byte)5, (byte)6, (byte)7, (byte)8, (byte)9, (byte)10}));
        Assertions.assertThat((byte)projectedRow.getByte(0)).isEqualTo((byte)7);
        Assertions.assertThat((byte)projectedRow.getByte(1)).isEqualTo((byte)5);
        Assertions.assertThat((byte)projectedRow.getByte(2)).isEqualTo((byte)6);
        Assertions.assertThat((byte)projectedRow.getByte(3)).isEqualTo((byte)9);
        projectedRow.replaceRow((InternalRow)GenericRow.of((Object[])new Object[]{true, false, true, false, true, false}));
        Assertions.assertThat((boolean)projectedRow.getBoolean(0)).isEqualTo(true);
        Assertions.assertThat((boolean)projectedRow.getBoolean(1)).isEqualTo(true);
        Assertions.assertThat((boolean)projectedRow.getBoolean(2)).isEqualTo(false);
        Assertions.assertThat((boolean)projectedRow.getBoolean(3)).isEqualTo(true);
        projectedRow.replaceRow((InternalRow)GenericRow.of((Object[])new Object[]{Float.valueOf(0.0f), Float.valueOf(0.1f), Float.valueOf(0.2f), Float.valueOf(0.3f), Float.valueOf(0.4f)}));
        Assertions.assertThat((float)projectedRow.getFloat(0)).isEqualTo(0.2f);
        Assertions.assertThat((float)projectedRow.getFloat(1)).isEqualTo(0.0f);
        Assertions.assertThat((float)projectedRow.getFloat(2)).isEqualTo(0.1f);
        Assertions.assertThat((float)projectedRow.getFloat(3)).isEqualTo(0.4f);
        projectedRow.replaceRow((InternalRow)GenericRow.of((Object[])new Object[]{0.5, 0.6, 0.7, 0.8, 0.9, 1.0}));
        Assertions.assertThat((double)projectedRow.getDouble(0)).isEqualTo(0.7);
        Assertions.assertThat((double)projectedRow.getDouble(1)).isEqualTo(0.5);
        Assertions.assertThat((double)projectedRow.getDouble(2)).isEqualTo(0.6);
        Assertions.assertThat((double)projectedRow.getDouble(3)).isEqualTo(0.9);
        projectedRow.replaceRow((InternalRow)GenericRow.of((Object[])new Object[]{BinaryString.fromString((String)"0"), BinaryString.fromString((String)"1"), BinaryString.fromString((String)"2"), BinaryString.fromString((String)"3"), BinaryString.fromString((String)"4")}));
        Assertions.assertThat((String)projectedRow.getChar(0, 1).toString()).isEqualTo("2");
        Assertions.assertThat((String)projectedRow.getChar(1, 1).toString()).isEqualTo("0");
        Assertions.assertThat((String)projectedRow.getChar(2, 1).toString()).isEqualTo("1");
        Assertions.assertThat((String)projectedRow.getChar(3, 1).toString()).isEqualTo("4");
        Assertions.assertThat((String)projectedRow.getString(0).toString()).isEqualTo("2");
        Assertions.assertThat((String)projectedRow.getString(1).toString()).isEqualTo("0");
        Assertions.assertThat((String)projectedRow.getString(2).toString()).isEqualTo("1");
        Assertions.assertThat((String)projectedRow.getString(3).toString()).isEqualTo("4");
        projectedRow.replaceRow((InternalRow)GenericRow.of((Object[])new Object[]{Decimal.fromBigDecimal((BigDecimal)new BigDecimal("0"), (int)18, (int)0), Decimal.fromBigDecimal((BigDecimal)new BigDecimal("1"), (int)18, (int)0), Decimal.fromBigDecimal((BigDecimal)new BigDecimal("2"), (int)18, (int)0), Decimal.fromBigDecimal((BigDecimal)new BigDecimal("3"), (int)18, (int)0), Decimal.fromBigDecimal((BigDecimal)new BigDecimal("4"), (int)18, (int)0)}));
        Assertions.assertThat((String)projectedRow.getDecimal(0, 18, 0).toString()).isEqualTo("2");
        Assertions.assertThat((String)projectedRow.getDecimal(1, 18, 0).toString()).isEqualTo("0");
        Assertions.assertThat((String)projectedRow.getDecimal(2, 18, 0).toString()).isEqualTo("1");
        Assertions.assertThat((String)projectedRow.getDecimal(3, 18, 0).toString()).isEqualTo("4");
        projectedRow.replaceRow((InternalRow)GenericRow.of((Object[])new Object[]{TimestampNtz.fromMillis((long)5L), TimestampNtz.fromMillis((long)6L), TimestampNtz.fromMillis((long)7L), TimestampNtz.fromMillis((long)8L), TimestampNtz.fromMillis((long)9L), TimestampNtz.fromMillis((long)10L)}));
        Assertions.assertThat((Comparable)projectedRow.getTimestampNtz(0, 3)).isEqualTo((Object)TimestampNtz.fromMillis((long)7L));
        Assertions.assertThat((Comparable)projectedRow.getTimestampNtz(1, 3)).isEqualTo((Object)TimestampNtz.fromMillis((long)5L));
        Assertions.assertThat((Comparable)projectedRow.getTimestampNtz(2, 3)).isEqualTo((Object)TimestampNtz.fromMillis((long)6L));
        Assertions.assertThat((Comparable)projectedRow.getTimestampNtz(3, 3)).isEqualTo((Object)TimestampNtz.fromMillis((long)9L));
        projectedRow.replaceRow((InternalRow)GenericRow.of((Object[])new Object[]{TimestampLtz.fromEpochMicros((long)5L), TimestampLtz.fromEpochMicros((long)6L), TimestampLtz.fromEpochMicros((long)7L), TimestampLtz.fromEpochMicros((long)8L), TimestampLtz.fromEpochMicros((long)9L), TimestampLtz.fromEpochMicros((long)10L)}));
        Assertions.assertThat((Comparable)projectedRow.getTimestampLtz(0, 3)).isEqualTo((Object)TimestampLtz.fromEpochMicros((long)7L));
        Assertions.assertThat((Comparable)projectedRow.getTimestampLtz(1, 3)).isEqualTo((Object)TimestampLtz.fromEpochMicros((long)5L));
        Assertions.assertThat((Comparable)projectedRow.getTimestampLtz(2, 3)).isEqualTo((Object)TimestampLtz.fromEpochMicros((long)6L));
        Assertions.assertThat((Comparable)projectedRow.getTimestampLtz(3, 3)).isEqualTo((Object)TimestampLtz.fromEpochMicros((long)9L));
        projectedRow.replaceRow((InternalRow)GenericRow.of((Object[])new Object[]{new byte[]{5}, new byte[]{6}, new byte[]{7}, new byte[]{8}, new byte[]{9}, new byte[]{10}}));
        Assertions.assertThat((byte[])projectedRow.getBytes(0)).isEqualTo((Object)new byte[]{7});
        Assertions.assertThat((byte[])projectedRow.getBytes(1)).isEqualTo((Object)new byte[]{5});
        Assertions.assertThat((byte[])projectedRow.getBytes(2)).isEqualTo((Object)new byte[]{6});
        Assertions.assertThat((byte[])projectedRow.getBytes(3)).isEqualTo((Object)new byte[]{9});
        Assertions.assertThat((byte[])projectedRow.getBinary(0, 1)).isEqualTo((Object)new byte[]{7});
        Assertions.assertThat((byte[])projectedRow.getBinary(1, 1)).isEqualTo((Object)new byte[]{5});
        Assertions.assertThat((byte[])projectedRow.getBinary(2, 1)).isEqualTo((Object)new byte[]{6});
        Assertions.assertThat((byte[])projectedRow.getBinary(3, 1)).isEqualTo((Object)new byte[]{9});
        projectedRow.replaceRow((InternalRow)GenericRow.of((Object[])new Object[]{5L, 6L, null, 8L, null, 10L}));
        Assertions.assertThat((boolean)projectedRow.isNullAt(0)).isTrue();
        Assertions.assertThat((boolean)projectedRow.isNullAt(1)).isFalse();
        Assertions.assertThat((boolean)projectedRow.isNullAt(2)).isFalse();
        Assertions.assertThat((boolean)projectedRow.isNullAt(3)).isTrue();
    }
}

