/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.row;

import com.alibaba.fluss.row.BinaryString;
import com.alibaba.fluss.row.Decimal;
import com.alibaba.fluss.row.InternalRow;
import com.alibaba.fluss.row.TimestampLtz;
import com.alibaba.fluss.row.TimestampNtz;
import com.alibaba.fluss.row.compacted.CompactedRow;
import com.alibaba.fluss.row.encode.CompactedRowEncoder;
import com.alibaba.fluss.row.indexed.IndexedRow;
import com.alibaba.fluss.row.indexed.IndexedRowWriter;
import com.alibaba.fluss.types.DataField;
import com.alibaba.fluss.types.DataType;
import com.alibaba.fluss.types.DataTypes;
import com.alibaba.fluss.types.RowType;
import com.alibaba.fluss.utils.TypeUtils;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.Random;

public class TestInternalRowGenerator {
    public static DataType[] createAllTypes() {
        return TestInternalRowGenerator.createAllRowType().getChildren().toArray(new DataType[0]);
    }

    public static RowType createAllRowType() {
        return DataTypes.ROW((DataField[])new DataField[]{new DataField("a", (DataType)DataTypes.BOOLEAN()), new DataField("b", (DataType)DataTypes.TINYINT()), new DataField("c", (DataType)DataTypes.SMALLINT()), new DataField("d", (DataType)DataTypes.INT()), new DataField("e", (DataType)DataTypes.BIGINT()), new DataField("f", (DataType)DataTypes.FLOAT()), new DataField("g", (DataType)DataTypes.DOUBLE()), new DataField("h", (DataType)DataTypes.DATE()), new DataField("i", (DataType)DataTypes.TIME()), new DataField("j", (DataType)DataTypes.BINARY((int)20)), new DataField("k", (DataType)DataTypes.BYTES()), new DataField("l", (DataType)DataTypes.CHAR((int)2)), new DataField("m", (DataType)DataTypes.STRING()), new DataField("n", (DataType)DataTypes.DECIMAL((int)5, (int)2)), new DataField("o", (DataType)DataTypes.DECIMAL((int)20, (int)0)), new DataField("p", (DataType)DataTypes.TIMESTAMP((int)1)), new DataField("q", (DataType)DataTypes.TIMESTAMP((int)5)), new DataField("r", (DataType)DataTypes.TIMESTAMP_LTZ((int)1)), new DataField("s", (DataType)DataTypes.TIMESTAMP_LTZ((int)5))});
    }

    public static IndexedRow genIndexedRowForAllType() {
        DataType[] dataTypes = TestInternalRowGenerator.createAllTypes();
        IndexedRowWriter writer = new IndexedRowWriter(dataTypes);
        IndexedRowWriter.FieldWriter[] writers = new IndexedRowWriter.FieldWriter[dataTypes.length];
        for (int i = 0; i < dataTypes.length; ++i) {
            writers[i] = IndexedRowWriter.createFieldWriter((DataType)dataTypes[i]);
        }
        Random rnd = new Random();
        TestInternalRowGenerator.setRandomNull(writers[0], writer, 0, rnd, rnd.nextBoolean());
        TestInternalRowGenerator.setRandomNull(writers[1], writer, 1, rnd, (byte)rnd.nextInt());
        TestInternalRowGenerator.setRandomNull(writers[2], writer, 2, rnd, (short)rnd.nextInt());
        TestInternalRowGenerator.setRandomNull(writers[3], writer, 3, rnd, rnd.nextInt());
        TestInternalRowGenerator.setRandomNull(writers[4], writer, 4, rnd, rnd.nextLong());
        TestInternalRowGenerator.setRandomNull(writers[5], writer, 5, rnd, Float.valueOf(rnd.nextFloat()));
        TestInternalRowGenerator.setRandomNull(writers[6], writer, 6, rnd, rnd.nextDouble());
        TestInternalRowGenerator.setRandomNull(writers[7], writer, 7, rnd, TestInternalRowGenerator.generateRandomDate(rnd));
        TestInternalRowGenerator.setRandomNull(writers[8], writer, 8, rnd, TestInternalRowGenerator.generateRandomTime(rnd));
        TestInternalRowGenerator.setRandomNull(writers[9], writer, 9, rnd, TestInternalRowGenerator.generateRandomBinary(rnd, 20));
        TestInternalRowGenerator.setRandomNull(writers[10], writer, 10, rnd, TestInternalRowGenerator.generateRandomBytes(rnd));
        TestInternalRowGenerator.setRandomNull(writers[11], writer, 11, rnd, BinaryString.fromString((String)"12"));
        TestInternalRowGenerator.setRandomNull(writers[12], writer, 12, rnd, BinaryString.fromString((String)(rnd.nextInt() + "")));
        TestInternalRowGenerator.setRandomNull(writers[13], writer, 13, rnd, Decimal.fromUnscaledLong((long)rnd.nextLong(), (int)5, (int)2));
        TestInternalRowGenerator.setRandomNull(writers[14], writer, 14, rnd, Decimal.fromBigDecimal((BigDecimal)BigDecimal.valueOf(rnd.nextDouble()), (int)20, (int)0));
        TestInternalRowGenerator.setRandomNull(writers[15], writer, 15, rnd, TimestampNtz.fromMillis((long)System.currentTimeMillis()));
        TestInternalRowGenerator.setRandomNull(writers[16], writer, 16, rnd, TimestampNtz.fromMillis((long)System.currentTimeMillis()));
        TestInternalRowGenerator.setRandomNull(writers[17], writer, 17, rnd, TimestampLtz.fromEpochMillis((long)System.currentTimeMillis()));
        TestInternalRowGenerator.setRandomNull(writers[18], writer, 18, rnd, TimestampLtz.fromEpochMillis((long)System.currentTimeMillis()));
        IndexedRow row = new IndexedRow(dataTypes);
        row.pointTo(writer.segment(), 0, writer.position());
        return row;
    }

    public static CompactedRow genCompactedRowForAllType() {
        IndexedRow indexedRow = TestInternalRowGenerator.genIndexedRowForAllType();
        DataType[] dataTypes = TestInternalRowGenerator.createAllTypes();
        InternalRow.FieldGetter[] fieldGetters = new InternalRow.FieldGetter[dataTypes.length];
        for (int i = 0; i < dataTypes.length; ++i) {
            fieldGetters[i] = InternalRow.createFieldGetter((DataType)dataTypes[i], (int)i);
        }
        CompactedRowEncoder rowEncoder = new CompactedRowEncoder(dataTypes);
        rowEncoder.startNewRow();
        for (int i = 0; i < dataTypes.length; ++i) {
            rowEncoder.encodeField(i, fieldGetters[i].getFieldOrNull((InternalRow)indexedRow));
        }
        return rowEncoder.finishRow();
    }

    private static void setRandomNull(IndexedRowWriter.FieldWriter fieldWriter, IndexedRowWriter writer, int pos, Random rnd, Object value) {
        fieldWriter.writeField(writer, pos, rnd.nextBoolean() ? null : value);
    }

    private static int generateRandomDate(Random rnd) {
        int year = rnd.nextInt(3000);
        int month = rnd.nextInt(12) + 1;
        int day = rnd.nextInt(28) + 1;
        LocalDate randomDate = LocalDate.of(year, month, day);
        String formattedDate = randomDate.toString();
        return (Integer)TypeUtils.castFromString((String)formattedDate, (DataType)DataTypes.DATE());
    }

    private static int generateRandomTime(Random rnd) {
        int hour = rnd.nextInt(24);
        int minute = rnd.nextInt(60);
        int second = rnd.nextInt(60);
        LocalTime randomTime = LocalTime.of(hour, minute, second);
        String formattedTime = randomTime.toString();
        return (Integer)TypeUtils.castFromString((String)formattedTime, (DataType)DataTypes.TIME());
    }

    private static byte[] generateRandomBinary(Random rnd, int len) {
        byte[] bytes = new byte[len];
        rnd.nextBytes(bytes);
        return bytes;
    }

    public static byte[] generateRandomBytes(Random rnd) {
        int len = rnd.nextInt(100);
        byte[] bytes = new byte[len];
        for (int i = 0; i < len; ++i) {
            int next = rnd.nextInt();
            int n = Math.min(len - i, 4);
            while (n-- > 0) {
                bytes[i++] = (byte)next;
                next >>= 8;
            }
        }
        return bytes;
    }
}

