/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.row;

import com.alibaba.fluss.row.TimestampLtz;
import java.time.Instant;
import java.util.TimeZone;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TimestampLtzTest {
    @Test
    public void testNormal() {
        Assertions.assertThat((long)TimestampLtz.fromEpochMillis((long)1123L).getEpochMillisecond()).isEqualTo(1123L);
        Assertions.assertThat((long)TimestampLtz.fromEpochMillis((long)-1123L).getEpochMillisecond()).isEqualTo(-1123L);
        Assertions.assertThat((long)TimestampLtz.fromEpochMillis((long)1123L, (int)45678).getEpochMillisecond()).isEqualTo(1123L);
        Assertions.assertThat((int)TimestampLtz.fromEpochMillis((long)1123L, (int)45678).getNanoOfMillisecond()).isEqualTo(45678);
        Assertions.assertThat((long)TimestampLtz.fromEpochMillis((long)-1123L, (int)45678).getEpochMillisecond()).isEqualTo(-1123L);
        Assertions.assertThat((int)TimestampLtz.fromEpochMillis((long)-1123L, (int)45678).getNanoOfMillisecond()).isEqualTo(45678);
        Instant instant1 = Instant.ofEpochMilli(123L);
        Instant instant2 = Instant.ofEpochSecond(0L, 123456789L);
        Instant instant3 = Instant.ofEpochSecond(-2L, 123456789L);
        Assertions.assertThat((Instant)TimestampLtz.fromInstant((Instant)instant1).toInstant()).isEqualTo((Object)instant1);
        Assertions.assertThat((Instant)TimestampLtz.fromInstant((Instant)instant2).toInstant()).isEqualTo((Object)instant2);
        Assertions.assertThat((Instant)TimestampLtz.fromInstant((Instant)instant3).toInstant()).isEqualTo((Object)instant3);
    }

    @Test
    public void testDaylightSavingTime() {
        TimeZone tz = TimeZone.getDefault();
        TimeZone.setDefault(TimeZone.getTimeZone("America/Los_Angeles"));
        Instant instant = Instant.ofEpochSecond(0L, 123456789L);
        Assertions.assertThat((Instant)TimestampLtz.fromInstant((Instant)instant).toInstant()).isEqualTo((Object)instant);
        TimeZone.setDefault(tz);
    }

    @Test
    public void testToString() {
        Assertions.assertThat((String)TimestampLtz.fromEpochMillis((long)123L).toString()).isEqualTo("1970-01-01T00:00:00.123Z");
        Assertions.assertThat((String)TimestampLtz.fromEpochMillis((long)123L, (int)456789).toString()).isEqualTo("1970-01-01T00:00:00.123456789Z");
        Assertions.assertThat((String)TimestampLtz.fromEpochMillis((long)-123L).toString()).isEqualTo("1969-12-31T23:59:59.877Z");
        Assertions.assertThat((String)TimestampLtz.fromEpochMillis((long)-123L, (int)456789).toString()).isEqualTo("1969-12-31T23:59:59.877456789Z");
        Instant instant = Instant.ofEpochSecond(0L, 123456789L);
        Assertions.assertThat((String)TimestampLtz.fromInstant((Instant)instant).toString()).isEqualTo("1970-01-01T00:00:00.123456789Z");
    }

    @Test
    public void testToMicros() {
        Instant instant = Instant.ofEpochSecond(0L, 123456789L);
        Assertions.assertThat((String)TimestampLtz.fromInstant((Instant)instant).toString()).isEqualTo("1970-01-01T00:00:00.123456789Z");
        Assertions.assertThat((String)TimestampLtz.fromEpochMicros((long)TimestampLtz.fromInstant((Instant)instant).toEpochMicros()).toString()).isEqualTo("1970-01-01T00:00:00.123456Z");
    }

    @Test
    void testIsCompact() {
        Assertions.assertThat((boolean)TimestampLtz.isCompact((int)1)).isTrue();
        Assertions.assertThat((boolean)TimestampLtz.isCompact((int)3)).isTrue();
        Assertions.assertThat((boolean)TimestampLtz.isCompact((int)5)).isFalse();
    }
}

