/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.row;

import com.alibaba.fluss.row.TimestampNtz;
import java.time.LocalDateTime;
import java.util.TimeZone;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TimestampNtzTest {
    @Test
    public void testNormal() {
        LocalDateTime ldt19 = LocalDateTime.of(1969, 1, 2, 0, 0, 0, 123456789);
        LocalDateTime ldt16 = LocalDateTime.of(1969, 1, 2, 0, 0, 0, 123456000);
        LocalDateTime ldt13 = LocalDateTime.of(1969, 1, 2, 0, 0, 0, 123000000);
        LocalDateTime ldt10 = LocalDateTime.of(1969, 1, 2, 0, 0, 0, 0);
        Assertions.assertThat((LocalDateTime)TimestampNtz.fromLocalDateTime((LocalDateTime)ldt19).toLocalDateTime()).isEqualTo((Object)ldt19);
        Assertions.assertThat((LocalDateTime)TimestampNtz.fromLocalDateTime((LocalDateTime)ldt16).toLocalDateTime()).isEqualTo((Object)ldt16);
        Assertions.assertThat((LocalDateTime)TimestampNtz.fromLocalDateTime((LocalDateTime)ldt13).toLocalDateTime()).isEqualTo((Object)ldt13);
        Assertions.assertThat((LocalDateTime)TimestampNtz.fromLocalDateTime((LocalDateTime)ldt10).toLocalDateTime()).isEqualTo((Object)ldt10);
        LocalDateTime ldt2 = LocalDateTime.of(1969, 1, 2, 0, 0, 0, 0);
        Assertions.assertThat((LocalDateTime)TimestampNtz.fromLocalDateTime((LocalDateTime)ldt2).toLocalDateTime()).isEqualTo((Object)ldt2);
        LocalDateTime ldt3 = LocalDateTime.of(1989, 1, 2, 0, 0, 0, 123456789);
        Assertions.assertThat((LocalDateTime)TimestampNtz.fromLocalDateTime((LocalDateTime)ldt3).toLocalDateTime()).isEqualTo((Object)ldt3);
    }

    @Test
    public void testDaylightSavingTime() {
        TimeZone tz = TimeZone.getDefault();
        TimeZone.setDefault(TimeZone.getTimeZone("America/Los_Angeles"));
        LocalDateTime localDateTime = LocalDateTime.of(1969, 1, 2, 0, 0, 0, 123456789);
        Assertions.assertThat((LocalDateTime)TimestampNtz.fromLocalDateTime((LocalDateTime)localDateTime).toLocalDateTime()).isEqualTo((Object)localDateTime);
        TimeZone.setDefault(tz);
    }

    @Test
    public void testToString() {
        LocalDateTime ldt = LocalDateTime.of(1969, 1, 2, 0, 0, 0, 123456789);
        Assertions.assertThat((String)TimestampNtz.fromLocalDateTime((LocalDateTime)ldt).toString()).isEqualTo("1969-01-02T00:00:00.123456789");
    }

    @Test
    void testIsCompact() {
        Assertions.assertThat((boolean)TimestampNtz.isCompact((int)1)).isTrue();
        Assertions.assertThat((boolean)TimestampNtz.isCompact((int)3)).isTrue();
        Assertions.assertThat((boolean)TimestampNtz.isCompact((int)5)).isFalse();
    }

    @Test
    void testEquals() {
        LocalDateTime ldt = LocalDateTime.of(1969, 1, 2, 0, 0, 0, 123456789);
        TimestampNtz timestampNtz1 = TimestampNtz.fromLocalDateTime((LocalDateTime)ldt);
        TimestampNtz timestampNtz2 = TimestampNtz.fromMillis((long)-31449599877L, (int)456789);
        Assertions.assertThat((Comparable)timestampNtz1).isEqualTo((Object)timestampNtz2);
    }

    @Test
    void testHashCode() {
        LocalDateTime ldt = LocalDateTime.of(1969, 1, 2, 0, 0, 0, 123456789);
        TimestampNtz timestampNtz = TimestampNtz.fromLocalDateTime((LocalDateTime)ldt);
        Assertions.assertThat((int)timestampNtz.hashCode()).isEqualTo(-19523278);
    }
}

