/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.row.arrow;

import com.alibaba.fluss.memory.AbstractPagedOutputView;
import com.alibaba.fluss.memory.ManagedPagedOutputView;
import com.alibaba.fluss.memory.MemorySegment;
import com.alibaba.fluss.memory.MemorySegmentPool;
import com.alibaba.fluss.memory.TestingMemorySegmentPool;
import com.alibaba.fluss.record.TestData;
import com.alibaba.fluss.row.BinaryString;
import com.alibaba.fluss.row.Decimal;
import com.alibaba.fluss.row.GenericRow;
import com.alibaba.fluss.row.InternalRow;
import com.alibaba.fluss.row.TimestampLtz;
import com.alibaba.fluss.row.TimestampNtz;
import com.alibaba.fluss.row.arrow.ArrowReader;
import com.alibaba.fluss.row.arrow.ArrowWriter;
import com.alibaba.fluss.row.arrow.ArrowWriterPool;
import com.alibaba.fluss.row.columnar.ColumnarRow;
import com.alibaba.fluss.shaded.arrow.org.apache.arrow.memory.BufferAllocator;
import com.alibaba.fluss.shaded.arrow.org.apache.arrow.memory.RootAllocator;
import com.alibaba.fluss.shaded.arrow.org.apache.arrow.vector.VectorSchemaRoot;
import com.alibaba.fluss.shaded.arrow.org.apache.arrow.vector.types.pojo.Schema;
import com.alibaba.fluss.testutils.DataTestUtils;
import com.alibaba.fluss.testutils.InternalRowAssert;
import com.alibaba.fluss.types.DataType;
import com.alibaba.fluss.types.DataTypes;
import com.alibaba.fluss.types.RowType;
import com.alibaba.fluss.utils.ArrowUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class ArrowReaderWriterTest {
    private static final List<DataType> ALL_TYPES = Arrays.asList(DataTypes.BOOLEAN(), DataTypes.TINYINT(), DataTypes.SMALLINT(), DataTypes.INT(), DataTypes.BIGINT().copy(false), DataTypes.FLOAT(), DataTypes.DOUBLE(), DataTypes.DECIMAL((int)10, (int)3), DataTypes.CHAR((int)3), DataTypes.STRING(), DataTypes.BINARY((int)5), DataTypes.BYTES(), DataTypes.TIME(), DataTypes.DATE(), DataTypes.TIMESTAMP((int)0), DataTypes.TIMESTAMP((int)3), DataTypes.TIMESTAMP((int)6), DataTypes.TIMESTAMP((int)9), DataTypes.TIMESTAMP_LTZ((int)0), DataTypes.TIMESTAMP_LTZ((int)3), DataTypes.TIMESTAMP_LTZ((int)6), DataTypes.TIMESTAMP_LTZ((int)9));
    private static final List<InternalRow> TEST_DATA = Arrays.asList(GenericRow.of((Object[])new Object[]{true, (byte)1, (short)2, 3, 4L, Float.valueOf(5.0f), 6.0, Decimal.fromUnscaledLong((long)1234L, (int)10, (int)3), BinaryString.fromString((String)"abc"), BinaryString.fromString((String)"Hello World!"), new byte[]{1, 2, 3, 4, 5}, new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10}, 3600000, 100, TimestampNtz.fromMillis((long)3600000L), TimestampNtz.fromMillis((long)3600123L), TimestampNtz.fromMillis((long)3600123L, (int)456000), TimestampNtz.fromMillis((long)3600123L, (int)456789), TimestampLtz.fromEpochMillis((long)3600000L), TimestampLtz.fromEpochMillis((long)3600123L), TimestampLtz.fromEpochMillis((long)3600123L, (int)456000), TimestampLtz.fromEpochMillis((long)3600123L, (int)456789)}), GenericRow.of((Object[])new Object[]{false, (byte)1, (short)2, null, 4L, Float.valueOf(5.0f), 6.0, Decimal.fromUnscaledLong((long)1234L, (int)10, (int)3), BinaryString.fromString((String)"abc"), null, new byte[]{1, 2, 3, 4, 5}, new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10}, 3600000, 123, null, TimestampNtz.fromMillis((long)3600120L), TimestampNtz.fromMillis((long)3600120L, (int)120000), TimestampNtz.fromMillis((long)3600120L, (int)123450), null, TimestampLtz.fromEpochMillis((long)3600120L), TimestampLtz.fromEpochMillis((long)3600120L, (int)120000), TimestampLtz.fromEpochMillis((long)3600120L, (int)123450)}));

    ArrowReaderWriterTest() {
    }

    @Test
    void testReaderWriter() throws IOException {
        RowType rowType = DataTypes.ROW((DataType[])ALL_TYPES.toArray(new DataType[0]));
        try (RootAllocator allocator = new RootAllocator(Long.MAX_VALUE);
             VectorSchemaRoot root = VectorSchemaRoot.create((Schema)ArrowUtils.toArrowSchema((RowType)rowType), (BufferAllocator)allocator);
             ArrowWriterPool provider = new ArrowWriterPool((BufferAllocator)allocator);
             ArrowWriter writer = provider.getOrCreateWriter(1L, 1, Integer.MAX_VALUE, rowType);){
            for (InternalRow row : TEST_DATA) {
                writer.writeRow(row);
            }
            ManagedPagedOutputView pagedOutputView = new ManagedPagedOutputView((MemorySegmentPool)new TestingMemorySegmentPool(10240));
            int size = writer.serializeToOutputView((AbstractPagedOutputView)pagedOutputView, pagedOutputView.getCurrentSegment(), 44, true);
            MemorySegment segment = MemorySegment.allocateHeapMemory((int)writer.sizeInBytes());
            Assertions.assertThat((int)pagedOutputView.getSegmentBytesViewList().size()).isEqualTo(1);
            MemorySegment firstSegment = pagedOutputView.getCurrentSegment();
            firstSegment.copyTo(44, segment, 0, size);
            ArrowReader reader = ArrowUtils.createArrowReader((MemorySegment)segment, (int)0, (int)size, (VectorSchemaRoot)root, (BufferAllocator)allocator, (RowType)rowType);
            int rowCount = reader.getRowCount();
            ColumnarRow row = reader.read(0);
            for (int i = 0; i < rowCount; ++i) {
                row.setRowId(i);
                InternalRowAssert.assertThatRow((InternalRow)row).withSchema(rowType).isEqualTo(TEST_DATA.get(i));
            }
        }
    }

    @Test
    void testWriterExceedMaxSizeInBytes() {
        try (RootAllocator allocator = new RootAllocator(Long.MAX_VALUE);
             ArrowWriterPool provider = new ArrowWriterPool((BufferAllocator)allocator);
             ArrowWriter writer = provider.getOrCreateWriter(1L, 1, 1024, TestData.DATA1_ROW_TYPE);){
            while (!writer.isFull()) {
                writer.writeRow((InternalRow)DataTestUtils.row(TestData.DATA1_ROW_TYPE, TestData.DATA1.get(0)));
            }
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> writer.writeRow((InternalRow)DataTestUtils.row(TestData.DATA1_ROW_TYPE, TestData.DATA1.get(0)))).isInstanceOf(IllegalStateException.class)).hasMessage("The arrow batch size is full and it shouldn't accept writing new rows, it's a bug.");
        }
    }
}

