/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.row.arrow;

import com.alibaba.fluss.record.TestData;
import com.alibaba.fluss.row.arrow.ArrowWriter;
import com.alibaba.fluss.row.arrow.ArrowWriterPool;
import com.alibaba.fluss.shaded.arrow.org.apache.arrow.memory.BufferAllocator;
import com.alibaba.fluss.shaded.arrow.org.apache.arrow.memory.RootAllocator;
import java.util.Collection;
import java.util.Deque;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ArrowWriterPoolTest {
    private BufferAllocator allocator;

    @BeforeEach
    void setup() {
        this.allocator = new RootAllocator(Long.MAX_VALUE);
    }

    @AfterEach
    void tearDown() {
        this.allocator.close();
    }

    @Test
    void testWriterMap() {
        ArrowWriterPool arrowWriterPool = new ArrowWriterPool(this.allocator);
        Map freeWritersMap = arrowWriterPool.freeWriters();
        ArrowWriter writer1 = arrowWriterPool.getOrCreateWriter(1L, 1, 1024, TestData.DATA1_ROW_TYPE);
        Assertions.assertThat((int)writer1.getMaxSizeInBytes()).isEqualTo(1024);
        Assertions.assertThat((boolean)freeWritersMap.isEmpty()).isTrue();
        long epoch = writer1.getEpoch();
        writer1.recycle(epoch);
        Assertions.assertThat((int)freeWritersMap.size()).isEqualTo(1);
        Assertions.assertThat((Collection)((Collection)freeWritersMap.get("1-1"))).hasSize(1);
        Assertions.assertThat((long)writer1.getEpoch()).isEqualTo(epoch + 1L);
        writer1.recycle(epoch);
        Assertions.assertThat((int)freeWritersMap.size()).isEqualTo(1);
        Assertions.assertThat((Collection)((Collection)freeWritersMap.get("1-1"))).hasSize(1);
        ArrowWriter writer2 = arrowWriterPool.getOrCreateWriter(1L, 2, 10, TestData.DATA1_ROW_TYPE);
        Assertions.assertThat((int)freeWritersMap.size()).isEqualTo(1);
        writer2.recycle(writer2.getEpoch());
        Assertions.assertThat((int)freeWritersMap.size()).isEqualTo(2);
        Deque arrowWriters = (Deque)freeWritersMap.get("1-1");
        Assertions.assertThat((int)arrowWriters.size()).isEqualTo(1);
        writer1 = arrowWriterPool.getOrCreateWriter(1L, 1, 1000, TestData.DATA1_ROW_TYPE);
        Assertions.assertThat((int)arrowWriters.size()).isEqualTo(0);
        Assertions.assertThat((int)writer1.getMaxSizeInBytes()).isEqualTo(1000);
        ArrowWriter writer3WithKey1 = arrowWriterPool.getOrCreateWriter(1L, 1, 100, TestData.DATA1_ROW_TYPE);
        writer3WithKey1.recycle(writer3WithKey1.getEpoch());
        writer1.recycle(writer1.getEpoch());
        Assertions.assertThat((int)arrowWriters.size()).isEqualTo(2);
        arrowWriterPool.close();
    }
}

