/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.row.compacted;

import com.alibaba.fluss.row.BinaryString;
import com.alibaba.fluss.row.GenericRow;
import com.alibaba.fluss.row.InternalRow;
import com.alibaba.fluss.row.TestInternalRowGenerator;
import com.alibaba.fluss.row.compacted.CompactedRowReader;
import com.alibaba.fluss.row.compacted.CompactedRowWriter;
import com.alibaba.fluss.row.indexed.IndexedRow;
import com.alibaba.fluss.row.indexed.IndexedRowTest;
import com.alibaba.fluss.row.indexed.IndexedRowWriter;
import com.alibaba.fluss.testutils.InternalRowAssert;
import com.alibaba.fluss.types.DataType;
import com.alibaba.fluss.types.RowType;
import java.util.Random;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class CompactedRowWriterTest {
    CompactedRowWriterTest() {
    }

    @Test
    public void testAllBitsNumber() {
        int intValue = 0;
        for (int i = 0; i < 32; ++i) {
            this.testInt(intValue |= 1 << i);
        }
        long longValue = 0L;
        for (int i = 0; i < 64; ++i) {
            this.testLong(longValue |= 1L << i);
        }
    }

    @Test
    public void testRandomNumber() {
        Random rnd = new Random();
        for (int i = 0; i < 10000; ++i) {
            this.testInt(rnd.nextInt());
            this.testLong(rnd.nextLong());
        }
    }

    private void testInt(int value) {
        CompactedRowWriter writer = new CompactedRowWriter(1);
        writer.writeInt(value);
        CompactedRowReader reader = new CompactedRowReader(1);
        reader.pointTo(writer.segment(), 0, writer.position());
        Assertions.assertThat((int)reader.readInt()).isEqualTo(value);
    }

    private void testLong(long value) {
        CompactedRowWriter writer = new CompactedRowWriter(1);
        writer.writeLong(value);
        CompactedRowReader reader = new CompactedRowReader(1);
        reader.pointTo(writer.segment(), 0, writer.position());
        Assertions.assertThat((long)reader.readLong()).isEqualTo(value);
        reader.pointTo(writer.segment(), 0, writer.buffer().length);
        Assertions.assertThat((long)reader.readLong()).isEqualTo(value);
    }

    @Test
    public void testTypes() {
        int i;
        DataType[] allDataTypes = TestInternalRowGenerator.createAllTypes();
        CompactedRowWriter writer = new CompactedRowWriter(allDataTypes.length);
        CompactedRowReader reader = new CompactedRowReader(allDataTypes.length);
        InternalRow.FieldGetter[] getters = new InternalRow.FieldGetter[allDataTypes.length];
        CompactedRowWriter.FieldWriter[] writers = new CompactedRowWriter.FieldWriter[allDataTypes.length];
        CompactedRowReader.FieldReader[] readers = new CompactedRowReader.FieldReader[allDataTypes.length];
        for (i = 0; i < allDataTypes.length; ++i) {
            getters[i] = InternalRow.createFieldGetter((DataType)allDataTypes[i], (int)i);
            writers[i] = CompactedRowWriter.createFieldWriter((DataType)allDataTypes[i]);
            readers[i] = CompactedRowReader.createFieldReader((DataType)allDataTypes[i]);
        }
        for (i = 0; i < 1000; ++i) {
            IndexedRowWriter indexedRowWriter = IndexedRowTest.genRecordForAllTypes(allDataTypes);
            IndexedRow indexedRow = new IndexedRow(allDataTypes);
            indexedRow.pointTo(indexedRowWriter.segment(), 0, writer.position());
            writer.reset();
            for (int j = 0; j < allDataTypes.length; ++j) {
                writers[j].writeField(writer, j, getters[j].getFieldOrNull((InternalRow)indexedRow));
            }
            reader.pointTo(writer.segment(), 0, writer.position());
            GenericRow readRow = new GenericRow(allDataTypes.length);
            for (int j = 0; j < allDataTypes.length; ++j) {
                readRow.setField(j, readers[j].readField(reader, j));
            }
            InternalRowAssert.assertThatRow((InternalRow)readRow).withSchema(RowType.of((DataType[])allDataTypes)).isEqualTo((InternalRow)indexedRow);
        }
    }

    private BinaryString randomVarString() {
        Random rnd = new Random();
        return BinaryString.fromString((String)String.valueOf(rnd.nextLong()));
    }

    @Test
    public void testWriteVarSegments() {
        CompactedRowWriter writer = new CompactedRowWriter(2);
        CompactedRowReader reader = new CompactedRowReader(2);
        for (int i = 0; i < 1; ++i) {
            writer.reset();
            BinaryString s1 = this.randomVarString();
            BinaryString s2 = this.randomVarString();
            BinaryString s3 = this.randomVarString();
            writer.writeString(s1);
            writer.writeString(s2);
            writer.writeString(s3);
            reader.pointTo(writer.segment(), 0, writer.position());
            Assertions.assertThat((Comparable)reader.readString()).isEqualTo((Object)s1);
            Assertions.assertThat((Comparable)reader.readString()).isEqualTo((Object)s2);
            Assertions.assertThat((Comparable)reader.readString()).isEqualTo((Object)s3);
        }
    }

    @Test
    void testTooManyFields() {
        int numFields = 2000;
        CompactedRowWriter compactedRowWriter = new CompactedRowWriter(numFields);
        for (int i = 1; i <= 3; ++i) {
            compactedRowWriter.reset();
            for (int j = 0; j < numFields; ++j) {
                compactedRowWriter.writeInt(i * j);
            }
            CompactedRowReader compactedRowReader = new CompactedRowReader(numFields);
            compactedRowReader.pointTo(compactedRowWriter.segment(), 0, compactedRowWriter.position());
            for (int j = 0; j < numFields; ++j) {
                Assertions.assertThat((int)compactedRowReader.readInt()).isEqualTo(i * j);
            }
        }
    }
}

