/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.row.encode;

import com.alibaba.fluss.memory.MemorySegment;
import com.alibaba.fluss.row.BinaryString;
import com.alibaba.fluss.row.GenericRow;
import com.alibaba.fluss.row.InternalRow;
import com.alibaba.fluss.row.TestInternalRowGenerator;
import com.alibaba.fluss.row.compacted.CompactedRowDeserializer;
import com.alibaba.fluss.row.compacted.CompactedRowReader;
import com.alibaba.fluss.row.encode.KeyEncoder;
import com.alibaba.fluss.row.indexed.IndexedRow;
import com.alibaba.fluss.row.indexed.IndexedRowTest;
import com.alibaba.fluss.row.indexed.IndexedRowWriter;
import com.alibaba.fluss.testutils.DataTestUtils;
import com.alibaba.fluss.types.DataType;
import com.alibaba.fluss.types.DataTypes;
import com.alibaba.fluss.types.RowType;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.IntStream;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class KeyEncoderTest {
    KeyEncoderTest() {
    }

    @Test
    void testEncode() {
        RowType rowType = RowType.of((DataType[])new DataType[]{DataTypes.INT(), DataTypes.BIGINT(), DataTypes.INT()});
        IndexedRow row = DataTestUtils.row(rowType, new Object[]{1, 3L, 2});
        KeyEncoder encoder = new KeyEncoder(rowType);
        byte[] bytes = encoder.encode((InternalRow)row);
        Assertions.assertThat((byte[])bytes).isEqualTo((Object)new byte[]{1, 3, 2});
        row = DataTestUtils.row(rowType, new Object[]{2, 5L, 6});
        bytes = encoder.encode((InternalRow)row);
        Assertions.assertThat((byte[])bytes).isEqualTo((Object)new byte[]{2, 5, 6});
    }

    @Test
    void testEncodeWithPartitionedKey() {
        DataType[] dataTypes = new DataType[]{DataTypes.STRING(), DataTypes.BIGINT(), DataTypes.STRING()};
        String[] fieldNames = new String[]{"partition", "f1", "f2"};
        RowType rowType = RowType.of((DataType[])dataTypes, (String[])fieldNames);
        IndexedRow row = DataTestUtils.row(rowType, new Object[]{"p1", 1L, "a2"});
        List<String> pk = Arrays.asList("partition", "f2");
        List<String> partitionKeys = Collections.singletonList("partition");
        KeyEncoder keyEncoder = KeyEncoder.createKeyEncoder((RowType)rowType, pk, partitionKeys);
        byte[] encodedBytes = keyEncoder.encode((InternalRow)row);
        InternalRow encodedKey = this.decodeRow(new DataType[]{DataTypes.STRING().copy(false)}, encodedBytes);
        Assertions.assertThat((int)encodedKey.getFieldCount()).isEqualTo(1);
        Assertions.assertThat((String)encodedKey.getString(0).toString()).isEqualTo("a2");
    }

    @Test
    void testGetKey() {
        RowType rowType = RowType.of((DataType[])new DataType[]{DataTypes.INT(), DataTypes.BIGINT(), DataTypes.INT(), DataTypes.STRING()});
        int[] pkIndexes = new int[]{0, 1, 2};
        KeyEncoder keyEncoder = new KeyEncoder(rowType, pkIndexes);
        IndexedRow row = DataTestUtils.row(rowType, new Object[]{1, 3L, 2, "a1"});
        byte[] keyBytes = keyEncoder.encode((InternalRow)row);
        Assertions.assertThat((byte[])keyBytes).isEqualTo((Object)new byte[]{1, 3, 2});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            IndexedRow nullRow = DataTestUtils.row(rowType, new Object[]{1, 2L, null, "a2"});
            keyEncoder.encode((InternalRow)nullRow);
        }).isInstanceOf(IllegalArgumentException.class)).hasMessage("Null value is not allowed for compacted key encoder in position 2 with type INT.");
        RowType rowType1 = RowType.of((DataType[])new DataType[]{DataTypes.STRING(), DataTypes.INT(), DataTypes.STRING(), DataTypes.STRING()});
        pkIndexes = new int[]{1, 2};
        KeyEncoder keyEncoder1 = new KeyEncoder(rowType1, pkIndexes);
        row = DataTestUtils.row(rowType1, new Object[]{BinaryString.fromString((String)"a1"), 1, BinaryString.fromString((String)"a2"), BinaryString.fromString((String)"a3")});
        keyBytes = keyEncoder1.encode((InternalRow)row);
        InternalRow keyRow = this.decodeRow(new DataType[]{DataTypes.INT().copy(false), DataTypes.STRING().copy(false)}, keyBytes);
        Assertions.assertThat((int)keyRow.getInt(0)).isEqualTo(1);
        Assertions.assertThat((String)keyRow.getString(1).toString()).isEqualTo("a2");
    }

    @Test
    void testGetKeyForAllTypes() throws Exception {
        RowType rowType = TestInternalRowGenerator.createAllRowType();
        DataType[] dataTypes = rowType.getChildren().toArray(new DataType[0]);
        try (IndexedRowWriter writer = IndexedRowTest.genRecordForAllTypes(dataTypes);){
            int i;
            IndexedRow row = new IndexedRow(dataTypes);
            row.pointTo(writer.segment(), 0, writer.position());
            int[] pkIndexes = IntStream.range(0, rowType.getFieldCount() - 1).toArray();
            DataType[] keyDataTypes = new DataType[pkIndexes.length];
            for (int i2 = 0; i2 < pkIndexes.length; ++i2) {
                keyDataTypes[i2] = dataTypes[pkIndexes[i2]].copy(false);
            }
            KeyEncoder keyEncoder = new KeyEncoder(rowType, pkIndexes);
            byte[] keyBytes = keyEncoder.encode((InternalRow)row);
            InternalRow keyRow = this.decodeRow(keyDataTypes, keyBytes);
            InternalRow.FieldGetter[] fieldGetters = new InternalRow.FieldGetter[keyDataTypes.length];
            for (i = 0; i < keyDataTypes.length; ++i) {
                fieldGetters[i] = InternalRow.createFieldGetter((DataType)keyDataTypes[i], (int)i);
            }
            for (i = 0; i < keyDataTypes.length; ++i) {
                Assertions.assertThat((Object)fieldGetters[i].getFieldOrNull(keyRow)).isEqualTo(fieldGetters[i].getFieldOrNull((InternalRow)row));
            }
        }
    }

    private InternalRow decodeRow(DataType[] dataTypes, byte[] values) {
        CompactedRowReader compactedRowReader = new CompactedRowReader(0);
        compactedRowReader.pointTo(MemorySegment.wrap((byte[])values), 0, values.length);
        CompactedRowDeserializer compactedRowDeserializer = new CompactedRowDeserializer(dataTypes);
        GenericRow genericRow = new GenericRow(dataTypes.length);
        compactedRowDeserializer.deserialize(compactedRowReader, genericRow);
        return genericRow;
    }
}

