/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.row.indexed;

import com.alibaba.fluss.row.BinaryString;
import com.alibaba.fluss.row.Decimal;
import com.alibaba.fluss.row.InternalRow;
import com.alibaba.fluss.row.TestInternalRowGenerator;
import com.alibaba.fluss.row.indexed.IndexedRow;
import com.alibaba.fluss.row.indexed.IndexedRowReader;
import com.alibaba.fluss.row.indexed.IndexedRowTest;
import com.alibaba.fluss.row.indexed.IndexedRowWriter;
import com.alibaba.fluss.types.DataType;
import com.alibaba.fluss.utils.DateTimeUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalTime;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class IndexedRowReaderTest {
    private DataType[] dataTypes;
    private IndexedRowWriter writer;
    private IndexedRowReader reader;

    @BeforeEach
    public void before() {
        this.dataTypes = TestInternalRowGenerator.createAllTypes();
        this.writer = IndexedRowTest.genRecordForAllTypes(this.dataTypes);
        this.reader = new IndexedRowReader(this.dataTypes);
        this.reader.pointTo(this.writer.segment(), 0);
    }

    @Test
    void testWriteAndReadAllTypes() {
        this.assertAllTypeEqualsForReader(this.reader);
    }

    @Test
    void testCreateFieldReader() {
        IndexedRowWriter.FieldWriter[] writers = new IndexedRowWriter.FieldWriter[this.dataTypes.length];
        IndexedRowReader.FieldReader[] readers = new IndexedRowReader.FieldReader[this.dataTypes.length];
        for (int i = 0; i < this.dataTypes.length; ++i) {
            readers[i] = IndexedRowReader.createFieldReader((DataType)this.dataTypes[i]);
            writers[i] = IndexedRowWriter.createFieldWriter((DataType)this.dataTypes[i]);
        }
        IndexedRowWriter writer1 = new IndexedRowWriter(this.dataTypes);
        for (int i = 0; i < this.dataTypes.length; ++i) {
            writers[i].writeField(writer1, i, readers[i].readField(this.reader, i));
        }
        IndexedRow row1 = new IndexedRow(this.dataTypes);
        row1.pointTo(writer1.segment(), 0, this.writer.position());
        IndexedRowTest.assertAllTypeEquals((InternalRow)row1);
    }

    private void assertAllTypeEqualsForReader(IndexedRowReader reader) {
        Assertions.assertThat((boolean)reader.readBoolean()).isEqualTo(true);
        Assertions.assertThat((byte)reader.readByte()).isEqualTo((byte)2);
        Assertions.assertThat((short)reader.readShort()).isEqualTo(Short.parseShort("10"));
        Assertions.assertThat((int)reader.readInt()).isEqualTo(100);
        Assertions.assertThat((long)reader.readLong()).isEqualTo(new BigInteger("12345678901234567890").longValue());
        Assertions.assertThat((float)reader.readFloat()).isEqualTo(Float.parseFloat("13.2"));
        Assertions.assertThat((double)reader.readDouble()).isEqualTo(Double.parseDouble("15.21"));
        Assertions.assertThat((LocalDate)DateTimeUtils.toLocalDate((int)reader.readInt())).isEqualTo((Object)LocalDate.of(2023, 10, 25));
        Assertions.assertThat((LocalTime)DateTimeUtils.toLocalTime((int)reader.readInt())).isEqualTo((Object)LocalTime.of(9, 30, 0, 0));
        Assertions.assertThat((byte[])reader.readBinary(20)).isEqualTo((Object)"1234567890".getBytes());
        Assertions.assertThat((byte[])reader.readBytes()).isEqualTo((Object)"20".getBytes());
        Assertions.assertThat((Comparable)reader.readChar(2)).isEqualTo((Object)BinaryString.fromString((String)"1"));
        Assertions.assertThat((Comparable)reader.readString()).isEqualTo((Object)BinaryString.fromString((String)"hello"));
        Assertions.assertThat((Comparable)reader.readDecimal(5, 2)).isEqualTo((Object)Decimal.fromUnscaledLong((long)9L, (int)5, (int)2));
        Assertions.assertThat((Comparable)reader.readDecimal(20, 0)).isEqualTo((Object)Decimal.fromBigDecimal((BigDecimal)new BigDecimal(10), (int)20, (int)0));
        Assertions.assertThat((String)reader.readTimestampNtz(1).toString()).isEqualTo("2023-10-25T12:01:13.182");
        Assertions.assertThat((String)reader.readTimestampNtz(5).toString()).isEqualTo("2023-10-25T12:01:13.182");
        Assertions.assertThat((String)reader.readTimestampLtz(1).toString()).isEqualTo("2023-10-25T12:01:13.182Z");
        Assertions.assertThat((boolean)reader.isNullAt(18)).isTrue();
    }
}

