/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.row.indexed;

import com.alibaba.fluss.memory.MemorySegment;
import com.alibaba.fluss.row.BinaryString;
import com.alibaba.fluss.row.Decimal;
import com.alibaba.fluss.row.InternalRow;
import com.alibaba.fluss.row.TestInternalRowGenerator;
import com.alibaba.fluss.row.TimestampLtz;
import com.alibaba.fluss.row.TimestampNtz;
import com.alibaba.fluss.row.indexed.IndexedRow;
import com.alibaba.fluss.row.indexed.IndexedRowWriter;
import com.alibaba.fluss.types.DataType;
import com.alibaba.fluss.types.DataTypes;
import com.alibaba.fluss.types.IntType;
import com.alibaba.fluss.types.StringType;
import com.alibaba.fluss.utils.DateTimeUtils;
import com.alibaba.fluss.utils.TypeUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalTime;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class IndexedRowTest {
    @Test
    void testConstructor() {
        IndexedRow indexedRow = new IndexedRow(new DataType[0]);
        Assertions.assertThat((int)indexedRow.getFieldCount()).isEqualTo(0);
        Assertions.assertThat((int)indexedRow.getHeaderSizeInBytes()).isEqualTo(0);
        indexedRow = new IndexedRow(new DataType[]{new IntType()});
        Assertions.assertThat((int)indexedRow.getFieldCount()).isEqualTo(1);
        Assertions.assertThat((int)indexedRow.getHeaderSizeInBytes()).isEqualTo(1);
        indexedRow = new IndexedRow(new DataType[]{new IntType(), new StringType()});
        Assertions.assertThat((int)indexedRow.getFieldCount()).isEqualTo(2);
        Assertions.assertThat((int)indexedRow.getHeaderSizeInBytes()).isEqualTo(5);
    }

    @Test
    void testWriterAndIndexedRowGetter() {
        DataType[] dataTypes = TestInternalRowGenerator.createAllTypes();
        IndexedRow row = new IndexedRow(dataTypes);
        IndexedRowWriter writer = IndexedRowTest.genRecordForAllTypes(dataTypes);
        row.pointTo(writer.segment(), 0, writer.position());
        IndexedRowTest.assertAllTypeEquals((InternalRow)row);
        Assertions.assertThat((int)row.getHeaderSizeInBytes()).isEqualTo(15);
        Assertions.assertThat((int)row.getSizeInBytes()).isEqualTo(117);
        Assertions.assertThat((int)row.getFieldCount()).isEqualTo(19);
        Assertions.assertThat((boolean)row.anyNull()).isTrue();
        Assertions.assertThat((boolean)row.anyNull(new int[]{0, 1})).isFalse();
    }

    @Test
    void testCopy() {
        DataType[] dataTypes = new DataType[]{DataTypes.INT()};
        IndexedRow row = new IndexedRow(dataTypes);
        IndexedRowWriter writer = new IndexedRowWriter(dataTypes);
        writer.writeInt(1000);
        row.pointTo(writer.segment(), 0, writer.position());
        Assertions.assertThat((int)row.getInt(0)).isEqualTo(1000);
        IndexedRow indexedRow1 = row.copy();
        Assertions.assertThat((int)indexedRow1.getInt(0)).isEqualTo(1000);
        IndexedRow indexedRow2 = new IndexedRow(dataTypes);
        row.copy(indexedRow2);
        Assertions.assertThat((int)indexedRow2.getInt(0)).isEqualTo(1000);
    }

    @Test
    public void testEqualsAndHashCode() {
        DataType[] dataTypes = new DataType[]{DataTypes.INT()};
        IndexedRow row = new IndexedRow(dataTypes);
        IndexedRowWriter writer = new IndexedRowWriter(dataTypes);
        writer.writeInt(1);
        row.pointTo(writer.segment(), 0, writer.position());
        byte[] buffer = new byte[row.getSizeInBytes() + 23];
        System.arraycopy(writer.buffer(), 0, buffer, 13, row.getSizeInBytes());
        IndexedRow newRow = new IndexedRow(dataTypes);
        newRow.pointTo(MemorySegment.wrap((byte[])buffer), 13, row.getSizeInBytes());
        Assertions.assertThat((Object)row).isEqualTo((Object)row);
        Assertions.assertThat((Object)newRow).isEqualTo((Object)row);
        Assertions.assertThat((int)newRow.hashCode()).isEqualTo(row.hashCode());
    }

    @Test
    void testCreateFieldWriter() {
        DataType[] dataTypes = TestInternalRowGenerator.createAllTypes();
        IndexedRow row = new IndexedRow(dataTypes);
        IndexedRowWriter writer = IndexedRowTest.genRecordForAllTypes(dataTypes);
        row.pointTo(writer.segment(), 0, writer.position());
        InternalRow.FieldGetter[] fieldGetter = new InternalRow.FieldGetter[dataTypes.length];
        IndexedRowWriter.FieldWriter[] writers = new IndexedRowWriter.FieldWriter[dataTypes.length];
        for (int i = 0; i < dataTypes.length; ++i) {
            fieldGetter[i] = InternalRow.createFieldGetter((DataType)dataTypes[i], (int)i);
            writers[i] = IndexedRowWriter.createFieldWriter((DataType)dataTypes[i]);
        }
        IndexedRowWriter writer1 = new IndexedRowWriter(dataTypes);
        for (int i = 0; i < dataTypes.length; ++i) {
            writers[i].writeField(writer1, i, fieldGetter[i].getFieldOrNull((InternalRow)row));
        }
        IndexedRow row1 = new IndexedRow(dataTypes);
        row1.pointTo(writer1.segment(), 0, writer.position());
        IndexedRowTest.assertAllTypeEquals((InternalRow)row1);
    }

    @Test
    void testWriterReset() {
        DataType[] dataTypes = new DataType[]{DataTypes.INT()};
        IndexedRow row = new IndexedRow(dataTypes);
        IndexedRowWriter writer = new IndexedRowWriter(dataTypes);
        writer.writeInt(1);
        row.pointTo(writer.segment(), 0, writer.position());
        writer.reset();
        Assertions.assertThat((int)writer.position()).isEqualTo(1);
    }

    @Test
    void testProjectRow() {
        DataType[] dataTypes = new DataType[]{DataTypes.INT(), DataTypes.INT(), DataTypes.STRING(), DataTypes.BIGINT()};
        IndexedRow row = new IndexedRow(dataTypes);
        IndexedRowWriter writer = new IndexedRowWriter(dataTypes);
        writer.writeInt(1000);
        writer.writeInt(2000);
        writer.writeString(BinaryString.fromString((String)"hello"));
        writer.writeLong(500000L);
        row.pointTo(writer.segment(), 0, writer.position());
        Assertions.assertThat((int)row.getInt(0)).isEqualTo(1000);
        Assertions.assertThat((Comparable)row.getString(2)).isEqualTo((Object)BinaryString.fromString((String)"hello"));
        IndexedRow projectRow = row.projectRow(new int[]{0, 2});
        Assertions.assertThat((int)projectRow.getInt(0)).isEqualTo(1000);
        Assertions.assertThat((Comparable)projectRow.getString(1)).isEqualTo((Object)BinaryString.fromString((String)"hello"));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> row.projectRow(new int[]{0, 1, 2, 3, 4})).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("project fields length is larger than row arity");
    }

    public static IndexedRowWriter genRecordForAllTypes(DataType[] dataTypes) {
        IndexedRowWriter writer = new IndexedRowWriter(dataTypes);
        writer.writeBoolean(true);
        writer.writeByte((byte)2);
        writer.writeShort(Short.parseShort("10"));
        writer.writeInt(100);
        writer.writeLong(new BigInteger("12345678901234567890").longValue());
        writer.writeFloat(Float.parseFloat("13.2"));
        writer.writeDouble(Double.parseDouble("15.21"));
        writer.writeInt(((Integer)TypeUtils.castFromString((String)"2023-10-25", (DataType)DataTypes.DATE())).intValue());
        writer.writeInt(((Integer)TypeUtils.castFromString((String)"09:30:00.0", (DataType)DataTypes.TIME())).intValue());
        writer.writeBinary("1234567890".getBytes(), 20);
        writer.writeBytes("20".getBytes());
        writer.writeChar(BinaryString.fromString((String)"1"), 2);
        writer.writeString(BinaryString.fromString((String)"hello"));
        writer.writeDecimal(Decimal.fromUnscaledLong((long)9L, (int)5, (int)2), 5);
        writer.writeDecimal(Decimal.fromBigDecimal((BigDecimal)new BigDecimal(10), (int)20, (int)0), 20);
        writer.writeTimestampNtz(TimestampNtz.fromMillis((long)1698235273182L), 1);
        writer.writeTimestampNtz(TimestampNtz.fromMillis((long)1698235273182L), 5);
        writer.writeTimestampLtz(TimestampLtz.fromEpochMillis((long)1698235273182L), 1);
        writer.setNullAt(18);
        return writer;
    }

    public static void assertAllTypeEquals(InternalRow row) {
        Assertions.assertThat((boolean)row.getBoolean(0)).isEqualTo(true);
        Assertions.assertThat((byte)row.getByte(1)).isEqualTo((byte)2);
        Assertions.assertThat((short)row.getShort(2)).isEqualTo(Short.parseShort("10"));
        Assertions.assertThat((int)row.getInt(3)).isEqualTo(100);
        Assertions.assertThat((long)row.getLong(4)).isEqualTo(new BigInteger("12345678901234567890").longValue());
        Assertions.assertThat((float)row.getFloat(5)).isEqualTo(Float.parseFloat("13.2"));
        Assertions.assertThat((double)row.getDouble(6)).isEqualTo(Double.parseDouble("15.21"));
        Assertions.assertThat((LocalDate)DateTimeUtils.toLocalDate((int)row.getInt(7))).isEqualTo((Object)LocalDate.of(2023, 10, 25));
        Assertions.assertThat((LocalTime)DateTimeUtils.toLocalTime((int)row.getInt(8))).isEqualTo((Object)LocalTime.of(9, 30, 0, 0));
        Assertions.assertThat((byte[])row.getBinary(9, 20)).isEqualTo((Object)"1234567890".getBytes());
        Assertions.assertThat((byte[])row.getBytes(10)).isEqualTo((Object)"20".getBytes());
        Assertions.assertThat((Comparable)row.getChar(11, 2)).isEqualTo((Object)BinaryString.fromString((String)"1"));
        Assertions.assertThat((Comparable)row.getString(12)).isEqualTo((Object)BinaryString.fromString((String)"hello"));
        Assertions.assertThat((Comparable)row.getDecimal(13, 5, 2)).isEqualTo((Object)Decimal.fromUnscaledLong((long)9L, (int)5, (int)2));
        Assertions.assertThat((Comparable)row.getDecimal(14, 20, 0)).isEqualTo((Object)Decimal.fromBigDecimal((BigDecimal)new BigDecimal(10), (int)20, (int)0));
        Assertions.assertThat((String)row.getTimestampNtz(15, 1).toString()).isEqualTo("2023-10-25T12:01:13.182");
        Assertions.assertThat((String)row.getTimestampNtz(16, 5).toString()).isEqualTo("2023-10-25T12:01:13.182");
        Assertions.assertThat((String)row.getTimestampLtz(17, 5).toString()).isEqualTo("2023-10-25T12:01:13.182Z");
        Assertions.assertThat((boolean)row.isNullAt(18)).isTrue();
    }
}

