/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.testutils;

import com.alibaba.fluss.config.Configuration;
import com.alibaba.fluss.fs.FsPath;
import com.alibaba.fluss.memory.MemorySegmentOutputView;
import com.alibaba.fluss.metadata.KvFormat;
import com.alibaba.fluss.metadata.PhysicalTablePath;
import com.alibaba.fluss.metadata.Schema;
import com.alibaba.fluss.metadata.TableBucket;
import com.alibaba.fluss.record.DefaultLogRecordBatch;
import com.alibaba.fluss.record.FileLogRecords;
import com.alibaba.fluss.record.KvRecord;
import com.alibaba.fluss.record.KvRecordBatch;
import com.alibaba.fluss.record.KvRecordTestUtils;
import com.alibaba.fluss.record.LogRecord;
import com.alibaba.fluss.record.LogRecordBatch;
import com.alibaba.fluss.record.LogRecordReadContext;
import com.alibaba.fluss.record.LogRecords;
import com.alibaba.fluss.record.MemoryLogRecords;
import com.alibaba.fluss.record.MemoryLogRecordsIndexedBuilder;
import com.alibaba.fluss.record.RowKind;
import com.alibaba.fluss.record.TestData;
import com.alibaba.fluss.remote.RemoteLogSegment;
import com.alibaba.fluss.row.BinaryRow;
import com.alibaba.fluss.row.BinaryString;
import com.alibaba.fluss.row.InternalRow;
import com.alibaba.fluss.row.compacted.CompactedRow;
import com.alibaba.fluss.row.encode.CompactedRowEncoder;
import com.alibaba.fluss.row.encode.KeyEncoder;
import com.alibaba.fluss.row.encode.RowEncoder;
import com.alibaba.fluss.row.encode.ValueEncoder;
import com.alibaba.fluss.row.indexed.IndexedRow;
import com.alibaba.fluss.testutils.LogRecordBatchAssert;
import com.alibaba.fluss.types.DataType;
import com.alibaba.fluss.types.DataTypeRoot;
import com.alibaba.fluss.types.RowType;
import com.alibaba.fluss.utils.BytesUtils;
import com.alibaba.fluss.utils.CloseableIterator;
import com.alibaba.fluss.utils.FlussPaths;
import com.alibaba.fluss.utils.types.Tuple2;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;

public class DataTestUtils {
    public static CompactedRow compactedRow(RowType rowType, Object[] objects) {
        return DataTestUtils.genCompacted(rowType, objects);
    }

    public static IndexedRow keyRow(Schema schema, Object[] objects) {
        int[] pkIndex = schema.getPrimaryKeyIndexes();
        RowType rowType = schema.toRowType();
        return DataTestUtils.row(rowType, objects).projectRow(pkIndex);
    }

    public static IndexedRow row(RowType rowType, Object[] data) {
        DataType[] dataTypes = rowType.getChildren().toArray(new DataType[0]);
        Assertions.assertThat((int)dataTypes.length).isEqualTo(data.length);
        RowEncoder rowEncoder = RowEncoder.create((KvFormat)KvFormat.INDEXED, (DataType[])dataTypes);
        rowEncoder.startNewRow();
        for (int i = 0; i < dataTypes.length; ++i) {
            rowEncoder.encodeField(i, data[i] instanceof String ? BinaryString.fromString((String)((String)data[i])) : data[i]);
        }
        return (IndexedRow)rowEncoder.finishRow();
    }

    private static CompactedRow genCompacted(RowType rowType, Object[] data) {
        DataType[] dataTypes = rowType.getChildren().toArray(new DataType[0]);
        Assertions.assertThat((int)dataTypes.length).isEqualTo(data.length);
        CompactedRowEncoder rowEncoder = new CompactedRowEncoder(dataTypes);
        rowEncoder.startNewRow();
        for (int i = 0; i < dataTypes.length; ++i) {
            rowEncoder.encodeField(i, data[i] instanceof String ? BinaryString.fromString((String)((String)data[i])) : data[i]);
        }
        return (CompactedRow)rowEncoder.finishRow();
    }

    public static MemoryLogRecords genMemoryLogRecordsByObject(List<Object[]> objects) throws Exception {
        return DataTestUtils.createRecordsWithoutBaseLogOffset(TestData.DATA1_ROW_TYPE, 1, 0L, System.currentTimeMillis(), objects);
    }

    public static MemoryLogRecords genMemoryLogRecordsWithWriterId(List<Object[]> objects, long writerId, int batchSequence, long baseOffset) throws Exception {
        List<RowKind> rowKinds = objects.stream().map(row -> RowKind.APPEND_ONLY).collect(Collectors.toList());
        return DataTestUtils.createBasicMemoryLogRecords(TestData.DATA1_ROW_TYPE, 1, baseOffset, System.currentTimeMillis(), writerId, batchSequence, rowKinds, objects);
    }

    public static MemoryLogRecords genIndexedMemoryLogRecords(List<IndexedRow> rows) throws Exception {
        List<RowKind> rowKinds = rows.stream().map(row -> RowKind.APPEND_ONLY).collect(Collectors.toList());
        return DataTestUtils.createIndexedMemoryLogRecords(0L, System.currentTimeMillis(), 1, -1L, -1, rowKinds, rows);
    }

    public static MemoryLogRecords genMemoryLogRecordsWithBaseOffset(long offsetBase, List<Object[]> objects) throws Exception {
        return DataTestUtils.createRecordsWithoutBaseLogOffset(TestData.DATA1_ROW_TYPE, 1, offsetBase, -1L, objects);
    }

    public static MemoryLogRecords genLogRecordsWithBaseOffsetAndTimestamp(long offsetBase, long maxTimestamp, List<Object[]> objects) throws Exception {
        return DataTestUtils.createRecordsWithoutBaseLogOffset(TestData.DATA1_ROW_TYPE, 1, offsetBase, maxTimestamp, objects);
    }

    public static KvRecordBatch genKvRecordBatch(List<Tuple2<Object[], Object[]>> keyAndValues) throws Exception {
        return DataTestUtils.genKvRecordBatchWithWriterId(keyAndValues, -1L, -1);
    }

    public static KvRecordBatch genKvRecordBatchWithWriterId(List<Tuple2<Object[], Object[]>> keyAndValues, long writerId, int batchSequence) throws Exception {
        KeyEncoder keyEncoder = new KeyEncoder(TestData.DATA1_ROW_TYPE, new int[]{0});
        KvRecordTestUtils.KvRecordBatchFactory kvRecordBatchFactory = KvRecordTestUtils.KvRecordBatchFactory.of(1);
        KvRecordTestUtils.KvRecordFactory kvRecordFactory = KvRecordTestUtils.KvRecordFactory.of(TestData.DATA1_ROW_TYPE);
        ArrayList<KvRecord> records = new ArrayList<KvRecord>();
        for (Tuple2<Object[], Object[]> keyAndValue : keyAndValues) {
            records.add(kvRecordFactory.ofRecord(keyEncoder.encode((InternalRow)DataTestUtils.row(TestData.DATA1_KEY_TYPE, (Object[])keyAndValue.f0)), (Object[])keyAndValue.f1));
        }
        return kvRecordBatchFactory.ofRecords(records, writerId, batchSequence);
    }

    @SafeVarargs
    public static KvRecordBatch genKvRecordBatch(Tuple2<String, Object[]> ... keyAndValues) throws Exception {
        KvRecordTestUtils.KvRecordBatchFactory kvRecordBatchFactory = KvRecordTestUtils.KvRecordBatchFactory.of(1);
        List<KvRecord> records = DataTestUtils.genKvRecords(keyAndValues);
        return kvRecordBatchFactory.ofRecords(records);
    }

    public static KvRecordBatch genKvRecordBatch(Object[] ... values) throws Exception {
        KvRecordTestUtils.KvRecordBatchFactory kvRecordBatchFactory = KvRecordTestUtils.KvRecordBatchFactory.of(1);
        return kvRecordBatchFactory.ofRecords(DataTestUtils.genKvRecords(values));
    }

    public static KvRecordBatch toKvRecordBatch(List<KvRecord> records) throws Exception {
        KvRecordTestUtils.KvRecordBatchFactory kvRecordBatchFactory = KvRecordTestUtils.KvRecordBatchFactory.of(1);
        return kvRecordBatchFactory.ofRecords(records);
    }

    @SafeVarargs
    public static List<KvRecord> genKvRecords(Tuple2<String, Object[]> ... keyAndValues) {
        KvRecordTestUtils.KvRecordFactory kvRecordFactory = KvRecordTestUtils.KvRecordFactory.of(TestData.DATA1_ROW_TYPE);
        ArrayList<KvRecord> records = new ArrayList<KvRecord>();
        for (Tuple2<String, Object[]> keyAndValue : keyAndValues) {
            records.add(kvRecordFactory.ofRecord((String)keyAndValue.f0, (Object[])keyAndValue.f1));
        }
        return records;
    }

    public static void genRemoteLogSegmentFile(TableBucket tableBucket, PhysicalTablePath physicalTablePath, Configuration conf, RemoteLogSegment remoteLogSegment, long baseOffset) throws Exception {
        FsPath remoteLogTabletDir = FlussPaths.remoteLogTabletDir((FsPath)FlussPaths.remoteLogDir((Configuration)conf), (PhysicalTablePath)physicalTablePath, (TableBucket)tableBucket);
        FsPath remoteLogSegmentDir = FlussPaths.remoteLogSegmentDir((FsPath)remoteLogTabletDir, (UUID)remoteLogSegment.remoteLogSegmentId());
        DataTestUtils.genLogFile(TestData.DATA1_ROW_TYPE, new File(remoteLogSegmentDir.toString()), TestData.DATA1, baseOffset);
    }

    public static File genLogFile(RowType rowType, File segmentDir, List<Object[]> objects, long baseOffset) throws Exception {
        if (!segmentDir.exists()) {
            segmentDir.mkdirs();
        }
        File logFile = FlussPaths.logFile((File)segmentDir, (long)baseOffset);
        FileLogRecords fileLogRecords = FileLogRecords.open((File)logFile, (boolean)false, (int)0x100000, (boolean)false);
        fileLogRecords.append(DataTestUtils.createRecordsWithoutBaseLogOffset(rowType, 1, baseOffset, System.currentTimeMillis(), objects));
        fileLogRecords.flush();
        fileLogRecords.close();
        return logFile;
    }

    public static List<KvRecord> genKvRecords(Object[] ... values) {
        KvRecordTestUtils.PKBasedKvRecordFactory kvRecordFactory = KvRecordTestUtils.PKBasedKvRecordFactory.of(TestData.DATA1_SCHEMA_PK.toRowType(), TestData.DATA1_SCHEMA_PK.getPrimaryKeyIndexes());
        ArrayList<KvRecord> records = new ArrayList<KvRecord>();
        for (Object[] value : values) {
            records.add(kvRecordFactory.ofRecord(value));
        }
        return records;
    }

    public static List<Tuple2<byte[], byte[]>> getKeyValuePairs(List<KvRecord> kvRecords) {
        return DataTestUtils.getKeyValuePairs(kvRecords.toArray(new KvRecord[0]));
    }

    public static List<Tuple2<byte[], byte[]>> getKeyValuePairs(KvRecord ... kvRecords) {
        ArrayList<Tuple2<byte[], byte[]>> keyValuePairs = new ArrayList<Tuple2<byte[], byte[]>>();
        for (KvRecord kvRecord : kvRecords) {
            keyValuePairs.add((Tuple2<byte[], byte[]>)Tuple2.of((Object)BytesUtils.toArray((ByteBuffer)kvRecord.getKey()), (Object)ValueEncoder.encodeValue((short)1, (BinaryRow)kvRecord.getRow())));
        }
        return keyValuePairs;
    }

    public static MemoryLogRecords createRecordsWithoutBaseLogOffset(RowType rowType, int schemaId, long offsetBase, long maxTimestamp, List<Object[]> objects) throws Exception {
        List<RowKind> rowKinds = objects.stream().map(row -> RowKind.APPEND_ONLY).collect(Collectors.toList());
        return DataTestUtils.createBasicMemoryLogRecords(rowType, schemaId, offsetBase, maxTimestamp, -1L, -1, rowKinds, objects);
    }

    public static MemoryLogRecords createBasicMemoryLogRecords(RowType rowType, int schemaId, long offsetBase, long maxTimestamp, long writerId, int batchSequence, List<RowKind> rowKinds, List<Object[]> objects) throws Exception {
        List<InternalRow> rows = objects.stream().map(object -> DataTestUtils.row(rowType, object)).collect(Collectors.toList());
        return DataTestUtils.createArrowMemoryLogRecords(rowType, offsetBase, maxTimestamp, schemaId, writerId, batchSequence, rowKinds, rows);
    }

    private static MemoryLogRecords createIndexedMemoryLogRecords(long baseLogOffset, long maxTimestamp, int schemaId, long writerId, int batchSequence, List<RowKind> rowKinds, List<IndexedRow> rows) throws Exception {
        MemorySegmentOutputView outputView = new MemorySegmentOutputView(100);
        MemoryLogRecordsIndexedBuilder builder = MemoryLogRecordsIndexedBuilder.builder((long)baseLogOffset, (int)schemaId, (int)Integer.MAX_VALUE, (byte)0, (MemorySegmentOutputView)outputView);
        for (int i = 0; i < rowKinds.size(); ++i) {
            builder.append(rowKinds.get(i), (InternalRow)rows.get(i));
        }
        builder.setWriterState(writerId, batchSequence);
        MemoryLogRecords memoryLogRecords = builder.build();
        memoryLogRecords.ensureValid();
        ((DefaultLogRecordBatch)memoryLogRecords.batches().iterator().next()).setCommitTimestamp(maxTimestamp);
        return memoryLogRecords;
    }

    /*
     * Exception decompiling
     */
    private static MemoryLogRecords createArrowMemoryLogRecords(RowType rowType, long baseLogOffset, long maxTimestamp, int schemaId, long writerId, int batchSequence, List<RowKind> rowKinds, List<InternalRow> rows) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void assertMemoryRecordsEquals(RowType rowType, LogRecords records, List<List<Object[]>> expected) {
        ArrayList<List<Tuple2<RowKind, Object[]>>> appendOnlyExpectedValue = new ArrayList<List<Tuple2<RowKind, Object[]>>>();
        for (List<Object[]> expectedRecord : expected) {
            List expectedFieldAndRowKind = expectedRecord.stream().map(val -> Tuple2.of((Object)RowKind.APPEND_ONLY, (Object)val)).collect(Collectors.toList());
            appendOnlyExpectedValue.add(expectedFieldAndRowKind);
        }
        DataTestUtils.assertMemoryRecordsEqualsWithRowKind(rowType, records, appendOnlyExpectedValue);
    }

    public static void assertMemoryRecordsEqualsWithRowKind(RowType rowType, LogRecords records, List<List<Tuple2<RowKind, Object[]>>> expected) {
        Iterator iterator = records.batches().iterator();
        for (List<Tuple2<RowKind, Object[]>> expectedRecord : expected) {
            Assertions.assertThat((boolean)iterator.hasNext()).isTrue();
            LogRecordBatch batch = (LogRecordBatch)iterator.next();
            LogRecordReadContext readContext = LogRecordReadContext.createArrowReadContext((RowType)rowType, (int)1);
            Throwable throwable = null;
            try {
                CloseableIterator logIterator = batch.records((LogRecordBatch.ReadContext)readContext);
                Throwable throwable2 = null;
                try {
                    for (Tuple2<RowKind, Object[]> expectedFieldAndRowKind : expectedRecord) {
                        Assertions.assertThat((boolean)logIterator.hasNext()).isTrue();
                        DataTestUtils.assertLogRecordsEqualsWithRowKind(rowType, (LogRecord)logIterator.next(), expectedFieldAndRowKind);
                    }
                    Assertions.assertThat((boolean)logIterator.hasNext()).isFalse();
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (logIterator == null) continue;
                    if (throwable2 != null) {
                        try {
                            logIterator.close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    logIterator.close();
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (readContext == null) continue;
                if (throwable != null) {
                    try {
                        readContext.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    continue;
                }
                readContext.close();
            }
        }
        Assertions.assertThat((boolean)iterator.hasNext()).isFalse();
    }

    public static void assertLogRecordsEquals(LogRecords actual, LogRecords expected) {
        DataTestUtils.assertLogRecordsEquals(TestData.DATA1_ROW_TYPE, actual, expected);
    }

    public static void assertLogRecordsEquals(RowType rowType, LogRecords actual, LogRecords expected) {
        Iterator actualIterator = actual.batches().iterator();
        Iterator expectedIterator = expected.batches().iterator();
        while (actualIterator.hasNext()) {
            Assertions.assertThat((boolean)expectedIterator.hasNext()).isTrue();
            LogRecordBatch actualBatch = (LogRecordBatch)actualIterator.next();
            LogRecordBatch expectedBatch = (LogRecordBatch)expectedIterator.next();
            DataTestUtils.assertLogRecordBatchEquals(rowType, actualBatch, expectedBatch);
        }
        Assertions.assertThat((boolean)expectedIterator.hasNext()).isFalse();
    }

    public static void assertLogRecordBatchEquals(RowType rowType, LogRecordBatch actual, LogRecordBatch expected) {
        LogRecordBatchAssert.assertThatLogRecordBatch(actual).withSchema(rowType).isEqualTo(expected);
    }

    private static void assertLogRecordsEqualsWithRowKind(RowType rowType, LogRecord logRecord, Tuple2<RowKind, Object[]> expectedFieldAndRowKind) {
        DataType[] dataTypes = rowType.getChildren().toArray(new DataType[0]);
        InternalRow.FieldGetter[] fieldGetter = new InternalRow.FieldGetter[dataTypes.length];
        for (int i = 0; i < dataTypes.length; ++i) {
            fieldGetter[i] = InternalRow.createFieldGetter((DataType)dataTypes[i], (int)i);
        }
        Assertions.assertThat((Comparable)logRecord.getRowKind()).isEqualTo(expectedFieldAndRowKind.f0);
        DataTestUtils.assertRowValueEquals(fieldGetter, dataTypes, logRecord.getRow(), (Object[])expectedFieldAndRowKind.f1);
    }

    public static void assertLogRecordsEquals(RowType rowType, LogRecords logRecords, List<Object[]> expectedValue) {
        List<Tuple2<RowKind, Object[]>> expectedValueWithRowKind = expectedValue.stream().map(val -> Tuple2.of((Object)RowKind.APPEND_ONLY, (Object)val)).collect(Collectors.toList());
        DataTestUtils.assertLogRecordsEqualsWithRowKind(rowType, logRecords, expectedValueWithRowKind);
    }

    public static void assertLogRecordsEqualsWithRowKind(RowType rowType, LogRecords logRecords, List<Tuple2<RowKind, Object[]>> expectedValue) {
        int i;
        DataType[] dataTypes = rowType.getChildren().toArray(new DataType[0]);
        InternalRow.FieldGetter[] fieldGetter = new InternalRow.FieldGetter[dataTypes.length];
        for (i = 0; i < dataTypes.length; ++i) {
            fieldGetter[i] = InternalRow.createFieldGetter((DataType)dataTypes[i], (int)i);
        }
        i = 0;
        try (LogRecordReadContext readContext = LogRecordReadContext.createArrowReadContext((RowType)rowType, (int)1);){
            for (LogRecordBatch batch : logRecords.batches()) {
                CloseableIterator iterator = batch.records((LogRecordBatch.ReadContext)readContext);
                Throwable throwable = null;
                try {
                    while (iterator.hasNext()) {
                        LogRecord record = (LogRecord)iterator.next();
                        Tuple2<RowKind, Object[]> expected = expectedValue.get(i++);
                        Assertions.assertThat((Comparable)record.getRowKind()).isEqualTo(expected.f0);
                        DataTestUtils.assertRowValueEquals(fieldGetter, dataTypes, record.getRow(), (Object[])expected.f1);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (iterator == null) continue;
                    if (throwable != null) {
                        try {
                            iterator.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    iterator.close();
                }
            }
            Assertions.assertThat((int)i).isEqualTo(expectedValue.size());
        }
    }

    public static void assertRowValueEquals(RowType rowType, InternalRow row, Object[] expectVal) {
        DataType[] dataTypes = rowType.getChildren().toArray(new DataType[0]);
        InternalRow.FieldGetter[] fieldGetter = new InternalRow.FieldGetter[dataTypes.length];
        for (int i = 0; i < dataTypes.length; ++i) {
            fieldGetter[i] = InternalRow.createFieldGetter((DataType)dataTypes[i], (int)i);
        }
        DataTestUtils.assertRowValueEquals(fieldGetter, dataTypes, row, expectVal);
    }

    private static void assertRowValueEquals(InternalRow.FieldGetter[] fieldGetter, DataType[] dataTypes, InternalRow row, Object[] expectVal) {
        for (int i = 0; i < dataTypes.length; ++i) {
            Object field = fieldGetter[i].getFieldOrNull(row);
            if (field != null) {
                if (dataTypes[i].getTypeRoot() == DataTypeRoot.STRING) {
                    Assertions.assertThat((Object)field).isEqualTo((Object)BinaryString.fromString((String)((String)expectVal[i])));
                    continue;
                }
                Assertions.assertThat((Object)field).isEqualTo(expectVal[i]);
                continue;
            }
            Assertions.assertThat((Object)expectVal[i]).isNull();
        }
    }
}

