/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.testutils;

import com.alibaba.fluss.metadata.LogFormat;
import com.alibaba.fluss.record.LogRecord;
import com.alibaba.fluss.record.LogRecordBatch;
import com.alibaba.fluss.record.LogRecordReadContext;
import com.alibaba.fluss.testutils.LogRecordAssert;
import com.alibaba.fluss.types.RowType;
import com.alibaba.fluss.utils.CloseableIterator;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractByteAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.AbstractShortAssert;
import org.assertj.core.api.Assertions;

public class LogRecordBatchAssert
extends AbstractAssert<LogRecordBatchAssert, LogRecordBatch> {
    private RowType rowType;
    private LogFormat logFormat;

    public static LogRecordBatchAssert assertThatLogRecordBatch(LogRecordBatch actual) {
        return new LogRecordBatchAssert(actual);
    }

    private LogRecordBatchAssert(LogRecordBatch actual) {
        super((Object)actual, LogRecordBatchAssert.class);
    }

    public LogRecordBatchAssert withSchema(RowType rowType) {
        this.rowType = rowType;
        return this;
    }

    public LogRecordBatchAssert withLogFormat(LogFormat logFormat) {
        this.logFormat = logFormat;
        return this;
    }

    public LogRecordBatchAssert isEqualTo(LogRecordBatch expected) {
        if (this.rowType == null) {
            throw new IllegalStateException("LogRecordBatchAssert#isEqualTo(LogRecordBatch) must be invoked after #withSchema(RowType).");
        }
        ((AbstractShortAssert)Assertions.assertThat((short)((LogRecordBatch)this.actual).schemaId()).as("LogRecordBatch#schemaId()", new Object[0])).isEqualTo(expected.schemaId());
        ((AbstractLongAssert)Assertions.assertThat((long)((LogRecordBatch)this.actual).baseLogOffset()).as("LogRecordBatch#baseLogOffset()", new Object[0])).isEqualTo(expected.baseLogOffset());
        ((AbstractLongAssert)Assertions.assertThat((long)((LogRecordBatch)this.actual).lastLogOffset()).as("LogRecordBatch#lastLogOffset()", new Object[0])).isEqualTo(expected.lastLogOffset());
        ((AbstractLongAssert)Assertions.assertThat((long)((LogRecordBatch)this.actual).nextLogOffset()).as("LogRecordBatch#nextLogOffset()", new Object[0])).isEqualTo(expected.nextLogOffset());
        ((AbstractByteAssert)Assertions.assertThat((byte)((LogRecordBatch)this.actual).magic()).as("LogRecordBatch#magic()", new Object[0])).isEqualTo(expected.magic());
        ((AbstractLongAssert)Assertions.assertThat((long)((LogRecordBatch)this.actual).writerId()).as("LogRecordBatch#writerId()", new Object[0])).isEqualTo(expected.writerId());
        ((AbstractIntegerAssert)Assertions.assertThat((int)((LogRecordBatch)this.actual).batchSequence()).as("LogRecordBatch#batchSequence()", new Object[0])).isEqualTo(expected.batchSequence());
        ((AbstractIntegerAssert)Assertions.assertThat((int)((LogRecordBatch)this.actual).getRecordCount()).as("LogRecordBatch#getRecordCount()", new Object[0])).isEqualTo(expected.getRecordCount());
        try (LogRecordReadContext readContext = this.createReadContext(expected.schemaId());
             CloseableIterator actualIter = ((LogRecordBatch)this.actual).records((LogRecordBatch.ReadContext)readContext);
             CloseableIterator expectIter = expected.records((LogRecordBatch.ReadContext)readContext);){
            while (expectIter.hasNext()) {
                Assertions.assertThat((boolean)actualIter.hasNext()).isTrue();
                LogRecordAssert.assertThatLogRecord((LogRecord)actualIter.next()).withSchema(this.rowType).isEqualTo((LogRecord)expectIter.next());
            }
            Assertions.assertThat((boolean)actualIter.hasNext()).isFalse();
        }
        ((AbstractIntegerAssert)Assertions.assertThat((int)((LogRecordBatch)this.actual).sizeInBytes()).as("LogRecordBatch#sizeInBytes()", new Object[0])).isEqualTo(expected.sizeInBytes());
        ((AbstractLongAssert)Assertions.assertThat((long)((LogRecordBatch)this.actual).checksum()).as("LogRecordBatch#checksum()", new Object[0])).isEqualTo(expected.checksum());
        return this;
    }

    private LogRecordReadContext createReadContext(int schemaId) {
        if (this.logFormat != null && this.logFormat == LogFormat.INDEXED) {
            return LogRecordReadContext.createIndexedReadContext((RowType)this.rowType, (int)schemaId);
        }
        return LogRecordReadContext.createArrowReadContext((RowType)this.rowType, (int)schemaId);
    }
}

