/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.types;

import com.alibaba.fluss.types.CharType;
import com.alibaba.fluss.types.DataField;
import com.alibaba.fluss.types.DataType;
import com.alibaba.fluss.types.IntType;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class DataFieldTest {
    @Test
    void testCreateField() {
        DataField fieldA = new DataField("a", (DataType)new CharType(5));
        Assertions.assertThat((String)fieldA.getName()).isEqualTo("a");
        Assertions.assertThat((Object)fieldA.getType()).isInstanceOf(CharType.class);
        Assertions.assertThat((Optional)fieldA.getDescription()).isEmpty();
        Assertions.assertThat((String)fieldA.asSerializableString()).isEqualTo("`a` CHAR(5)");
        Assertions.assertThat((String)fieldA.asSummaryString()).isEqualTo("`a` CHAR(5)");
        DataField fieldB = new DataField("b", (DataType)new IntType(), "column b");
        Assertions.assertThat((String)fieldB.getName()).isEqualTo("b");
        Assertions.assertThat((Object)fieldB.getType()).isInstanceOf(IntType.class);
        Assertions.assertThat((String)fieldB.getDescription().orElse("")).isEqualTo("column b");
        Assertions.assertThat((String)fieldB.asSerializableString()).isEqualTo("`b` INT 'column b'");
        Assertions.assertThat((String)fieldB.asSummaryString()).isEqualTo("`b` INT '...'");
    }
}

