/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.types;

import com.alibaba.fluss.types.BigIntType;
import com.alibaba.fluss.types.BinaryType;
import com.alibaba.fluss.types.CharType;
import com.alibaba.fluss.types.DataField;
import com.alibaba.fluss.types.DataType;
import com.alibaba.fluss.types.DataTypeChecks;
import com.alibaba.fluss.types.DataTypes;
import com.alibaba.fluss.types.DecimalType;
import com.alibaba.fluss.types.IntType;
import com.alibaba.fluss.types.LocalZonedTimestampType;
import com.alibaba.fluss.types.SmallIntType;
import com.alibaba.fluss.types.TimeType;
import com.alibaba.fluss.types.TimestampType;
import com.alibaba.fluss.types.TinyIntType;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class DataTypeChecksTest {
    @Test
    void testDataTypeVisitorForLengthExtract() {
        Assertions.assertThat((int)DataTypeChecks.getLength((DataType)new CharType(1))).isEqualTo(1);
        Assertions.assertThat((int)DataTypeChecks.getLength((DataType)new BinaryType(10))).isEqualTo(10);
        List<DataType> noLengthTypes = Arrays.asList(DataTypes.STRING(), DataTypes.BOOLEAN(), DataTypes.BYTES(), DataTypes.DECIMAL((int)2, (int)1), DataTypes.TINYINT(), DataTypes.SMALLINT(), DataTypes.INT(), DataTypes.BIGINT(), DataTypes.FLOAT(), DataTypes.DOUBLE(), DataTypes.DATE(), DataTypes.TIME(), DataTypes.TIMESTAMP(), DataTypes.TIMESTAMP_LTZ(), DataTypes.ARRAY((DataType)DataTypes.INT()), DataTypes.MAP((DataType)DataTypes.INT(), (DataType)DataTypes.INT()), DataTypes.ROW((DataField[])new DataField[]{DataTypes.FIELD((String)"a", (DataType)DataTypes.INT())}));
        for (DataType noLengthType : noLengthTypes) {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> DataTypeChecks.getLength((DataType)noLengthType)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Invalid use of extractor LengthExtractor");
        }
    }

    @Test
    void testDataTypeVisitorForPrecisionExtract() {
        Assertions.assertThat((int)DataTypeChecks.getPrecision((DataType)new DecimalType(5, 2))).isEqualTo(5);
        Assertions.assertThat((int)DataTypeChecks.getPrecision((DataType)new TimeType(5))).isEqualTo(5);
        Assertions.assertThat((int)DataTypeChecks.getPrecision((DataType)new TimestampType(5))).isEqualTo(5);
        Assertions.assertThat((int)DataTypeChecks.getPrecision((DataType)new LocalZonedTimestampType(9))).isEqualTo(9);
        List<DataType> noPrecisionTypes = Arrays.asList(DataTypes.CHAR((int)5), DataTypes.STRING(), DataTypes.BOOLEAN(), DataTypes.BINARY((int)5), DataTypes.BYTES(), DataTypes.TINYINT(), DataTypes.SMALLINT(), DataTypes.INT(), DataTypes.BIGINT(), DataTypes.FLOAT(), DataTypes.DOUBLE(), DataTypes.DATE(), DataTypes.ARRAY((DataType)DataTypes.INT()), DataTypes.MAP((DataType)DataTypes.INT(), (DataType)DataTypes.INT()), DataTypes.ROW((DataField[])new DataField[]{DataTypes.FIELD((String)"a", (DataType)DataTypes.INT())}));
        for (DataType noPrecisionType : noPrecisionTypes) {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> DataTypeChecks.getPrecision((DataType)noPrecisionType)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Invalid use of extractor PrecisionExtractor");
        }
    }

    @Test
    void testDataTypeVisitorForScaleExtract() {
        Assertions.assertThat((int)DataTypeChecks.getScale((DataType)new DecimalType(5, 1))).isEqualTo(1);
        Assertions.assertThat((int)DataTypeChecks.getScale((DataType)new TinyIntType())).isEqualTo(0);
        Assertions.assertThat((int)DataTypeChecks.getScale((DataType)new SmallIntType())).isEqualTo(0);
        Assertions.assertThat((int)DataTypeChecks.getScale((DataType)new IntType())).isEqualTo(0);
        Assertions.assertThat((int)DataTypeChecks.getScale((DataType)new BigIntType())).isEqualTo(0);
        List<DataType> noScaleTypes = Arrays.asList(DataTypes.STRING(), DataTypes.BOOLEAN(), DataTypes.BYTES(), DataTypes.FLOAT(), DataTypes.DOUBLE(), DataTypes.DATE(), DataTypes.TIME(), DataTypes.TIMESTAMP(), DataTypes.TIMESTAMP_LTZ(), DataTypes.ARRAY((DataType)DataTypes.INT()), DataTypes.MAP((DataType)DataTypes.INT(), (DataType)DataTypes.INT()), DataTypes.ROW((DataField[])new DataField[]{DataTypes.FIELD((String)"a", (DataType)DataTypes.INT())}));
        for (DataType noScaleType : noScaleTypes) {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> DataTypeChecks.getScale((DataType)noScaleType)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Invalid use of extractor ScaleExtractor");
        }
    }
}

