/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.types;

import com.alibaba.fluss.types.ArrayType;
import com.alibaba.fluss.types.BigIntType;
import com.alibaba.fluss.types.BinaryType;
import com.alibaba.fluss.types.BooleanType;
import com.alibaba.fluss.types.BytesType;
import com.alibaba.fluss.types.CharType;
import com.alibaba.fluss.types.DataField;
import com.alibaba.fluss.types.DataType;
import com.alibaba.fluss.types.DataTypeFamily;
import com.alibaba.fluss.types.DataTypeRoot;
import com.alibaba.fluss.types.DataTypes;
import com.alibaba.fluss.types.DateType;
import com.alibaba.fluss.types.DecimalType;
import com.alibaba.fluss.types.DoubleType;
import com.alibaba.fluss.types.FloatType;
import com.alibaba.fluss.types.IntType;
import com.alibaba.fluss.types.LocalZonedTimestampType;
import com.alibaba.fluss.types.MapType;
import com.alibaba.fluss.types.RowType;
import com.alibaba.fluss.types.SmallIntType;
import com.alibaba.fluss.types.StringType;
import com.alibaba.fluss.types.TimeType;
import com.alibaba.fluss.types.TimestampType;
import com.alibaba.fluss.types.TinyIntType;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class DataTypesTest {
    @Test
    void testTypeRoot() {
        CharType charType = new CharType();
        Assertions.assertThat((boolean)charType.is(DataTypeRoot.CHAR)).isTrue();
        Assertions.assertThat((boolean)charType.is(DataTypeRoot.BOOLEAN)).isFalse();
        Assertions.assertThat((boolean)charType.isAnyOf(new DataTypeRoot[]{DataTypeRoot.CHAR})).isTrue();
        Assertions.assertThat((boolean)charType.isAnyOf(new DataTypeRoot[]{DataTypeRoot.BOOLEAN})).isFalse();
        Assertions.assertThat((boolean)charType.is(DataTypeFamily.PREDEFINED)).isTrue();
        Assertions.assertThat((boolean)charType.is(DataTypeFamily.EXACT_NUMERIC)).isFalse();
        Assertions.assertThat((boolean)charType.isAnyOf(new DataTypeFamily[]{DataTypeFamily.PREDEFINED})).isTrue();
        Assertions.assertThat((boolean)charType.isAnyOf(new DataTypeFamily[]{DataTypeFamily.EXACT_NUMERIC})).isFalse();
    }

    @Test
    void testCharType() {
        CharType charType = new CharType();
        Assertions.assertThat((int)charType.getLength()).isEqualTo(1);
        DataTypesTest.dataTypeBaseAssert((DataType)charType, true, "CHAR(1)", (DataType)new CharType(55));
        charType = new CharType(44);
        Assertions.assertThat((int)charType.getLength()).isEqualTo(44);
        DataTypesTest.dataTypeBaseAssert((DataType)charType, true, "CHAR(44)", (DataType)new CharType(55));
        charType = new CharType(false, 55);
        Assertions.assertThat((int)charType.getLength()).isEqualTo(55);
        DataTypesTest.dataTypeBaseAssert((DataType)charType, false, "CHAR(55) NOT NULL", (DataType)new CharType(1));
        charType = DataTypes.CHAR((int)66);
        Assertions.assertThat((int)charType.getLength()).isEqualTo(66);
        DataTypesTest.dataTypeBaseAssert((DataType)charType, true, "CHAR(66)", (DataType)new CharType(1));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new CharType(-1)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Character string length must be between 1 and 2147483647 (both inclusive)");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new CharType(0)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Character string length must be between 1 and 2147483647 (both inclusive)");
        Assertions.assertThat((int)charType.getChildren().size()).isEqualTo(0);
        Assertions.assertThat((Collection)charType.getTypeRoot().getFamilies()).containsExactlyInAnyOrder((Object[])new DataTypeFamily[]{DataTypeFamily.PREDEFINED, DataTypeFamily.CHARACTER_STRING});
    }

    @Test
    void testStringType() {
        StringType stringType = new StringType();
        DataTypesTest.dataTypeBaseAssert((DataType)stringType, true, "STRING", (DataType)new StringType(false));
        stringType = new StringType(false);
        DataTypesTest.dataTypeBaseAssert((DataType)stringType, false, "STRING NOT NULL", (DataType)new StringType(true));
        stringType = DataTypes.STRING();
        DataTypesTest.dataTypeBaseAssert((DataType)stringType, true, "STRING", (DataType)new StringType(false));
        Assertions.assertThat((int)stringType.getChildren().size()).isEqualTo(0);
        Assertions.assertThat((Collection)stringType.getTypeRoot().getFamilies()).containsExactlyInAnyOrder((Object[])new DataTypeFamily[]{DataTypeFamily.PREDEFINED, DataTypeFamily.CHARACTER_STRING});
    }

    @Test
    void testBooleanType() {
        BooleanType booleanType = new BooleanType();
        DataTypesTest.dataTypeBaseAssert((DataType)booleanType, true, "BOOLEAN", (DataType)new BooleanType(false));
        booleanType = new BooleanType(false);
        DataTypesTest.dataTypeBaseAssert((DataType)booleanType, false, "BOOLEAN NOT NULL", (DataType)new BooleanType(true));
        booleanType = DataTypes.BOOLEAN();
        DataTypesTest.dataTypeBaseAssert((DataType)booleanType, true, "BOOLEAN", (DataType)new BooleanType(false));
        Assertions.assertThat((int)booleanType.getChildren().size()).isEqualTo(0);
        Assertions.assertThat((Collection)booleanType.getTypeRoot().getFamilies()).containsExactlyInAnyOrder((Object[])new DataTypeFamily[]{DataTypeFamily.PREDEFINED});
    }

    @Test
    void testBinaryType() {
        BinaryType binaryType = new BinaryType();
        Assertions.assertThat((int)binaryType.getLength()).isEqualTo(1);
        DataTypesTest.dataTypeBaseAssert((DataType)binaryType, true, "BINARY(1)", (DataType)new BinaryType(55));
        binaryType = new BinaryType(33);
        Assertions.assertThat((int)binaryType.getLength()).isEqualTo(33);
        DataTypesTest.dataTypeBaseAssert((DataType)binaryType, true, "BINARY(33)", (DataType)new BinaryType(55));
        binaryType = new BinaryType(false, 44);
        Assertions.assertThat((int)binaryType.getLength()).isEqualTo(44);
        DataTypesTest.dataTypeBaseAssert((DataType)binaryType, false, "BINARY(44) NOT NULL", (DataType)new BinaryType(55));
        binaryType = DataTypes.BINARY((int)55);
        Assertions.assertThat((int)binaryType.getLength()).isEqualTo(55);
        DataTypesTest.dataTypeBaseAssert((DataType)binaryType, true, "BINARY(55)", (DataType)new BinaryType(1));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new BinaryType(-1)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Binary string length must be between 1 and 2147483647 (both inclusive)");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new BinaryType(0)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Binary string length must be between 1 and 2147483647 (both inclusive)");
        Assertions.assertThat((int)binaryType.getChildren().size()).isEqualTo(0);
        Assertions.assertThat((Collection)binaryType.getTypeRoot().getFamilies()).containsExactlyInAnyOrder((Object[])new DataTypeFamily[]{DataTypeFamily.PREDEFINED, DataTypeFamily.BINARY_STRING});
    }

    @Test
    void testBytesType() {
        BytesType bytesType = new BytesType();
        DataTypesTest.dataTypeBaseAssert((DataType)bytesType, true, "BYTES", (DataType)new BytesType(false));
        bytesType = new BytesType(false);
        DataTypesTest.dataTypeBaseAssert((DataType)bytesType, false, "BYTES NOT NULL", (DataType)new BytesType(true));
        bytesType = DataTypes.BYTES();
        DataTypesTest.dataTypeBaseAssert((DataType)bytesType, true, "BYTES", (DataType)new BytesType(false));
        Assertions.assertThat((int)bytesType.getChildren().size()).isEqualTo(0);
        Assertions.assertThat((Collection)bytesType.getTypeRoot().getFamilies()).containsExactlyInAnyOrder((Object[])new DataTypeFamily[]{DataTypeFamily.PREDEFINED, DataTypeFamily.BINARY_STRING});
    }

    @Test
    void testDecimalType() {
        DecimalType decimalType = new DecimalType();
        Assertions.assertThat((int)decimalType.getPrecision()).isEqualTo(10);
        Assertions.assertThat((int)decimalType.getScale()).isEqualTo(0);
        DataTypesTest.dataTypeBaseAssert((DataType)decimalType, true, "DECIMAL(10, 0)", (DataType)new DecimalType(10, 10));
        decimalType = new DecimalType(5);
        Assertions.assertThat((int)decimalType.getPrecision()).isEqualTo(5);
        Assertions.assertThat((int)decimalType.getScale()).isEqualTo(0);
        DataTypesTest.dataTypeBaseAssert((DataType)decimalType, true, "DECIMAL(5, 0)", (DataType)new DecimalType(10, 10));
        decimalType = new DecimalType(5, 5);
        Assertions.assertThat((int)decimalType.getPrecision()).isEqualTo(5);
        Assertions.assertThat((int)decimalType.getScale()).isEqualTo(5);
        DataTypesTest.dataTypeBaseAssert((DataType)decimalType, true, "DECIMAL(5, 5)", (DataType)new DecimalType(10, 10));
        decimalType = new DecimalType(false, 5, 5);
        Assertions.assertThat((int)decimalType.getPrecision()).isEqualTo(5);
        Assertions.assertThat((int)decimalType.getScale()).isEqualTo(5);
        DataTypesTest.dataTypeBaseAssert((DataType)decimalType, false, "DECIMAL(5, 5) NOT NULL", (DataType)new DecimalType(10, 10));
        decimalType = DataTypes.DECIMAL((int)5, (int)5);
        Assertions.assertThat((int)decimalType.getPrecision()).isEqualTo(5);
        Assertions.assertThat((int)decimalType.getScale()).isEqualTo(5);
        DataTypesTest.dataTypeBaseAssert((DataType)decimalType, true, "DECIMAL(5, 5)", (DataType)new DecimalType(10, 10));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new DecimalType(0)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Decimal precision must be between 1 and 38 (both inclusive)");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new DecimalType(40)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Decimal precision must be between 1 and 38 (both inclusive)");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new DecimalType(1, 5)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Decimal scale must be between 0 and the precision 1 (both inclusive)");
        Assertions.assertThat((int)decimalType.getChildren().size()).isEqualTo(0);
        Assertions.assertThat((Collection)decimalType.getTypeRoot().getFamilies()).containsExactlyInAnyOrder((Object[])new DataTypeFamily[]{DataTypeFamily.PREDEFINED, DataTypeFamily.NUMERIC, DataTypeFamily.EXACT_NUMERIC});
    }

    @Test
    void testTinyIntType() {
        TinyIntType tinyIntType = new TinyIntType();
        DataTypesTest.dataTypeBaseAssert((DataType)tinyIntType, true, "TINYINT", (DataType)new TinyIntType(false));
        tinyIntType = new TinyIntType(false);
        DataTypesTest.dataTypeBaseAssert((DataType)tinyIntType, false, "TINYINT NOT NULL", (DataType)new TinyIntType());
        tinyIntType = DataTypes.TINYINT();
        DataTypesTest.dataTypeBaseAssert((DataType)tinyIntType, true, "TINYINT", (DataType)new TinyIntType(false));
        Assertions.assertThat((int)tinyIntType.getChildren().size()).isEqualTo(0);
        Assertions.assertThat((Collection)tinyIntType.getTypeRoot().getFamilies()).containsExactlyInAnyOrder((Object[])new DataTypeFamily[]{DataTypeFamily.PREDEFINED, DataTypeFamily.NUMERIC, DataTypeFamily.INTEGER_NUMERIC, DataTypeFamily.EXACT_NUMERIC});
    }

    @Test
    void testSmallIntType() {
        SmallIntType smallIntType = new SmallIntType();
        DataTypesTest.dataTypeBaseAssert((DataType)smallIntType, true, "SMALLINT", (DataType)new SmallIntType(false));
        smallIntType = new SmallIntType(false);
        DataTypesTest.dataTypeBaseAssert((DataType)smallIntType, false, "SMALLINT NOT NULL", (DataType)new SmallIntType());
        smallIntType = DataTypes.SMALLINT();
        DataTypesTest.dataTypeBaseAssert((DataType)smallIntType, true, "SMALLINT", (DataType)new SmallIntType(false));
        Assertions.assertThat((int)smallIntType.getChildren().size()).isEqualTo(0);
        Assertions.assertThat((Collection)smallIntType.getTypeRoot().getFamilies()).containsExactlyInAnyOrder((Object[])new DataTypeFamily[]{DataTypeFamily.PREDEFINED, DataTypeFamily.NUMERIC, DataTypeFamily.INTEGER_NUMERIC, DataTypeFamily.EXACT_NUMERIC});
    }

    @Test
    void testIntType() {
        IntType intType = new IntType();
        DataTypesTest.dataTypeBaseAssert((DataType)intType, true, "INT", (DataType)new IntType(false));
        intType = new IntType(false);
        DataTypesTest.dataTypeBaseAssert((DataType)intType, false, "INT NOT NULL", (DataType)new IntType());
        intType = DataTypes.INT();
        DataTypesTest.dataTypeBaseAssert((DataType)intType, true, "INT", (DataType)new IntType(false));
        Assertions.assertThat((int)intType.getChildren().size()).isEqualTo(0);
        Assertions.assertThat((Collection)intType.getTypeRoot().getFamilies()).containsExactlyInAnyOrder((Object[])new DataTypeFamily[]{DataTypeFamily.PREDEFINED, DataTypeFamily.NUMERIC, DataTypeFamily.INTEGER_NUMERIC, DataTypeFamily.EXACT_NUMERIC});
    }

    @Test
    void testBigIntType() {
        BigIntType bigIntType = new BigIntType();
        DataTypesTest.dataTypeBaseAssert((DataType)bigIntType, true, "BIGINT", (DataType)new IntType(false));
        bigIntType = new BigIntType(false);
        DataTypesTest.dataTypeBaseAssert((DataType)bigIntType, false, "BIGINT NOT NULL", (DataType)new IntType());
        bigIntType = DataTypes.BIGINT();
        DataTypesTest.dataTypeBaseAssert((DataType)bigIntType, true, "BIGINT", (DataType)new IntType(false));
        Assertions.assertThat((int)bigIntType.getChildren().size()).isEqualTo(0);
        Assertions.assertThat((Collection)bigIntType.getTypeRoot().getFamilies()).containsExactlyInAnyOrder((Object[])new DataTypeFamily[]{DataTypeFamily.PREDEFINED, DataTypeFamily.NUMERIC, DataTypeFamily.INTEGER_NUMERIC, DataTypeFamily.EXACT_NUMERIC});
    }

    @Test
    void testFloatType() {
        FloatType floatType = new FloatType();
        DataTypesTest.dataTypeBaseAssert((DataType)floatType, true, "FLOAT", (DataType)new FloatType(false));
        floatType = new FloatType(false);
        DataTypesTest.dataTypeBaseAssert((DataType)floatType, false, "FLOAT NOT NULL", (DataType)new FloatType());
        floatType = DataTypes.FLOAT();
        DataTypesTest.dataTypeBaseAssert((DataType)floatType, true, "FLOAT", (DataType)new FloatType(false));
        Assertions.assertThat((int)floatType.getChildren().size()).isEqualTo(0);
        Assertions.assertThat((Collection)floatType.getTypeRoot().getFamilies()).containsExactlyInAnyOrder((Object[])new DataTypeFamily[]{DataTypeFamily.PREDEFINED, DataTypeFamily.NUMERIC, DataTypeFamily.APPROXIMATE_NUMERIC});
    }

    @Test
    void testDoubleType() {
        DoubleType doubleType = new DoubleType();
        DataTypesTest.dataTypeBaseAssert((DataType)doubleType, true, "DOUBLE", (DataType)new DoubleType(false));
        doubleType = new DoubleType(false);
        DataTypesTest.dataTypeBaseAssert((DataType)doubleType, false, "DOUBLE NOT NULL", (DataType)new DoubleType());
        doubleType = DataTypes.DOUBLE();
        DataTypesTest.dataTypeBaseAssert((DataType)doubleType, true, "DOUBLE", (DataType)new DoubleType(false));
        Assertions.assertThat((int)doubleType.getChildren().size()).isEqualTo(0);
        Assertions.assertThat((Collection)doubleType.getTypeRoot().getFamilies()).containsExactlyInAnyOrder((Object[])new DataTypeFamily[]{DataTypeFamily.PREDEFINED, DataTypeFamily.NUMERIC, DataTypeFamily.APPROXIMATE_NUMERIC});
    }

    @Test
    void testDateType() {
        DateType dateType = new DateType();
        DataTypesTest.dataTypeBaseAssert((DataType)dateType, true, "DATE", (DataType)new DateType(false));
        dateType = new DateType(false);
        DataTypesTest.dataTypeBaseAssert((DataType)dateType, false, "DATE NOT NULL", (DataType)new DateType());
        dateType = DataTypes.DATE();
        DataTypesTest.dataTypeBaseAssert((DataType)dateType, true, "DATE", (DataType)new DateType(false));
        Assertions.assertThat((int)dateType.getChildren().size()).isEqualTo(0);
        Assertions.assertThat((Collection)dateType.getTypeRoot().getFamilies()).containsExactlyInAnyOrder((Object[])new DataTypeFamily[]{DataTypeFamily.PREDEFINED, DataTypeFamily.DATETIME});
    }

    @Test
    void testTimeType() {
        TimeType timeType = new TimeType();
        Assertions.assertThat((int)timeType.getPrecision()).isEqualTo(0);
        DataTypesTest.dataTypeBaseAssert((DataType)timeType, true, "TIME(0)", (DataType)new TimeType(5));
        timeType = new TimeType(1);
        Assertions.assertThat((int)timeType.getPrecision()).isEqualTo(1);
        DataTypesTest.dataTypeBaseAssert((DataType)timeType, true, "TIME(1)", (DataType)new TimeType(5));
        timeType = new TimeType(false, 2);
        Assertions.assertThat((int)timeType.getPrecision()).isEqualTo(2);
        DataTypesTest.dataTypeBaseAssert((DataType)timeType, false, "TIME(2) NOT NULL", (DataType)new TimeType(5));
        timeType = DataTypes.TIME();
        Assertions.assertThat((int)timeType.getPrecision()).isEqualTo(0);
        DataTypesTest.dataTypeBaseAssert((DataType)timeType, true, "TIME(0)", (DataType)new TimeType(5));
        timeType = DataTypes.TIME((int)1);
        Assertions.assertThat((int)timeType.getPrecision()).isEqualTo(1);
        DataTypesTest.dataTypeBaseAssert((DataType)timeType, true, "TIME(1)", (DataType)new TimeType(5));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new TimeType(-1)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Time precision must be between 0 and 9 (both inclusive)");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new TimeType(15)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Time precision must be between 0 and 9 (both inclusive)");
        Assertions.assertThat((int)timeType.getChildren().size()).isEqualTo(0);
        Assertions.assertThat((Collection)timeType.getTypeRoot().getFamilies()).containsExactlyInAnyOrder((Object[])new DataTypeFamily[]{DataTypeFamily.PREDEFINED, DataTypeFamily.DATETIME, DataTypeFamily.TIME});
    }

    @Test
    void testTimestampType() {
        TimestampType timestampType = new TimestampType();
        Assertions.assertThat((int)timestampType.getPrecision()).isEqualTo(6);
        DataTypesTest.dataTypeBaseAssert((DataType)timestampType, true, "TIMESTAMP(6)", (DataType)new TimestampType(1));
        timestampType = new TimestampType(3);
        Assertions.assertThat((int)timestampType.getPrecision()).isEqualTo(3);
        DataTypesTest.dataTypeBaseAssert((DataType)timestampType, true, "TIMESTAMP(3)", (DataType)new TimestampType(1));
        timestampType = new TimestampType(false, 4);
        Assertions.assertThat((int)timestampType.getPrecision()).isEqualTo(4);
        DataTypesTest.dataTypeBaseAssert((DataType)timestampType, false, "TIMESTAMP(4) NOT NULL", (DataType)new TimestampType(1));
        timestampType = DataTypes.TIMESTAMP();
        Assertions.assertThat((int)timestampType.getPrecision()).isEqualTo(6);
        DataTypesTest.dataTypeBaseAssert((DataType)timestampType, true, "TIMESTAMP(6)", (DataType)new TimestampType(1));
        timestampType = DataTypes.TIMESTAMP((int)3);
        Assertions.assertThat((int)timestampType.getPrecision()).isEqualTo(3);
        DataTypesTest.dataTypeBaseAssert((DataType)timestampType, true, "TIMESTAMP(3)", (DataType)new TimestampType(1));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new TimestampType(-1)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Timestamp precision must be between 0 and 9 (both inclusive)");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new TimestampType(15)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Timestamp precision must be between 0 and 9 (both inclusive)");
        Assertions.assertThat((int)timestampType.getChildren().size()).isEqualTo(0);
        Assertions.assertThat((Collection)timestampType.getTypeRoot().getFamilies()).containsExactlyInAnyOrder((Object[])new DataTypeFamily[]{DataTypeFamily.PREDEFINED, DataTypeFamily.DATETIME, DataTypeFamily.TIMESTAMP});
    }

    @Test
    void testLocalZonedTimestampType() {
        LocalZonedTimestampType localZonedTimestampType = new LocalZonedTimestampType();
        Assertions.assertThat((int)localZonedTimestampType.getPrecision()).isEqualTo(6);
        DataTypesTest.dataTypeBaseAssert((DataType)localZonedTimestampType, true, "TIMESTAMP(6) WITH LOCAL TIME ZONE", (DataType)new LocalZonedTimestampType(1));
        localZonedTimestampType = new LocalZonedTimestampType(3);
        Assertions.assertThat((int)localZonedTimestampType.getPrecision()).isEqualTo(3);
        DataTypesTest.dataTypeBaseAssert((DataType)localZonedTimestampType, true, "TIMESTAMP(3) WITH LOCAL TIME ZONE", (DataType)new LocalZonedTimestampType(1));
        localZonedTimestampType = new LocalZonedTimestampType(false, 4);
        Assertions.assertThat((int)localZonedTimestampType.getPrecision()).isEqualTo(4);
        DataTypesTest.dataTypeBaseAssert((DataType)localZonedTimestampType, false, "TIMESTAMP(4) WITH LOCAL TIME ZONE NOT NULL", (DataType)new LocalZonedTimestampType(1));
        localZonedTimestampType = DataTypes.TIMESTAMP_LTZ();
        Assertions.assertThat((int)localZonedTimestampType.getPrecision()).isEqualTo(6);
        DataTypesTest.dataTypeBaseAssert((DataType)localZonedTimestampType, true, "TIMESTAMP(6) WITH LOCAL TIME ZONE", (DataType)new LocalZonedTimestampType(1));
        localZonedTimestampType = DataTypes.TIMESTAMP_LTZ((int)3);
        Assertions.assertThat((int)localZonedTimestampType.getPrecision()).isEqualTo(3);
        DataTypesTest.dataTypeBaseAssert((DataType)localZonedTimestampType, true, "TIMESTAMP(3) WITH LOCAL TIME ZONE", (DataType)new LocalZonedTimestampType(1));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new LocalZonedTimestampType(-1)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Timestamp with local time zone precision must be between 0 and 9 (both inclusive)");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new LocalZonedTimestampType(15)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Timestamp with local time zone precision must be between 0 and 9 (both inclusive)");
        Assertions.assertThat((int)localZonedTimestampType.getChildren().size()).isEqualTo(0);
        Assertions.assertThat((Collection)localZonedTimestampType.getTypeRoot().getFamilies()).containsExactlyInAnyOrder((Object[])new DataTypeFamily[]{DataTypeFamily.PREDEFINED, DataTypeFamily.DATETIME, DataTypeFamily.TIMESTAMP, DataTypeFamily.EXTENSION});
    }

    @Test
    void testArrayType() {
        ArrayType arrayType = new ArrayType((DataType)new CharType(5));
        DataTypesTest.dataTypeBaseAssert(arrayType.getElementType(), true, "CHAR(5)", (DataType)new CharType(1));
        DataTypesTest.dataTypeBaseAssert((DataType)arrayType, true, "ARRAY<CHAR(5)>", (DataType)new ArrayType((DataType)new CharType(1)));
        arrayType = new ArrayType(false, (DataType)new CharType(5));
        DataTypesTest.dataTypeBaseAssert(arrayType.getElementType(), true, "CHAR(5)", (DataType)new CharType(1));
        DataTypesTest.dataTypeBaseAssert((DataType)arrayType, false, "ARRAY<CHAR(5)> NOT NULL", (DataType)new ArrayType((DataType)new CharType(1)));
        arrayType = new ArrayType((DataType)new ArrayType((DataType)new CharType(5)));
        DataTypesTest.dataTypeBaseAssert((DataType)arrayType, true, "ARRAY<ARRAY<CHAR(5)>>", (DataType)new ArrayType((DataType)new ArrayType((DataType)new CharType(1))));
        arrayType = DataTypes.ARRAY((DataType)new CharType(5));
        DataTypesTest.dataTypeBaseAssert((DataType)arrayType, true, "ARRAY<CHAR(5)>", (DataType)new ArrayType((DataType)new CharType(1)));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new ArrayType(null)).isInstanceOf(NullPointerException.class)).hasMessageContaining("Element type must not be null");
        Assertions.assertThat((int)arrayType.getChildren().size()).isEqualTo(1);
        Assertions.assertThat(arrayType.getChildren().get(0)).isEqualTo((Object)new CharType(5));
        Assertions.assertThat((Collection)arrayType.getTypeRoot().getFamilies()).containsExactlyInAnyOrder((Object[])new DataTypeFamily[]{DataTypeFamily.CONSTRUCTED, DataTypeFamily.COLLECTION});
    }

    @Test
    void testMapType() {
        MapType mapType = new MapType((DataType)new IntType(), (DataType)new CharType(5));
        DataTypesTest.dataTypeBaseAssert(mapType.getKeyType(), true, "INT", (DataType)new IntType(false));
        DataTypesTest.dataTypeBaseAssert(mapType.getValueType(), true, "CHAR(5)", (DataType)new CharType(1));
        DataTypesTest.dataTypeBaseAssert((DataType)mapType, true, "MAP<INT, CHAR(5)>", (DataType)new MapType((DataType)new IntType(), (DataType)new CharType(1)));
        mapType = DataTypes.MAP((DataType)new IntType(), (DataType)new CharType(5));
        DataTypesTest.dataTypeBaseAssert((DataType)mapType, true, "MAP<INT, CHAR(5)>", (DataType)new MapType((DataType)new IntType(), (DataType)new CharType(1)));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new MapType(null, (DataType)new CharType(5))).isInstanceOf(NullPointerException.class)).hasMessageContaining("Key type must not be null");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new MapType((DataType)new IntType(), null)).isInstanceOf(NullPointerException.class)).hasMessageContaining("Value type must not be null");
        Assertions.assertThat((int)mapType.getChildren().size()).isEqualTo(2);
        Assertions.assertThat((List)mapType.getChildren()).containsExactly((Object[])new DataType[]{new IntType(), new CharType(5)});
        Assertions.assertThat((Collection)mapType.getTypeRoot().getFamilies()).containsExactlyInAnyOrder((Object[])new DataTypeFamily[]{DataTypeFamily.CONSTRUCTED, DataTypeFamily.EXTENSION});
    }

    @Test
    void testRowType() {
        RowType rowType = new RowType(Arrays.asList(new DataField("a", (DataType)new IntType(), "column a"), new DataField("b", (DataType)new CharType(5), "column b")));
        Assertions.assertThat((int)rowType.getFieldCount()).isEqualTo(2);
        Assertions.assertThat((int)rowType.getFields().size()).isEqualTo(2);
        Assertions.assertThat((List)rowType.getFields()).containsExactlyInAnyOrder((Object[])new DataField[]{new DataField("a", (DataType)new IntType(), "column a"), new DataField("b", (DataType)new CharType(5), "column b")});
        Assertions.assertThat((List)rowType.getFieldNames()).containsExactlyInAnyOrder((Object[])new String[]{"a", "b"});
        Assertions.assertThat((Object)rowType.getTypeAt(0)).isInstanceOf(IntType.class);
        Assertions.assertThat((Object)rowType.getTypeAt(1)).isInstanceOf(CharType.class);
        Assertions.assertThat((int)rowType.getFieldIndex("a")).isEqualTo(0);
        DataTypesTest.dataTypeBaseAssert((DataType)rowType, true, "ROW<`a` INT 'column a', `b` CHAR(5) 'column b'>", (DataType)new RowType(Arrays.asList(new DataField("a1", (DataType)new IntType(), "column a1"), new DataField("b", (DataType)new CharType(5), "column b"))));
        rowType = new RowType(false, Arrays.asList(new DataField("a", (DataType)new IntType(), "column a"), new DataField("b", (DataType)new CharType(5), "column b")));
        DataTypesTest.dataTypeBaseAssert((DataType)rowType, false, "ROW<`a` INT 'column a', `b` CHAR(5) 'column b'> NOT NULL", (DataType)new RowType(Arrays.asList(new DataField("a", (DataType)new IntType(), "column a"), new DataField("b", (DataType)new CharType(5), "column b"))));
        rowType = DataTypes.ROW((DataField[])new DataField[]{new DataField("a", (DataType)new IntType(), "column a"), new DataField("b", (DataType)new CharType(5), "column b")});
        DataTypesTest.dataTypeBaseAssert((DataType)rowType, true, "ROW<`a` INT 'column a', `b` CHAR(5) 'column b'>", (DataType)new RowType(Arrays.asList(new DataField("a1", (DataType)new IntType(), "column a1"), new DataField("b", (DataType)new CharType(5), "column b"))));
        rowType = DataTypes.ROW((DataType[])new DataType[]{new IntType(), new CharType(5)});
        DataTypesTest.dataTypeBaseAssert((DataType)rowType, true, "ROW<`f0` INT, `f1` CHAR(5)>", (DataType)DataTypes.ROW((DataType[])new DataType[]{new IntType(false), new CharType(5)}));
        rowType = DataTypes.ROW((DataField[])new DataField[]{DataTypes.FIELD((String)"a", (DataType)new IntType(), (String)"column a"), DataTypes.FIELD((String)"b", (DataType)new CharType(5))});
        DataTypesTest.dataTypeBaseAssert((DataType)rowType, true, "ROW<`a` INT 'column a', `b` CHAR(5)>", (DataType)new RowType(Arrays.asList(new DataField("a1", (DataType)new IntType(), "column a1"), new DataField("b", (DataType)new CharType(5)))));
        rowType = RowType.of((DataType[])new DataType[]{DataTypes.CHAR((int)1), DataTypes.CHAR((int)2)});
        DataTypesTest.dataTypeBaseAssert((DataType)rowType, true, "ROW<`f0` CHAR(1), `f1` CHAR(2)>", (DataType)RowType.of((DataType[])new DataType[]{DataTypes.CHAR((int)2), DataTypes.CHAR((int)2)}));
        rowType = RowType.of((boolean)false, (DataType[])new DataType[]{DataTypes.CHAR((int)1), DataTypes.CHAR((int)2)});
        DataTypesTest.dataTypeBaseAssert((DataType)rowType, false, "ROW<`f0` CHAR(1), `f1` CHAR(2)> NOT NULL", (DataType)RowType.of((DataType[])new DataType[]{DataTypes.CHAR((int)2), DataTypes.CHAR((int)2)}));
        rowType = RowType.builder().fields(Arrays.asList(DataTypes.CHAR((int)1), DataTypes.CHAR((int)2))).fields(new DataType[]{DataTypes.CHAR((int)3), DataTypes.CHAR((int)4)}, new String[]{"c", "d"}).field("e", (DataType)DataTypes.CHAR((int)5)).build();
        DataTypesTest.dataTypeBaseAssert((DataType)rowType, true, "ROW<`f0` CHAR(1), `f1` CHAR(2), `c` CHAR(3), `d` CHAR(4), `e` CHAR(5)>", (DataType)RowType.of((DataType[])new DataType[]{DataTypes.CHAR((int)2)}));
        rowType = DataTypes.ROW((DataType[])new DataType[]{new IntType(), new CharType(5)});
        Assertions.assertThat((int)rowType.getChildren().size()).isEqualTo(2);
        Assertions.assertThat((List)rowType.getChildren()).containsExactly((Object[])new DataType[]{new IntType(), new CharType(5)});
        Assertions.assertThat((Collection)rowType.getTypeRoot().getFamilies()).containsExactlyInAnyOrder((Object[])new DataTypeFamily[]{DataTypeFamily.CONSTRUCTED});
    }

    private static void dataTypeBaseAssert(DataType dataType, boolean isNullable, String serializableString, DataType otherDataType) {
        Assertions.assertThat((boolean)dataType.isNullable()).isEqualTo(isNullable);
        Assertions.assertThat((String)dataType.asSerializableString()).isEqualTo(serializableString);
        Assertions.assertThat((Object)dataType).isNotEqualTo((Object)otherDataType);
        Assertions.assertThat((Object)dataType.copy()).isEqualTo((Object)dataType);
        Assertions.assertThat((boolean)dataType.copy(true).isNullable()).isTrue();
    }
}

