/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.utils;

import com.alibaba.fluss.shaded.arrow.org.apache.arrow.memory.BufferAllocator;
import com.alibaba.fluss.shaded.arrow.org.apache.arrow.memory.RootAllocator;
import com.alibaba.fluss.shaded.arrow.org.apache.arrow.vector.BigIntVector;
import com.alibaba.fluss.shaded.arrow.org.apache.arrow.vector.BitVector;
import com.alibaba.fluss.shaded.arrow.org.apache.arrow.vector.DateDayVector;
import com.alibaba.fluss.shaded.arrow.org.apache.arrow.vector.FieldVector;
import com.alibaba.fluss.shaded.arrow.org.apache.arrow.vector.Float4Vector;
import com.alibaba.fluss.shaded.arrow.org.apache.arrow.vector.Float8Vector;
import com.alibaba.fluss.shaded.arrow.org.apache.arrow.vector.IntVector;
import com.alibaba.fluss.shaded.arrow.org.apache.arrow.vector.SmallIntVector;
import com.alibaba.fluss.shaded.arrow.org.apache.arrow.vector.TimeSecVector;
import com.alibaba.fluss.shaded.arrow.org.apache.arrow.vector.TimeStampVector;
import com.alibaba.fluss.shaded.arrow.org.apache.arrow.vector.TinyIntVector;
import com.alibaba.fluss.shaded.arrow.org.apache.arrow.vector.VarBinaryVector;
import com.alibaba.fluss.shaded.arrow.org.apache.arrow.vector.VarCharVector;
import com.alibaba.fluss.shaded.arrow.org.apache.arrow.vector.VectorSchemaRoot;
import com.alibaba.fluss.shaded.arrow.org.apache.arrow.vector.VectorUnloader;
import com.alibaba.fluss.shaded.arrow.org.apache.arrow.vector.ipc.WriteChannel;
import com.alibaba.fluss.shaded.arrow.org.apache.arrow.vector.ipc.message.ArrowBlock;
import com.alibaba.fluss.shaded.arrow.org.apache.arrow.vector.ipc.message.ArrowRecordBatch;
import com.alibaba.fluss.shaded.arrow.org.apache.arrow.vector.ipc.message.MessageSerializer;
import com.alibaba.fluss.shaded.arrow.org.apache.arrow.vector.types.pojo.Schema;
import com.alibaba.fluss.shaded.arrow.org.apache.arrow.vector.util.Text;
import com.alibaba.fluss.types.DataField;
import com.alibaba.fluss.types.DataType;
import com.alibaba.fluss.types.DataTypes;
import com.alibaba.fluss.types.RowType;
import com.alibaba.fluss.utils.ArrowUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.channels.Channels;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.RandomUtils;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class ArrowUtilsTest {
    private static final List<DataType> TYPES = Arrays.asList(DataTypes.TINYINT(), DataTypes.SMALLINT(), DataTypes.INT(), DataTypes.BIGINT(), DataTypes.FLOAT(), DataTypes.DOUBLE(), DataTypes.BOOLEAN(), DataTypes.STRING(), DataTypes.BYTES(), DataTypes.DATE(), DataTypes.TIME(), DataTypes.TIMESTAMP());

    ArrowUtilsTest() {
    }

    @Test
    void testEstimateArrowMetadataSizeInBytes() throws IOException {
        RowType rowType = DataTypes.ROW((DataField[])new DataField[]{DataTypes.FIELD((String)"f1", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"f2", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"f3", (DataType)DataTypes.DOUBLE())});
        Schema schema = ArrowUtils.toArrowSchema((RowType)rowType);
        int metadataSize = ArrowUtils.estimateArrowMetadataLength((Schema)schema);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (RootAllocator allocator = new RootAllocator();
             VectorSchemaRoot root = VectorSchemaRoot.create((Schema)schema, (BufferAllocator)allocator);
             WriteChannel writeChannel = new WriteChannel(Channels.newChannel(out));){
            root.allocateNew();
            IntVector f1Vector = (IntVector)root.getVector(0);
            VarCharVector f2Vector = (VarCharVector)root.getVector(1);
            Float8Vector f3Vector = (Float8Vector)root.getVector(2);
            for (int i = 0; i < 10; ++i) {
                f1Vector.setSafe(i, i);
                f2Vector.setSafe(i, new Text("f2_" + i));
                f3Vector.setSafe(i, (double)i + 0.1);
            }
            root.setRowCount(10);
            long bufferSize = ArrowUtils.estimateArrowBodyLength((VectorSchemaRoot)root);
            VectorUnloader unloader = new VectorUnloader(root);
            try (ArrowRecordBatch recordBatch = unloader.getRecordBatch();){
                ArrowBlock block = MessageSerializer.serialize((WriteChannel)writeChannel, (ArrowRecordBatch)recordBatch);
                Assertions.assertThat((int)metadataSize).isEqualTo(block.getMetadataLength());
                Assertions.assertThat((long)bufferSize).isEqualTo(block.getBodyLength());
                Assertions.assertThat((long)((long)metadataSize + bufferSize)).isEqualTo((long)out.toByteArray().length);
            }
        }
    }

    @Test
    void testRandomEstimateArrowMetadataSizeInBytes() throws IOException {
        int fieldCount = RandomUtils.nextInt((int)1, (int)100);
        ArrayList<DataField> fields = new ArrayList<DataField>();
        for (int i = 0; i < fieldCount; ++i) {
            DataType type = TYPES.get(RandomUtils.nextInt((int)0, (int)TYPES.size()));
            fields.add(new DataField("f" + i, type));
        }
        RowType rowType = new RowType(fields);
        Schema schema = ArrowUtils.toArrowSchema((RowType)rowType);
        int metadataSize = ArrowUtils.estimateArrowMetadataLength((Schema)schema);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int rowCount = RandomUtils.nextInt((int)1, (int)1000);
        try (RootAllocator allocator = new RootAllocator();
             VectorSchemaRoot root = VectorSchemaRoot.create((Schema)schema, (BufferAllocator)allocator);
             WriteChannel writeChannel = new WriteChannel(Channels.newChannel(out));){
            root.allocateNew();
            for (int i = 0; i < fieldCount; ++i) {
                FieldVector vector = root.getVector(i);
                ArrowUtilsTest.generateTestingData(vector, ((DataField)fields.get(i)).getType(), rowCount);
            }
            root.setRowCount(rowCount);
            long bufferSize = ArrowUtils.estimateArrowBodyLength((VectorSchemaRoot)root);
            String errorMessage = String.format("rowCount=%d, schema=%s", rowCount, rowType);
            VectorUnloader unloader = new VectorUnloader(root);
            try (ArrowRecordBatch recordBatch = unloader.getRecordBatch();){
                ArrowBlock block = MessageSerializer.serialize((WriteChannel)writeChannel, (ArrowRecordBatch)recordBatch);
                ((AbstractIntegerAssert)Assertions.assertThat((int)metadataSize).as(errorMessage, new Object[0])).isEqualTo(block.getMetadataLength());
                ((AbstractLongAssert)Assertions.assertThat((long)bufferSize).as(errorMessage, new Object[0])).isEqualTo(block.getBodyLength());
                ((AbstractLongAssert)Assertions.assertThat((long)((long)metadataSize + bufferSize)).as(errorMessage, new Object[0])).isEqualTo((long)out.toByteArray().length);
            }
        }
    }

    private static void generateTestingData(FieldVector vector, DataType type, int rowCount) {
        boolean nullable = type.isNullable();
        switch (type.getTypeRoot()) {
            case TINYINT: {
                for (int i = 0; i < rowCount; ++i) {
                    if (nullable && RandomUtils.nextInt((int)0, (int)10) > 0) {
                        ((TinyIntVector)vector).setSafe(i, RandomUtils.nextBytes((int)1)[0]);
                        continue;
                    }
                    vector.setNull(i);
                }
                break;
            }
            case SMALLINT: {
                for (int i = 0; i < rowCount; ++i) {
                    if (nullable && RandomUtils.nextInt((int)0, (int)10) > 0) {
                        ((SmallIntVector)vector).setSafe(i, (short)RandomUtils.nextInt());
                        continue;
                    }
                    vector.setNull(i);
                }
                break;
            }
            case INTEGER: {
                for (int i = 0; i < rowCount; ++i) {
                    if (nullable && RandomUtils.nextInt((int)0, (int)10) > 0) {
                        ((IntVector)vector).setSafe(i, RandomUtils.nextInt());
                        continue;
                    }
                    vector.setNull(i);
                }
                break;
            }
            case BIGINT: {
                for (int i = 0; i < rowCount; ++i) {
                    if (nullable && RandomUtils.nextInt((int)0, (int)10) > 0) {
                        ((BigIntVector)vector).setSafe(i, RandomUtils.nextLong());
                        continue;
                    }
                    vector.setNull(i);
                }
                break;
            }
            case FLOAT: {
                for (int i = 0; i < rowCount; ++i) {
                    if (nullable && RandomUtils.nextInt((int)0, (int)10) > 0) {
                        ((Float4Vector)vector).setSafe(i, RandomUtils.nextFloat());
                        continue;
                    }
                    vector.setNull(i);
                }
                break;
            }
            case DOUBLE: {
                for (int i = 0; i < rowCount; ++i) {
                    if (nullable && RandomUtils.nextInt((int)0, (int)10) > 0) {
                        ((Float8Vector)vector).setSafe(i, RandomUtils.nextDouble());
                        continue;
                    }
                    vector.setNull(i);
                }
                break;
            }
            case BOOLEAN: {
                for (int i = 0; i < rowCount; ++i) {
                    if (nullable && RandomUtils.nextInt((int)0, (int)10) > 0) {
                        ((BitVector)vector).setSafe(i, RandomUtils.nextInt((int)0, (int)2));
                        continue;
                    }
                    vector.setNull(i);
                }
                break;
            }
            case STRING: {
                for (int i = 0; i < rowCount; ++i) {
                    if (nullable && RandomUtils.nextInt((int)0, (int)10) > 0) {
                        ((VarCharVector)vector).setSafe(i, new Text(RandomStringUtils.randomAlphabetic((int)RandomUtils.nextInt((int)0, (int)100))));
                        continue;
                    }
                    vector.setNull(i);
                }
                break;
            }
            case BYTES: {
                for (int i = 0; i < rowCount; ++i) {
                    if (nullable && RandomUtils.nextInt((int)0, (int)10) > 0) {
                        ((VarBinaryVector)vector).setSafe(i, RandomStringUtils.randomAlphabetic((int)RandomUtils.nextInt((int)0, (int)100)).getBytes());
                        continue;
                    }
                    vector.setNull(i);
                }
                break;
            }
            case DATE: {
                for (int i = 0; i < rowCount; ++i) {
                    if (nullable && RandomUtils.nextInt((int)0, (int)10) > 0) {
                        ((DateDayVector)vector).setSafe(i, RandomUtils.nextInt((int)0, (int)10000));
                        continue;
                    }
                    vector.setNull(i);
                }
                break;
            }
            case TIME_WITHOUT_TIME_ZONE: {
                for (int i = 0; i < rowCount; ++i) {
                    if (nullable && RandomUtils.nextInt((int)0, (int)10) > 0) {
                        ((TimeSecVector)vector).setSafe(i, RandomUtils.nextInt((int)0, (int)10000));
                        continue;
                    }
                    vector.setNull(i);
                }
                break;
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                for (int i = 0; i < rowCount; ++i) {
                    if (nullable && RandomUtils.nextInt((int)0, (int)10) > 0) {
                        ((TimeStampVector)vector).setSafe(i, System.currentTimeMillis());
                        continue;
                    }
                    vector.setNull(i);
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }
}

