/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.utils;

import com.alibaba.fluss.config.AutoPartitionTimeUnit;
import com.alibaba.fluss.utils.AutoPartitionUtils;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class AutoPartitionUtilsTest {
    AutoPartitionUtilsTest() {
    }

    @Test
    void testGetPartitionString() {
        LocalDateTime localDateTime = LocalDateTime.of(2024, 11, 11, 11, 11);
        ZoneId zoneId = ZoneId.of("UTC-8");
        ZonedDateTime zonedDateTime = ZonedDateTime.of(localDateTime, zoneId);
        this.testGetPartitionString(zonedDateTime, AutoPartitionTimeUnit.YEAR, new int[]{-1, 0, 1, 2, 3}, new String[]{"2023", "2024", "2025", "2026", "2027"});
        this.testGetPartitionString(zonedDateTime, AutoPartitionTimeUnit.QUARTER, new int[]{-1, 0, 1, 2, 3}, new String[]{"20243", "20244", "20251", "20252", "20253"});
        this.testGetPartitionString(zonedDateTime, AutoPartitionTimeUnit.MONTH, new int[]{-1, 0, 1, 2, 3}, new String[]{"202410", "202411", "202412", "202501", "202502"});
        this.testGetPartitionString(zonedDateTime, AutoPartitionTimeUnit.DAY, new int[]{-1, 0, 1, 2, 3, 20}, new String[]{"20241110", "20241111", "20241112", "20241113", "20241114", "20241201"});
        this.testGetPartitionString(zonedDateTime, AutoPartitionTimeUnit.HOUR, new int[]{-2, -1, 0, 1, 2, 3, 13}, new String[]{"2024111109", "2024111110", "2024111111", "2024111112", "2024111113", "2024111114", "2024111200"});
    }

    void testGetPartitionString(ZonedDateTime zonedDateTime, AutoPartitionTimeUnit autoPartitionTimeUnit, int[] offsets, String[] expected) {
        for (int i = 0; i < offsets.length; ++i) {
            String partitionString = AutoPartitionUtils.getPartitionString((ZonedDateTime)zonedDateTime, (int)offsets[i], (AutoPartitionTimeUnit)autoPartitionTimeUnit);
            Assertions.assertThat((String)partitionString).isEqualTo(expected[i]);
        }
    }
}

