/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.utils;

import com.alibaba.fluss.utils.BytesUtils;
import java.nio.ByteBuffer;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class BytesUtilsTest {
    BytesUtilsTest() {
    }

    @Test
    void toArray() {
        byte[] input = new byte[]{0, 1, 2, 3, 4};
        ByteBuffer buffer = ByteBuffer.wrap(input);
        Assertions.assertThat((byte[])BytesUtils.toArray((ByteBuffer)buffer)).isEqualTo((Object)input);
        Assertions.assertThat((int)buffer.position()).isEqualTo(0);
        Assertions.assertThat((byte[])BytesUtils.toArray((ByteBuffer)buffer, (int)1, (int)2)).isEqualTo((Object)new byte[]{1, 2});
        Assertions.assertThat((int)buffer.position()).isEqualTo(0);
        buffer.position(2);
        Assertions.assertThat((byte[])BytesUtils.toArray((ByteBuffer)buffer)).isEqualTo((Object)new byte[]{2, 3, 4});
        Assertions.assertThat((int)buffer.position()).isEqualTo(2);
    }

    @Test
    void toArrayDirectByteBuffer() {
        byte[] input = new byte[]{0, 1, 2, 3, 4};
        ByteBuffer buffer = ByteBuffer.allocateDirect(5);
        buffer.put(input);
        buffer.rewind();
        Assertions.assertThat((byte[])BytesUtils.toArray((ByteBuffer)buffer)).isEqualTo((Object)input);
        Assertions.assertThat((int)buffer.position()).isEqualTo(0);
        Assertions.assertThat((byte[])BytesUtils.toArray((ByteBuffer)buffer, (int)1, (int)2)).isEqualTo((Object)new byte[]{1, 2});
        Assertions.assertThat((int)buffer.position()).isEqualTo(0);
        buffer.position(2);
        Assertions.assertThat((byte[])BytesUtils.toArray((ByteBuffer)buffer)).isEqualTo((Object)new byte[]{2, 3, 4});
        Assertions.assertThat((int)buffer.position()).isEqualTo(2);
    }
}

