/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.utils;

import com.alibaba.fluss.utils.AbstractAutoCloseableRegistry;
import com.alibaba.fluss.utils.AbstractAutoCloseableRegistryTest;
import com.alibaba.fluss.utils.CloseableRegistry;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Fail;
import org.junit.jupiter.api.Test;

public class CloseableRegistryTest
extends AbstractAutoCloseableRegistryTest<Closeable, Closeable, Object> {
    @Override
    protected void registerCloseable(Closeable closeable) throws IOException {
        this.closeableRegistry.registerCloseable((AutoCloseable)closeable);
    }

    @Override
    protected AbstractAutoCloseableRegistry<Closeable, Closeable, Object, IOException> createRegistry() {
        return new CloseableRegistry();
    }

    @Override
    protected AbstractAutoCloseableRegistryTest.ProducerThread<Closeable, Closeable, Object> createProducerThread(AbstractAutoCloseableRegistry<Closeable, Closeable, Object, IOException> registry, final AtomicInteger unclosedCounter, int maxStreams) {
        return new AbstractAutoCloseableRegistryTest.ProducerThread<Closeable, Closeable, Object>(registry, unclosedCounter, maxStreams){

            @Override
            protected void createAndRegisterStream() throws IOException {
                AbstractAutoCloseableRegistryTest.TestStream testStream = new AbstractAutoCloseableRegistryTest.TestStream(unclosedCounter);
                this.registry.registerCloseable((AutoCloseable)testStream);
            }
        };
    }

    @Test
    public void testUnregisterAndCloseAll() throws IOException {
        try (CloseableRegistry closeableRegistry = new CloseableRegistry();){
            int i;
            int exTestSize = 5;
            int nonExTestSize = 5;
            ArrayList<TestClosable> registeredClosableList = new ArrayList<TestClosable>(exTestSize + nonExTestSize);
            for (i = 0; i < nonExTestSize; ++i) {
                registeredClosableList.add(new TestClosable());
            }
            this.unregisterAndCloseAllHelper(registeredClosableList, closeableRegistry, null);
            for (i = 0; i < exTestSize; ++i) {
                registeredClosableList.add(new TestClosable(String.valueOf(1 + i)));
            }
            this.unregisterAndCloseAllHelper(registeredClosableList, closeableRegistry, ioex -> {
                Throwable[] suppressed;
                int checksum = 0;
                checksum += Integer.parseInt(ioex.getMessage());
                for (Throwable throwable : suppressed = ioex.getSuppressed()) {
                    checksum += Integer.parseInt(throwable.getMessage());
                }
                Assertions.assertThat((int)checksum).isEqualTo(15);
            });
            TestClosable unregisteredClosable = new TestClosable();
            closeableRegistry.unregisterAndCloseAll(new Closeable[]{unregisteredClosable});
            Assertions.assertThat((int)unregisteredClosable.getCallsToClose()).isEqualTo(0);
        }
    }

    private void unregisterAndCloseAllHelper(List<TestClosable> registeredClosableList, CloseableRegistry closeableRegistry, @Nullable Consumer<IOException> exceptionCheck) throws IOException {
        block5: {
            for (TestClosable testClosable : registeredClosableList) {
                closeableRegistry.registerCloseable((AutoCloseable)testClosable);
            }
            try {
                closeableRegistry.unregisterAndCloseAll(registeredClosableList.toArray(new Closeable[0]));
                if (exceptionCheck != null) {
                    Fail.fail((String)"Exception expected");
                }
            }
            catch (IOException expected) {
                if (exceptionCheck == null) break block5;
                exceptionCheck.accept(expected);
            }
        }
        for (TestClosable testClosable : registeredClosableList) {
            Assertions.assertThat((int)testClosable.getCallsToClose()).isEqualTo(1);
            testClosable.resetCallsToClose();
        }
    }

    static class TestClosable
    implements Closeable {
        private final AtomicInteger callsToClose;
        private final String exceptionMessageOnClose;

        TestClosable() {
            this("");
        }

        TestClosable(String exceptionMessageOnClose) {
            this.exceptionMessageOnClose = exceptionMessageOnClose;
            this.callsToClose = new AtomicInteger(0);
        }

        @Override
        public void close() throws IOException {
            this.callsToClose.incrementAndGet();
            if (this.exceptionMessageOnClose != null && this.exceptionMessageOnClose.length() > 0) {
                throw new IOException(this.exceptionMessageOnClose);
            }
        }

        public int getCallsToClose() {
            return this.callsToClose.get();
        }

        public void resetCallsToClose() {
            this.callsToClose.set(0);
        }
    }
}

