/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.utils;

import com.alibaba.fluss.utils.DateTimeUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class DateTimeUtilsTest {
    @Test
    void testParseDate() {
        String input = "2023-10-25";
        Integer result = DateTimeUtils.parseDate((String)input);
        Assertions.assertThat((int)result).isEqualTo(19655);
        input = "2023-10-25 09:30:00.0";
        result = DateTimeUtils.parseDate((String)input);
        Assertions.assertThat((int)result).isEqualTo(19655);
        input = "22023-10";
        result = DateTimeUtils.parseDate((String)input);
        Assertions.assertThat((Integer)result).isNull();
        input = "abcd-10-25";
        result = DateTimeUtils.parseDate((String)input);
        Assertions.assertThat((Integer)result).isNull();
        input = "2023-ab-25";
        result = DateTimeUtils.parseDate((String)input);
        Assertions.assertThat((Integer)result).isNull();
        input = "2023-10-ab";
        result = DateTimeUtils.parseDate((String)input);
        Assertions.assertThat((Integer)result).isNull();
    }

    @Test
    void testParseTime() {
        String input = "09:30:00.0";
        Integer result = DateTimeUtils.parseTime((String)input);
        Assertions.assertThat((int)result).isEqualTo(34200000);
        input = "09:30:00.0+01:00";
        result = DateTimeUtils.parseTime((String)input);
        Assertions.assertThat((int)result).isEqualTo(37800000);
        input = "09:30:00.0-01:00";
        result = DateTimeUtils.parseTime((String)input);
        Assertions.assertThat((int)result).isEqualTo(30600000);
        input = "09:30";
        result = DateTimeUtils.parseTime((String)input);
        Assertions.assertThat((int)result).isEqualTo(34200000);
        input = "ab:30:00.0";
        result = DateTimeUtils.parseTime((String)input);
        Assertions.assertThat((Integer)result).isNull();
        input = "09:cd:00.0";
        result = DateTimeUtils.parseTime((String)input);
        Assertions.assertThat((Integer)result).isNull();
        input = "09:30:ef";
        result = DateTimeUtils.parseTime((String)input);
        Assertions.assertThat((Integer)result).isNull();
        input = "09:30:00.abcd";
        result = DateTimeUtils.parseTime((String)input);
        Assertions.assertThat((int)result).isEqualTo(34200001);
    }
}

