/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.utils;

import com.alibaba.fluss.utils.ExceptionUtils;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class ExceptionUtilsTest {
    @Test
    void testStringifyNullException() {
        Assertions.assertThat((String)"(null)").isNotNull();
        Assertions.assertThat((String)"(null)").isEqualTo(ExceptionUtils.stringifyException(null));
    }

    @Test
    public void testJvmFatalError() {
        Assertions.assertThat((boolean)ExceptionUtils.isJvmFatalError((Throwable)new Error())).isFalse();
        Assertions.assertThat((boolean)ExceptionUtils.isJvmFatalError((Throwable)new LinkageError())).isFalse();
        Assertions.assertThat((boolean)ExceptionUtils.isJvmFatalError((Throwable)new InternalError())).isTrue();
        Assertions.assertThat((boolean)ExceptionUtils.isJvmFatalError((Throwable)new UnknownError())).isTrue();
    }

    @Test
    public void testRethrowFatalError() {
        try {
            ExceptionUtils.rethrowIfFatalError((Throwable)new InternalError());
            Assertions.fail((String)"Expected InternalError");
        }
        catch (InternalError internalError) {
            // empty catch block
        }
        ExceptionUtils.rethrowIfFatalError((Throwable)new NoClassDefFoundError());
    }

    @Test
    void rethrow() {
        InternalError error = new InternalError();
        Assertions.assertThatThrownBy(() -> ExceptionUtils.rethrow((Throwable)error)).isInstanceOf(InternalError.class);
        RuntimeException runtimeException = new RuntimeException();
        Assertions.assertThatThrownBy(() -> ExceptionUtils.rethrow((Throwable)runtimeException)).isInstanceOf(RuntimeException.class);
        ClassNotFoundException classNotFoundException = new ClassNotFoundException();
        Assertions.assertThatThrownBy(() -> ExceptionUtils.rethrow((Throwable)classNotFoundException)).isInstanceOf(RuntimeException.class);
    }

    @Test
    public void testReThrowException() {
        Exception exception = new Exception("exception to be rethrown");
        Assertions.assertThatThrownBy(() -> ExceptionUtils.tryRethrowException((Exception)exception)).isEqualTo((Object)exception);
        String parentMsg = "wrapping exception msg";
        Error error = new Error("error");
        Assertions.assertThatThrownBy(() -> ExceptionUtils.rethrowException((Throwable)error, (String)parentMsg)).isEqualTo((Object)error);
        Assertions.assertThatThrownBy(() -> ExceptionUtils.rethrowException((Throwable)exception, (String)parentMsg)).isEqualTo((Object)exception);
        Throwable throwable = new Throwable("throwable");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ExceptionUtils.rethrowException((Throwable)throwable, (String)parentMsg)).isInstanceOf(Exception.class)).hasMessage(parentMsg).cause().isEqualTo((Object)throwable);
    }

    @Test
    public void testFindThrowableByType() {
        Assertions.assertThat((boolean)ExceptionUtils.findThrowable((Throwable)new RuntimeException(new IllegalStateException()), IllegalStateException.class).isPresent()).isTrue();
    }

    @Test
    void testFirstOrSuppressed() {
        Exception exception = new Exception("exception");
        Assertions.assertThat((Throwable)ExceptionUtils.firstOrSuppressed((Throwable)exception, null)).isEqualTo((Object)exception);
        Exception newException = new Exception("new exception");
        Exception suppressedException = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)newException, (Throwable)exception);
        Assertions.assertThat((Throwable)suppressedException).isEqualTo((Object)exception);
        Assertions.assertThat((Object[])suppressedException.getSuppressed()).isEqualTo((Object)new Throwable[]{newException});
    }

    @Test
    public void testExceptionStripping() {
        Exception expectedException = new Exception("test exception");
        Throwable strippedException = ExceptionUtils.stripException((Throwable)new RuntimeException(new RuntimeException(expectedException)), RuntimeException.class);
        Assertions.assertThat((Throwable)strippedException).isEqualTo((Object)expectedException);
        strippedException = ExceptionUtils.stripExecutionException((Throwable)new ExecutionException(expectedException));
        Assertions.assertThat((Throwable)strippedException).isEqualTo((Object)expectedException);
        strippedException = ExceptionUtils.stripCompletionException((Throwable)new CompletionException(expectedException));
        Assertions.assertThat((Throwable)strippedException).isEqualTo((Object)expectedException);
    }

    @Test
    public void testInvalidExceptionStripping() {
        Exception expectedException = new Exception(new RuntimeException(new Exception("inner exception")));
        Throwable strippedException = ExceptionUtils.stripException((Throwable)expectedException, RuntimeException.class);
        Assertions.assertThat((Throwable)strippedException).isEqualTo((Object)expectedException);
    }

    @Test
    public void testTryEnrichTaskExecutorErrorCanHandleNullValueWithoutCausingException() {
        ExceptionUtils.tryEnrichOutOfMemoryError(null, (String)"", (String)"", (String)"");
    }

    @Test
    public void testUpdateDetailMessageOfBasicThrowable() {
        OutOfMemoryError rootThrowable = new OutOfMemoryError("old message");
        ExceptionUtils.updateDetailMessage((Throwable)rootThrowable, t -> "new message");
        Assertions.assertThat((String)rootThrowable.getMessage()).isEqualTo("new message");
    }

    @Test
    public void testUpdateDetailMessageOfRelevantThrowableAsCause() {
        IllegalArgumentException oomCause = new IllegalArgumentException("another message deep down in the cause tree");
        Throwable oom = new OutOfMemoryError("old message").initCause(oomCause);
        oom.setStackTrace(new StackTraceElement[]{new StackTraceElement("class", "method", "file", 1)});
        oom.addSuppressed(new NullPointerException());
        IllegalStateException rootThrowable = new IllegalStateException("another message", oom);
        ExceptionUtils.updateDetailMessage((Throwable)rootThrowable, t -> t.getClass().equals(OutOfMemoryError.class) ? "new message" : null);
        Assertions.assertThat((Throwable)rootThrowable.getCause()).isSameAs((Object)oom);
        Assertions.assertThat((String)rootThrowable.getCause().getMessage()).isEqualTo("new message");
        Assertions.assertThat((Object[])rootThrowable.getCause().getStackTrace()).isEqualTo((Object)oom.getStackTrace());
        Assertions.assertThat((Object[])rootThrowable.getCause().getSuppressed()).isEqualTo((Object)oom.getSuppressed());
        Assertions.assertThat((Throwable)rootThrowable.getCause().getCause()).isSameAs((Object)oomCause);
    }

    @Test
    public void testUpdateDetailMessageWithoutRelevantThrowable() {
        IllegalStateException originalThrowable = new IllegalStateException("root message", new IllegalArgumentException("cause message"));
        ExceptionUtils.updateDetailMessage((Throwable)originalThrowable, t -> null);
        Assertions.assertThat((String)originalThrowable.getMessage()).isEqualTo("root message");
        Assertions.assertThat((String)originalThrowable.getCause().getMessage()).isEqualTo("cause message");
    }

    @Test
    public void testUpdateDetailMessageOfNullWithoutException() {
        ExceptionUtils.updateDetailMessage(null, t -> "new message");
    }

    @Test
    public void testUpdateDetailMessageWithMissingPredicate() {
        Exception root = new Exception("old message");
        ExceptionUtils.updateDetailMessage((Throwable)root, null);
        Assertions.assertThat((String)root.getMessage()).isEqualTo("old message");
    }

    @Test
    public void testIsMetaspaceOutOfMemoryErrorCanHandleNullValue() {
        Assertions.assertThat((boolean)ExceptionUtils.isMetaspaceOutOfMemoryError(null)).isFalse();
    }

    @Test
    public void testIsDirectOutOfMemoryErrorCanHandleNullValue() {
        Assertions.assertThat((boolean)ExceptionUtils.isDirectOutOfMemoryError(null)).isFalse();
    }
}

