/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.utils;

import com.alibaba.fluss.utils.ExecutorUtils;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class ExecutorUtilsTest {
    @Test
    void testGracefulShutdown() {
        ExecutorService executorService1 = Executors.newFixedThreadPool(1);
        ExecutorService executorService2 = Executors.newFixedThreadPool(2);
        ExecutorUtils.gracefulShutdown((long)1000L, (TimeUnit)TimeUnit.MILLISECONDS, (ExecutorService[])new ExecutorService[]{executorService1, executorService2});
        Assertions.assertThat((boolean)executorService1.isShutdown()).isTrue();
        Assertions.assertThat((boolean)executorService2.isShutdown()).isTrue();
    }

    @Test
    void testNoBlockingShutdown() throws Exception {
        ExecutorService executorService1 = Executors.newFixedThreadPool(1);
        ExecutorService executorService2 = Executors.newFixedThreadPool(2);
        ExecutorUtils.gracefulShutdown((long)1000L, (TimeUnit)TimeUnit.MILLISECONDS, (ExecutorService[])new ExecutorService[]{executorService1, executorService2});
        ExecutorUtils.nonBlockingShutdown((long)1000L, (TimeUnit)TimeUnit.MILLISECONDS, (ExecutorService[])new ExecutorService[]{executorService1, executorService2}).get();
        Assertions.assertThat((boolean)executorService1.isShutdown()).isTrue();
        Assertions.assertThat((boolean)executorService2.isShutdown()).isTrue();
    }
}

