/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.utils;

import com.alibaba.fluss.testutils.common.CheckedThread;
import com.alibaba.fluss.utils.FileUtils;
import com.alibaba.fluss.utils.OperatingSystem;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class FileUtilsTest {
    @TempDir
    private Path temporaryFolder;

    FileUtilsTest() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testDeleteQuietly() throws Exception {
        FileUtils.deleteDirectoryQuietly(null);
        File doesNotExist = Files.createDirectory(this.temporaryFolder.resolve("abc"), new FileAttribute[0]).toFile();
        FileUtils.deleteDirectoryQuietly((File)doesNotExist);
        File cannotDeleteParent = this.temporaryFolder.toFile();
        File cannotDeleteChild = new File(cannotDeleteParent, "child");
        try {
            Assertions.assertThat((boolean)cannotDeleteChild.createNewFile()).isTrue();
            Assertions.assertThat((boolean)cannotDeleteParent.setWritable(false)).isTrue();
            Assertions.assertThat((boolean)cannotDeleteChild.setWritable(false)).isTrue();
            FileUtils.deleteDirectoryQuietly((File)cannotDeleteParent);
        }
        finally {
            cannotDeleteParent.setWritable(true);
            cannotDeleteChild.setWritable(true);
        }
    }

    @Test
    void testDeleteDirectoryWhichIsAFile() throws Exception {
        File file = Files.createFile(this.temporaryFolder.resolve("test"), new FileAttribute[0]).toFile();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> FileUtils.deleteDirectory((File)file)).withFailMessage("this should fail with an exception", new Object[0])).isInstanceOf(IOException.class);
    }

    @Test
    void testDeleteSymbolicLinkDirectory() throws Exception {
        File linkedDirectory = this.temporaryFolder.toFile();
        File fileInLinkedDirectory = new File(linkedDirectory, "child");
        Assertions.assertThat((boolean)fileInLinkedDirectory.createNewFile()).isTrue();
        File symbolicLink = new File(this.temporaryFolder.toString(), "symLink");
        try {
            Files.createSymbolicLink(symbolicLink.toPath(), linkedDirectory.toPath(), new FileAttribute[0]);
        }
        catch (FileSystemException e) {
            ((AbstractBooleanAssert)Assumptions.assumeThat((boolean)OperatingSystem.isWindows()).withFailMessage("This test does not work properly under Windows", new Object[0])).isFalse();
            throw e;
        }
        FileUtils.deleteDirectory((File)symbolicLink);
        Assertions.assertThat((boolean)fileInLinkedDirectory.exists()).isTrue();
    }

    @Test
    void testDeleteDirectoryConcurrently() throws Exception {
        File parent = this.temporaryFolder.toFile();
        FileUtilsTest.generateRandomDirs(parent, 20, 5, 3);
        Deleter t1 = new Deleter(parent);
        Deleter t2 = new Deleter(parent);
        Deleter t3 = new Deleter(parent);
        t1.start();
        t2.start();
        t3.start();
        t1.sync();
        t2.sync();
        t3.sync();
        Assertions.assertThat((boolean)parent.exists()).isFalse();
    }

    private static void generateRandomDirs(File dir, int numFiles, int numDirs, int depth) throws IOException {
        int i;
        for (i = 0; i < numFiles; ++i) {
            File file = new File(dir, UUID.randomUUID().toString());
            try (FileOutputStream out = new FileOutputStream(file);){
                out.write(1);
                continue;
            }
        }
        if (depth > 0) {
            for (i = 0; i < numDirs; ++i) {
                File subdir = new File(dir, UUID.randomUUID().toString());
                Assertions.assertThat((boolean)subdir.mkdir()).isTrue();
                FileUtilsTest.generateRandomDirs(subdir, numFiles, numDirs, depth - 1);
            }
        }
    }

    private static class Deleter
    extends CheckedThread {
        private final File target;

        Deleter(File target) {
            this.target = target;
        }

        public void go() throws Exception {
            FileUtils.deleteDirectory((File)this.target);
        }
    }
}

