/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.utils;

import com.alibaba.fluss.utils.IOUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class IOUtilsTest {
    IOUtilsTest() {
    }

    @Test
    void testCloseQuietly() {
        CloserWithException withException = new CloserWithException();
        CloserWithoutException withoutException = new CloserWithoutException();
        IOUtils.closeQuietly((AutoCloseable)withException);
        IOUtils.closeQuietly((AutoCloseable)withoutException);
        IOUtils.closeAllQuietly(Arrays.asList(withException, withoutException));
    }

    @Test
    void testCopyBytes() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write("hello".getBytes());
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        ByteArrayOutputStream copyOut = new ByteArrayOutputStream();
        IOUtils.copyBytes((InputStream)in, (OutputStream)copyOut);
        byte[] buf = new byte[5];
        IOUtils.readFully((InputStream)new ByteArrayInputStream(out.toByteArray()), (byte[])buf, (int)0, (int)5);
        Assertions.assertThat((byte[])buf).isEqualTo((Object)new byte[]{104, 101, 108, 108, 111});
    }

    @Test
    void testReadFully() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write("hello".getBytes());
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        byte[] buf = new byte[5];
        IOUtils.readFully((InputStream)in, (byte[])buf);
        Assertions.assertThat((byte[])buf).isEqualTo((Object)new byte[]{104, 101, 108, 108, 111});
        out = new ByteArrayOutputStream();
        out.write("hello2".getBytes());
        in = new ByteArrayInputStream(out.toByteArray());
        buf = new byte[5];
        IOUtils.readFully((InputStream)in, (byte[])buf, (int)0, (int)5);
        Assertions.assertThat((byte[])buf).isEqualTo((Object)new byte[]{104, 101, 108, 108, 111});
    }

    private static class CloserWithoutException
    implements AutoCloseable {
        private CloserWithoutException() {
        }

        @Override
        public void close() throws Exception {
        }
    }

    private static class CloserWithException
    implements AutoCloseable {
        private CloserWithException() {
        }

        @Override
        public void close() throws Exception {
            throw new Exception("Fail to close");
        }
    }
}

