/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.utils;

import com.alibaba.fluss.utils.InstantiationUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Objects;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class InstantiationUtilTest {
    @Test
    void testSerDeserializeObject() throws Exception {
        TestClass deserializedTestClass;
        TestClass testClass = new TestClass(1, "f2");
        byte[] bytes = InstantiationUtil.serializeObject((Object)testClass);
        try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);){
            deserializedTestClass = (TestClass)InstantiationUtil.deserializeObject((InputStream)byteArrayInputStream, (ClassLoader)this.getClass().getClassLoader());
            Assertions.assertThat((Object)deserializedTestClass).isEqualTo((Object)testClass);
        }
        byteArrayInputStream = new ByteArrayInputStream(bytes);
        var4_4 = null;
        try {
            deserializedTestClass = (TestClass)InstantiationUtil.deserializeObject((InputStream)byteArrayInputStream, null);
            Assertions.assertThat((Object)deserializedTestClass).isEqualTo((Object)testClass);
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (byteArrayInputStream != null) {
                if (var4_4 != null) {
                    try {
                        byteArrayInputStream.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    byteArrayInputStream.close();
                }
            }
        }
    }

    @Test
    void testClone() throws Exception {
        Serializable clonedObj = InstantiationUtil.clone(null);
        Assertions.assertThat((Object)clonedObj).isNull();
        clonedObj = InstantiationUtil.clone(null, (ClassLoader)Thread.currentThread().getContextClassLoader());
        Assertions.assertThat((Object)clonedObj).isNull();
        String testString = "testString";
        Assertions.assertThat((String)((String)((Object)InstantiationUtil.clone((Serializable)((Object)testString))))).isEqualTo(testString);
        Assertions.assertThat((String)((String)((Object)InstantiationUtil.clone((Serializable)((Object)testString), (ClassLoader)Thread.currentThread().getContextClassLoader())))).isEqualTo(testString);
    }

    private static final class TestClass
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final int f1;
        private final String f2;

        public TestClass(int f1, String f2) {
            this.f1 = f1;
            this.f2 = f2;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TestClass testClass = (TestClass)o;
            return this.f1 == testClass.f1 && Objects.equals(this.f2, testClass.f2);
        }

        public int hashCode() {
            return Objects.hash(this.f1, this.f2);
        }
    }
}

