/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.utils;

import com.alibaba.fluss.utils.NetUtils;
import java.util.HashSet;
import java.util.Iterator;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Fail;
import org.junit.jupiter.api.Test;

class NetUtilsTest {
    NetUtilsTest() {
    }

    @Test
    public void testFreePortRangeUtility() {
        String rangeDefinition = "50000-50050, 50100-50200,51234 ";
        Iterator portsIter = NetUtils.getPortRangeFromString((String)rangeDefinition);
        HashSet ports = new HashSet();
        while (portsIter.hasNext()) {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)ports.add(portsIter.next())).as("Duplicate element", new Object[0])).isTrue();
        }
        Assertions.assertThat((int)ports.size()).isEqualTo(153);
        Assertions.assertThat(ports).contains((Object[])new Integer[]{50000, 50001, 50002, 50050});
        Assertions.assertThat(ports).contains((Object[])new Integer[]{50100, 50101, 50110, 50200, 51234});
        Assertions.assertThat(ports).doesNotContain((Object[])new Integer[]{50051, 50052, 1337, 50201, 49999, 50099});
        portsIter = NetUtils.getPortRangeFromString((String)" 51234");
        Assertions.assertThat((boolean)portsIter.hasNext()).isTrue();
        Assertions.assertThat((int)((Integer)portsIter.next())).isEqualTo(51234);
        Assertions.assertThat((boolean)portsIter.hasNext()).isFalse();
        portsIter = NetUtils.getPortRangeFromString((String)"5,1,2,3,4");
        Assertions.assertThat((boolean)portsIter.hasNext()).isTrue();
        Assertions.assertThat((int)((Integer)portsIter.next())).isEqualTo(5);
        Assertions.assertThat((int)((Integer)portsIter.next())).isEqualTo(1);
        Assertions.assertThat((int)((Integer)portsIter.next())).isEqualTo(2);
        Assertions.assertThat((int)((Integer)portsIter.next())).isEqualTo(3);
        Assertions.assertThat((int)((Integer)portsIter.next())).isEqualTo(4);
        Assertions.assertThat((boolean)portsIter.hasNext()).isFalse();
        Throwable error = null;
        try {
            NetUtils.getPortRangeFromString((String)"localhost");
        }
        catch (Throwable t) {
            error = t;
        }
        Assertions.assertThat((boolean)(error instanceof NumberFormatException)).isTrue();
        error = null;
        try {
            NetUtils.getPortRangeFromString((String)"5-");
        }
        catch (Throwable t) {
            error = t;
        }
        Assertions.assertThat((boolean)(error instanceof NumberFormatException)).isTrue();
        error = null;
        try {
            NetUtils.getPortRangeFromString((String)"-5");
        }
        catch (Throwable t) {
            error = t;
        }
        Assertions.assertThat((boolean)(error instanceof NumberFormatException)).isTrue();
        error = null;
        try {
            NetUtils.getPortRangeFromString((String)",5");
        }
        catch (Throwable t) {
            error = t;
        }
        Assertions.assertThat((boolean)(error instanceof NumberFormatException)).isTrue();
    }

    @Test
    public void testFormatAddress() {
        String host = null;
        int port = 42;
        Assertions.assertThat((String)NetUtils.unresolvedHostAndPortToNormalizedString(host, (int)port)).isEqualTo("127.0.0.1:" + port);
        host = "1.2.3.4";
        port = 42;
        Assertions.assertThat((String)NetUtils.unresolvedHostAndPortToNormalizedString((String)host, (int)port)).isEqualTo(host + ":" + port);
        host = "2001:0db8:85a3:0000:0000:8a2e:0370:7334";
        port = 42;
        Assertions.assertThat((String)NetUtils.unresolvedHostAndPortToNormalizedString((String)host, (int)port)).isEqualTo("[2001:db8:85a3::8a2e:370:7334]:" + port);
        host = "[2001:0db8:85a3:0000:0000:8a2e:0370:7334]";
        port = 42;
        Assertions.assertThat((String)NetUtils.unresolvedHostAndPortToNormalizedString((String)host, (int)port)).isEqualTo("[2001:db8:85a3::8a2e:370:7334]:" + port);
        host = "somerandomhostname";
        port = 99;
        Assertions.assertThat((String)NetUtils.unresolvedHostAndPortToNormalizedString((String)host, (int)port)).isEqualTo(host + ":" + port);
        host = "  somerandomhostname  ";
        port = 99;
        Assertions.assertThat((String)NetUtils.unresolvedHostAndPortToNormalizedString((String)host, (int)port)).isEqualTo(host.trim() + ":" + port);
        host = "illegalhost.";
        port = 42;
        try {
            NetUtils.unresolvedHostAndPortToNormalizedString((String)host, (int)port);
            Fail.fail((String)("should throw exception for Illegal hostnames: " + host));
        }
        catch (Exception exception) {
            // empty catch block
        }
        host = "illegalhost:fasf";
        try {
            NetUtils.unresolvedHostAndPortToNormalizedString((String)host, (int)port);
            Fail.fail((String)("should throw exception for Illegal hostnames: " + host));
        }
        catch (Exception exception) {
            // empty catch block
        }
        host = "1.2.3.4";
        port = -1;
        try {
            NetUtils.unresolvedHostAndPortToNormalizedString((String)host, (int)port);
            Fail.fail((String)("should throw exception for Illegal hostnames: " + host));
        }
        catch (Exception exception) {
            // empty catch block
        }
        host = "CamelCaseHostName";
        port = 99;
        Assertions.assertThat((String)NetUtils.unresolvedHostAndPortToNormalizedString((String)host, (int)port)).isEqualTo(host.toLowerCase() + ":" + port);
    }
}

