/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.utils;

import com.alibaba.fluss.row.BinaryString;
import com.alibaba.fluss.row.GenericRow;
import com.alibaba.fluss.row.InternalRow;
import com.alibaba.fluss.row.ProjectedRow;
import com.alibaba.fluss.types.DataField;
import com.alibaba.fluss.types.DataType;
import com.alibaba.fluss.types.DataTypes;
import com.alibaba.fluss.types.RowType;
import com.alibaba.fluss.utils.Projection;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class ProjectionTest {
    ProjectionTest() {
    }

    @Test
    void testProjection() {
        Projection projection = Projection.of((int[])new int[]{2, 0, 3});
        Assertions.assertThat((int[])projection.getProjectionInOrder()).isEqualTo((Object)new int[]{0, 2, 3});
        RowType rowType = projection.projectInOrder(DataTypes.ROW((DataField[])new DataField[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"f1", (DataType)DataTypes.BIGINT()), DataTypes.FIELD((String)"f2", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"f3", (DataType)DataTypes.DOUBLE())}));
        Assertions.assertThat((Object)rowType).isEqualTo((Object)DataTypes.ROW((DataField[])new DataField[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"f2", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"f3", (DataType)DataTypes.DOUBLE())}));
        Assertions.assertThat((boolean)projection.isReorderingNeeded()).isTrue();
        Assertions.assertThat((int[])projection.getReorderingIndexes()).isEqualTo((Object)new int[]{1, 0, 2});
        Assertions.assertThat((Object)rowType.project(projection.getReorderingIndexes())).isEqualTo((Object)DataTypes.ROW((DataField[])new DataField[]{DataTypes.FIELD((String)"f2", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"f0", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"f3", (DataType)DataTypes.DOUBLE())}));
        GenericRow row = GenericRow.of((Object[])new Object[]{0, 1L, BinaryString.fromString((String)"2"), 3.0});
        ProjectedRow p1 = ProjectedRow.from((int[])projection.getProjectionInOrder());
        p1.replaceRow((InternalRow)row);
        ProjectedRow p2 = ProjectedRow.from((int[])projection.getReorderingIndexes());
        p2.replaceRow((InternalRow)p1);
        Assertions.assertThat((String)p2.getString(0).toString()).isEqualTo("2");
        Assertions.assertThat((int)p2.getInt(1)).isEqualTo(0);
        Assertions.assertThat((double)p2.getDouble(2)).isEqualTo(3.0);
    }
}

