/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.utils;

import com.alibaba.fluss.shaded.netty4.io.netty.buffer.ByteBuf;
import com.alibaba.fluss.shaded.netty4.io.netty.buffer.Unpooled;
import com.alibaba.fluss.utils.ProtoCodecUtils;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class ProtoCodecUtilsTest {
    private final byte[] b = new byte[4096];
    private final ByteBuf bb = Unpooled.wrappedBuffer((byte[])this.b);

    @BeforeEach
    public void setup() {
        this.bb.clear();
        Arrays.fill(this.b, (byte)0);
    }

    @ParameterizedTest
    @ValueSource(ints={-2147483648, -1000, -100, -2, -1, 0, 1, 10, 100, 1000, 10000, 100000, 10000000, 0x7FFFFFFF})
    public void testVarInt(int i) throws Exception {
        ProtoCodecUtils.writeVarInt((ByteBuf)this.bb, (int)i);
        CodedInputStream is = CodedInputStream.newInstance((byte[])this.b);
        int res = is.readRawVarint32();
        Assertions.assertThat((int)res).isEqualTo(i);
        res = ProtoCodecUtils.readVarInt((ByteBuf)this.bb);
        Assertions.assertThat((int)res).isEqualTo(i);
        Assertions.assertThat((int)ProtoCodecUtils.computeVarIntSize((int)i)).isEqualTo(CodedOutputStream.computeInt32SizeNoTag((int)i));
    }

    @ParameterizedTest
    @ValueSource(longs={-9223372036854775808L, -10000000L, -100L, -2L, -1L, 0L, 1L, 10L, 100L, 10000000L, 2000000000000000000L, 0x7FFFFFFFFFFFFFFFL, 0x7FFFFFFFFFFFFFFFL, 0x7FFFFFFFFFFFFFFFL, 0x7FFFFFFFFFFFFFFFL})
    public void testVarInt64(long i) throws Exception {
        ProtoCodecUtils.writeVarInt64((ByteBuf)this.bb, (long)i);
        CodedInputStream is = CodedInputStream.newInstance((byte[])this.b);
        long res = is.readRawVarint64();
        Assertions.assertThat((long)res).isEqualTo(i);
        res = ProtoCodecUtils.readVarInt64((ByteBuf)this.bb);
        Assertions.assertThat((long)res).isEqualTo(i);
        Assertions.assertThat((int)ProtoCodecUtils.computeVarInt64Size((long)i)).isEqualTo(CodedOutputStream.computeInt64SizeNoTag((long)i));
    }

    @ParameterizedTest
    @ValueSource(ints={-2147483648, -1000, -100, -2, -1, 0, 1, 10, 100, 1000, 0x7FFFFFFF})
    public void testSignedVarInt(int i) throws Exception {
        ProtoCodecUtils.writeSignedVarInt((ByteBuf)this.bb, (int)i);
        CodedInputStream is = CodedInputStream.newInstance((byte[])this.b);
        int res = is.readSInt32();
        Assertions.assertThat((int)res).isEqualTo(i);
        res = ProtoCodecUtils.readSignedVarInt((ByteBuf)this.bb);
        Assertions.assertThat((int)res).isEqualTo(i);
        Assertions.assertThat((int)ProtoCodecUtils.computeSignedVarIntSize((int)i)).isEqualTo(CodedOutputStream.computeSInt32SizeNoTag((int)i));
    }

    @ParameterizedTest
    @ValueSource(longs={-9223372036854775808L, -10000000L, -100L, -2L, -1L, 0L, 1L, 10L, 100L, 10000000L, 0x7FFFFFFFFFFFFFFFL})
    public void testSignedVarInt64(long i) throws Exception {
        ProtoCodecUtils.writeSignedVarInt64((ByteBuf)this.bb, (long)i);
        CodedInputStream is = CodedInputStream.newInstance((byte[])this.b);
        long res = is.readSInt64();
        Assertions.assertThat((long)res).isEqualTo(i);
        res = ProtoCodecUtils.readSignedVarInt64((ByteBuf)this.bb);
        Assertions.assertThat((long)res).isEqualTo(i);
        Assertions.assertThat((int)ProtoCodecUtils.computeSignedVarInt64Size((long)i)).isEqualTo(CodedOutputStream.computeSInt64SizeNoTag((long)i));
    }

    @ParameterizedTest
    @ValueSource(ints={-2147483648, -1000, -100, -2, -1, 0, 1, 10, 100, 1000, 0x7FFFFFFF})
    public void testFixedInt32(int i) throws Exception {
        ProtoCodecUtils.writeFixedInt32((ByteBuf)this.bb, (int)i);
        CodedInputStream is = CodedInputStream.newInstance((byte[])this.b);
        int res = is.readFixed32();
        Assertions.assertThat((int)res).isEqualTo(i);
        res = ProtoCodecUtils.readFixedInt32((ByteBuf)this.bb);
        Assertions.assertThat((int)res).isEqualTo(i);
    }

    @ParameterizedTest
    @ValueSource(longs={-9223372036854775808L, -10000000L, -100L, -2L, -1L, 0L, 1L, 10L, 100L, 10000000L, 0x7FFFFFFFFFFFFFFFL})
    public void testFixedInt64(long i) throws Exception {
        ProtoCodecUtils.writeFixedInt64((ByteBuf)this.bb, (long)i);
        CodedInputStream is = CodedInputStream.newInstance((byte[])this.b);
        long res = is.readFixed64();
        Assertions.assertThat((long)res).isEqualTo(i);
        res = ProtoCodecUtils.readFixedInt64((ByteBuf)this.bb);
        Assertions.assertThat((long)res).isEqualTo(i);
    }

    @ParameterizedTest
    @ValueSource(floats={1.4E-45f, -1000.0f, -100.0f, -2.0f, -1.0f, 0.0f, 1.0f, 10.0f, 100.0f, 1000.0f, 3.4028235E38f})
    public void testFloat(float i) throws Exception {
        ProtoCodecUtils.writeFloat((ByteBuf)this.bb, (float)i);
        CodedInputStream is = CodedInputStream.newInstance((byte[])this.b);
        float res = is.readFloat();
        Assertions.assertThat((float)res).isEqualTo(i);
        res = ProtoCodecUtils.readFloat((ByteBuf)this.bb);
        Assertions.assertThat((float)res).isEqualTo(i);
    }

    @ParameterizedTest
    @ValueSource(doubles={4.9E-324, -1.0E7, -100.0, -2.0, -1.0, 0.0, 1.0, 10.0, 100.0, 1.0E7, 1.7976931348623157E308})
    public void testDouble(double i) throws Exception {
        ProtoCodecUtils.writeDouble((ByteBuf)this.bb, (double)i);
        CodedInputStream is = CodedInputStream.newInstance((byte[])this.b);
        double res = is.readDouble();
        Assertions.assertThat((double)res).isEqualTo(i);
        res = ProtoCodecUtils.readDouble((ByteBuf)this.bb);
        Assertions.assertThat((double)res).isEqualTo(i);
    }

    @ParameterizedTest
    @ValueSource(strings={"hello", "UTF16 \u0395\u03bb\u03bb\u03b7\u03bd\u03b9\u03ba\u03ac \u0420\u0443\u0441\u0441\u043a\u0438\u0439 \u65e5\u672c\u8a9e", "Neque porro quisquam est qui dolorem ipsum"})
    public void testString(String s) throws Exception {
        byte[] sb = s.getBytes(StandardCharsets.UTF_8);
        Assertions.assertThat((int)ProtoCodecUtils.computeStringUTF8Size((String)s)).isEqualTo(sb.length);
        ProtoCodecUtils.writeVarInt((ByteBuf)this.bb, (int)sb.length);
        int idx = this.bb.writerIndex();
        ProtoCodecUtils.writeString((ByteBuf)this.bb, (String)s, (int)sb.length);
        CodedInputStream is = CodedInputStream.newInstance((byte[])this.b);
        Assertions.assertThat((String)is.readString()).isEqualTo(s);
        Assertions.assertThat((int)ProtoCodecUtils.readVarInt((ByteBuf)this.bb)).isEqualTo(sb.length);
        Assertions.assertThat((String)ProtoCodecUtils.readString((ByteBuf)this.bb, (int)idx, (int)sb.length)).isEqualTo(s);
        Assertions.assertThat((int)(ProtoCodecUtils.computeVarIntSize((int)sb.length) + ProtoCodecUtils.computeStringUTF8Size((String)s))).isEqualTo(CodedOutputStream.computeStringSizeNoTag((String)s));
    }
}

