/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.utils;

import com.alibaba.fluss.utils.StringUtils;
import java.time.DayOfWeek;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class StringUtilsTest {
    @Test
    void testIsNullOrWhitespaceOnly() {
        Assertions.assertThat((boolean)StringUtils.isNullOrWhitespaceOnly(null)).isTrue();
        Assertions.assertThat((boolean)StringUtils.isNullOrWhitespaceOnly((String)"")).isTrue();
        Assertions.assertThat((boolean)StringUtils.isNullOrWhitespaceOnly((String)"    ")).isTrue();
        Assertions.assertThat((boolean)StringUtils.isNullOrWhitespaceOnly((String)"hell o")).isFalse();
        Assertions.assertThat((boolean)StringUtils.isNullOrWhitespaceOnly((String)"hello")).isFalse();
    }

    @Test
    void testArrayAwareToString() {
        Assertions.assertThat((String)StringUtils.arrayAwareToString(null)).isEqualTo("null");
        Assertions.assertThat((String)StringUtils.arrayAwareToString((Object)DayOfWeek.MONDAY)).isEqualTo("MONDAY");
        Assertions.assertThat((String)StringUtils.arrayAwareToString((Object)new int[]{1, 2, 3})).isEqualTo("[1, 2, 3]");
        Assertions.assertThat((String)StringUtils.arrayAwareToString((Object)new byte[][]{{4, 5, 6}, null, new byte[0]})).isEqualTo("[[4, 5, 6], null, []]");
        Assertions.assertThat((String)StringUtils.arrayAwareToString((Object)new Object[]{new Integer[]{4, 5, 6}, null, DayOfWeek.MONDAY})).isEqualTo("[[4, 5, 6], null, MONDAY]");
    }
}

