/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.utils;

import com.alibaba.fluss.utils.TimeUtils;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TimeUtilsTest {
    @Test
    public void testParseDurationNanos() {
        Assertions.assertThat((int)TimeUtils.parseDuration((String)"424562ns").getNano()).isEqualTo(424562);
        Assertions.assertThat((int)TimeUtils.parseDuration((String)"424562nano").getNano()).isEqualTo(424562);
        Assertions.assertThat((int)TimeUtils.parseDuration((String)"424562nanos").getNano()).isEqualTo(424562);
        Assertions.assertThat((int)TimeUtils.parseDuration((String)"424562nanosecond").getNano()).isEqualTo(424562);
        Assertions.assertThat((int)TimeUtils.parseDuration((String)"424562nanoseconds").getNano()).isEqualTo(424562);
        Assertions.assertThat((int)TimeUtils.parseDuration((String)"424562 ns").getNano()).isEqualTo(424562);
    }

    @Test
    public void testParseDurationMicros() {
        Assertions.assertThat((int)TimeUtils.parseDuration((String)"565731\u00b5s").getNano()).isEqualTo(565731000L);
        Assertions.assertThat((int)TimeUtils.parseDuration((String)"565731micro").getNano()).isEqualTo(565731000L);
        Assertions.assertThat((int)TimeUtils.parseDuration((String)"565731micros").getNano()).isEqualTo(565731000L);
        Assertions.assertThat((int)TimeUtils.parseDuration((String)"565731microsecond").getNano()).isEqualTo(565731000L);
        Assertions.assertThat((int)TimeUtils.parseDuration((String)"565731microseconds").getNano()).isEqualTo(565731000L);
        Assertions.assertThat((int)TimeUtils.parseDuration((String)"565731 \u00b5s").getNano()).isEqualTo(565731000L);
    }

    @Test
    public void testParseDurationMillis() {
        Assertions.assertThat((long)TimeUtils.parseDuration((String)"1234ms").toMillis()).isEqualTo(1234L);
        Assertions.assertThat((long)TimeUtils.parseDuration((String)"1234milli").toMillis()).isEqualTo(1234L);
        Assertions.assertThat((long)TimeUtils.parseDuration((String)"1234millis").toMillis()).isEqualTo(1234L);
        Assertions.assertThat((long)TimeUtils.parseDuration((String)"1234millisecond").toMillis()).isEqualTo(1234L);
        Assertions.assertThat((long)TimeUtils.parseDuration((String)"1234milliseconds").toMillis()).isEqualTo(1234L);
        Assertions.assertThat((long)TimeUtils.parseDuration((String)"1234 ms").toMillis()).isEqualTo(1234L);
    }

    @Test
    public void testParseDurationSeconds() {
        Assertions.assertThat((long)TimeUtils.parseDuration((String)"667766s").getSeconds()).isEqualTo(667766L);
        Assertions.assertThat((long)TimeUtils.parseDuration((String)"667766sec").getSeconds()).isEqualTo(667766L);
        Assertions.assertThat((long)TimeUtils.parseDuration((String)"667766secs").getSeconds()).isEqualTo(667766L);
        Assertions.assertThat((long)TimeUtils.parseDuration((String)"667766second").getSeconds()).isEqualTo(667766L);
        Assertions.assertThat((long)TimeUtils.parseDuration((String)"667766seconds").getSeconds()).isEqualTo(667766L);
        Assertions.assertThat((long)TimeUtils.parseDuration((String)"667766 s").getSeconds()).isEqualTo(667766L);
    }

    @Test
    public void testParseDurationMinutes() {
        Assertions.assertThat((long)TimeUtils.parseDuration((String)"7657623m").toMinutes()).isEqualTo(7657623L);
        Assertions.assertThat((long)TimeUtils.parseDuration((String)"7657623min").toMinutes()).isEqualTo(7657623L);
        Assertions.assertThat((long)TimeUtils.parseDuration((String)"7657623minute").toMinutes()).isEqualTo(7657623L);
        Assertions.assertThat((long)TimeUtils.parseDuration((String)"7657623minutes").toMinutes()).isEqualTo(7657623L);
        Assertions.assertThat((long)TimeUtils.parseDuration((String)"7657623 min").toMinutes()).isEqualTo(7657623L);
    }

    @Test
    public void testParseDurationHours() {
        Assertions.assertThat((long)TimeUtils.parseDuration((String)"987654h").toHours()).isEqualTo(987654L);
        Assertions.assertThat((long)TimeUtils.parseDuration((String)"987654hour").toHours()).isEqualTo(987654L);
        Assertions.assertThat((long)TimeUtils.parseDuration((String)"987654hours").toHours()).isEqualTo(987654L);
        Assertions.assertThat((long)TimeUtils.parseDuration((String)"987654 h").toHours()).isEqualTo(987654L);
    }

    @Test
    public void testParseDurationDays() {
        Assertions.assertThat((long)TimeUtils.parseDuration((String)"987654d").toDays()).isEqualTo(987654L);
        Assertions.assertThat((long)TimeUtils.parseDuration((String)"987654day").toDays()).isEqualTo(987654L);
        Assertions.assertThat((long)TimeUtils.parseDuration((String)"987654days").toDays()).isEqualTo(987654L);
        Assertions.assertThat((long)TimeUtils.parseDuration((String)"987654 d").toDays()).isEqualTo(987654L);
    }

    @Test
    public void testParseDurationUpperCase() {
        Assertions.assertThat((long)TimeUtils.parseDuration((String)"1 NS").toNanos()).isEqualTo(1L);
        Assertions.assertThat((long)TimeUtils.parseDuration((String)"1 MICRO").toNanos()).isEqualTo(1000L);
        Assertions.assertThat((long)TimeUtils.parseDuration((String)"1 MS").toMillis()).isEqualTo(1L);
        Assertions.assertThat((long)TimeUtils.parseDuration((String)"1 S").getSeconds()).isEqualTo(1L);
        Assertions.assertThat((long)TimeUtils.parseDuration((String)"1 MIN").toMinutes()).isEqualTo(1L);
        Assertions.assertThat((long)TimeUtils.parseDuration((String)"1 H").toHours()).isEqualTo(1L);
        Assertions.assertThat((long)TimeUtils.parseDuration((String)"1 D").toDays()).isEqualTo(1L);
    }

    @Test
    public void testParseDurationTrim() {
        Assertions.assertThat((long)TimeUtils.parseDuration((String)"      155      ms   ").toMillis()).isEqualTo(155L);
    }

    @Test
    public void testParseDurationInvalid() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TimeUtils.parseDuration((String)"1234")).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("The time value '1234' does not specify a time unit.");
        Assertions.assertThatThrownBy(() -> TimeUtils.parseDuration((String)"      155      ")).isInstanceOf(IllegalArgumentException.class);
        Assertions.assertThatThrownBy(() -> TimeUtils.parseDuration(null)).isInstanceOf(NullPointerException.class);
        Assertions.assertThatThrownBy(() -> TimeUtils.parseDuration((String)"")).isInstanceOf(IllegalArgumentException.class);
        Assertions.assertThatThrownBy(() -> TimeUtils.parseDuration((String)"     ")).isInstanceOf(IllegalArgumentException.class);
        Assertions.assertThatThrownBy(() -> TimeUtils.parseDuration((String)"foobar or fubar or foo bazz")).isInstanceOf(IllegalArgumentException.class);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TimeUtils.parseDuration((String)"16 gjah")).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Time interval unit label 'gjah' does not match any of the recognized units");
        Assertions.assertThatThrownBy(() -> TimeUtils.parseDuration((String)"16 16 17 18ms")).isInstanceOf(IllegalArgumentException.class);
        Assertions.assertThatThrownBy(() -> TimeUtils.parseDuration((String)"-100ms")).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    public void testParseDurationNumberOverflow() {
        Assertions.assertThatThrownBy(() -> TimeUtils.parseDuration((String)"100000000000000000000000000000000 ms")).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    public void testGetStringInMillis() {
        Assertions.assertThat((String)TimeUtils.getStringInMillis((Duration)Duration.ofMillis(4567L))).isEqualTo("4567ms");
        Assertions.assertThat((String)TimeUtils.getStringInMillis((Duration)Duration.ofSeconds(4567L))).isEqualTo("4567000ms");
        Assertions.assertThat((String)TimeUtils.getStringInMillis((Duration)Duration.of(4567L, ChronoUnit.MICROS))).isEqualTo("4ms");
    }
}

