/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.utils;

import com.alibaba.fluss.row.BinaryString;
import com.alibaba.fluss.row.Decimal;
import com.alibaba.fluss.row.TimestampNtz;
import com.alibaba.fluss.types.DataType;
import com.alibaba.fluss.types.DataTypes;
import com.alibaba.fluss.utils.DateTimeUtils;
import com.alibaba.fluss.utils.TypeUtils;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TypeUtilsTest {
    @Test
    void testCastFromString() {
        Assertions.assertThat((Object)TypeUtils.castFromString((String)"abc", (DataType)DataTypes.CHAR((int)3))).isEqualTo((Object)BinaryString.fromString((String)"abc"));
        Assertions.assertThat((Object)TypeUtils.castFromString((String)"abc", (DataType)DataTypes.STRING())).isEqualTo((Object)BinaryString.fromString((String)"abc"));
        Assertions.assertThat((boolean)((Boolean)TypeUtils.castFromString((String)"true", (DataType)DataTypes.BOOLEAN()))).isTrue();
        Assertions.assertThat((boolean)((Boolean)TypeUtils.castFromString((String)"false", (DataType)DataTypes.BOOLEAN()))).isFalse();
        Assertions.assertThat((Object)TypeUtils.castFromString((String)"abc", (DataType)DataTypes.BINARY((int)3))).isEqualTo((Object)new byte[]{97, 98, 99});
        Assertions.assertThat((Object)TypeUtils.castFromString((String)"abc", (DataType)DataTypes.BYTES())).isEqualTo((Object)new byte[]{97, 98, 99});
        Assertions.assertThat((Object)TypeUtils.castFromString((String)"13145678.90123", (DataType)DataTypes.DECIMAL((int)15, (int)5))).isEqualTo((Object)Decimal.fromBigDecimal((BigDecimal)new BigDecimal("13145678.90123"), (int)15, (int)5));
        Assertions.assertThat((Object)TypeUtils.castFromString((String)"2", (DataType)DataTypes.TINYINT())).isEqualTo((Object)2);
        Assertions.assertThat((Object)TypeUtils.castFromString((String)"2", (DataType)DataTypes.SMALLINT())).isEqualTo((Object)2);
        Assertions.assertThat((Object)TypeUtils.castFromString((String)"2", (DataType)DataTypes.INT())).isEqualTo((Object)2);
        Assertions.assertThat((Object)TypeUtils.castFromString((String)"2", (DataType)DataTypes.BIGINT())).isEqualTo((Object)2L);
        Assertions.assertThat((Object)TypeUtils.castFromString((String)"2.2", (DataType)DataTypes.FLOAT())).isEqualTo((Object)Float.valueOf(2.2f));
        Assertions.assertThat((Object)TypeUtils.castFromString((String)"2.2", (DataType)DataTypes.DOUBLE())).isEqualTo((Object)2.2);
        Assertions.assertThat((LocalDate)DateTimeUtils.toLocalDate((int)((Integer)TypeUtils.castFromString((String)"2023-10-25", (DataType)DataTypes.DATE())))).isEqualTo((Object)LocalDate.of(2023, 10, 25));
        Assertions.assertThat((LocalTime)DateTimeUtils.toLocalTime((int)((Integer)TypeUtils.castFromString((String)"09:30:00.0", (DataType)DataTypes.TIME())))).isEqualTo((Object)LocalTime.of(9, 30, 0, 0));
        Assertions.assertThat((Object)TypeUtils.castFromString((String)"2023-10-25", (DataType)DataTypes.TIMESTAMP((int)6))).isEqualTo((Object)TimestampNtz.fromLocalDateTime((LocalDateTime)LocalDateTime.of(2023, 10, 25, 0, 0)));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TypeUtils.castFromString((String)"1", (DataType)DataTypes.ARRAY((DataType)DataTypes.INT()))).isInstanceOf(UnsupportedOperationException.class)).hasMessageContaining("Unsupported type");
    }
}

