/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.utils;

import com.alibaba.fluss.exception.TraversableOnceException;
import com.alibaba.fluss.utils.UnionIterator;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class UnionIteratorTest {
    UnionIteratorTest() {
    }

    @Test
    void testUnion() {
        try {
            UnionIterator iter = new UnionIterator();
            Assertions.assertThat((boolean)iter.iterator().hasNext()).isFalse();
            iter.clear();
            try {
                iter.iterator().next();
                Assertions.fail((String)"should fail with an exception");
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            iter.clear();
            iter.addList(Arrays.asList(1, 2, 3, 4, 5, 6, 7));
            iter.addList(Collections.emptyList());
            iter.addList(Arrays.asList(8, 9, 10, 11));
            int val = 1;
            Iterator iterator = iter.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                Assertions.assertThat((int)i).isEqualTo(val++);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testTraversableOnce() {
        try {
            UnionIterator iter = new UnionIterator();
            iter.iterator();
            try {
                iter.iterator();
                Assertions.fail((String)"should fail with an exception");
            }
            catch (TraversableOnceException traversableOnceException) {
                // empty catch block
            }
            try {
                iter.iterator();
                Assertions.fail((String)"should fail with an exception");
            }
            catch (TraversableOnceException traversableOnceException) {
                // empty catch block
            }
            iter.clear();
            iter.iterator();
            try {
                iter.iterator();
                Assertions.fail((String)"should fail with an exception");
            }
            catch (TraversableOnceException traversableOnceException) {
                // empty catch block
            }
            try {
                iter.iterator();
                Assertions.fail((String)"should fail with an exception");
            }
            catch (TraversableOnceException traversableOnceException) {
                // empty catch block
            }
            iter.clear();
            iter.addList(Arrays.asList(1, 2, 3, 4, 5, 6, 7));
            Iterator ints = iter.iterator();
            Assertions.assertThat((Integer)((Integer)ints.next())).isNotNull();
            Assertions.assertThat((Integer)((Integer)ints.next())).isNotNull();
            Assertions.assertThat((Integer)((Integer)ints.next())).isNotNull();
            try {
                iter.iterator();
                Assertions.fail((String)"should fail with an exception");
            }
            catch (TraversableOnceException traversableOnceException) {
                // empty catch block
            }
            iter.clear();
            Assertions.assertThat((boolean)iter.iterator().hasNext()).isFalse();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)e.getMessage());
        }
    }
}

