/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.utils;

import com.alibaba.fluss.memory.InputView;
import com.alibaba.fluss.memory.MemorySegmentInputView;
import com.alibaba.fluss.memory.MemorySegmentOutputView;
import com.alibaba.fluss.memory.OutputView;
import com.alibaba.fluss.utils.VarLengthUtils;
import java.io.IOException;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class VarLengthUtilsTest {
    MemorySegmentOutputView out;

    @BeforeEach
    public void before() {
        this.out = new MemorySegmentOutputView(4096);
    }

    @Test
    void testVarInt() throws IOException {
        VarLengthUtils.writeVarInt((OutputView)this.out, (int)-1);
        VarLengthUtils.writeVarInt((OutputView)this.out, (int)10);
        VarLengthUtils.writeVarInt((OutputView)this.out, (int)20);
        MemorySegmentInputView in = new MemorySegmentInputView(this.out.getMemorySegment());
        Assertions.assertThat((int)VarLengthUtils.readVarInt((InputView)in)).isEqualTo(-1);
        Assertions.assertThat((int)VarLengthUtils.readVarInt((InputView)in)).isEqualTo(10);
        Assertions.assertThat((int)VarLengthUtils.readVarInt((InputView)in)).isEqualTo(20);
    }

    @Test
    void testReadVarInt() throws IOException {
        int size = 0;
        VarLengthUtils.writeVarInt((OutputView)this.out, (int)-1);
        int len1 = VarLengthUtils.sizeOfVarInt((int)-1);
        size += len1;
        VarLengthUtils.writeVarInt((OutputView)this.out, (int)10);
        int len2 = VarLengthUtils.sizeOfVarInt((int)10);
        size += len2;
        VarLengthUtils.writeVarInt((OutputView)this.out, (int)1000);
        byte[] buffer = new byte[size += VarLengthUtils.sizeOfVarInt((int)1000)];
        new MemorySegmentInputView(this.out.getMemorySegment()).readFully(buffer, 0, size);
        Assertions.assertThat((int)VarLengthUtils.readVarInt((byte[])buffer, (int)0)).isEqualTo(-1);
        Assertions.assertThat((int)VarLengthUtils.readVarInt((byte[])buffer, (int)len1)).isEqualTo(10);
        Assertions.assertThat((int)VarLengthUtils.readVarInt((byte[])buffer, (int)(len1 + len2))).isEqualTo(1000);
    }

    @Test
    void testVarLong() throws IOException {
        VarLengthUtils.writeVarLong((OutputView)this.out, (long)-1L);
        VarLengthUtils.writeVarLong((OutputView)this.out, (long)10L);
        VarLengthUtils.writeVarLong((OutputView)this.out, (long)20L);
        MemorySegmentInputView in = new MemorySegmentInputView(this.out.getMemorySegment());
        Assertions.assertThat((long)VarLengthUtils.readVarLong((InputView)in)).isEqualTo(-1L);
        Assertions.assertThat((long)VarLengthUtils.readVarLong((InputView)in)).isEqualTo(10L);
        Assertions.assertThat((long)VarLengthUtils.readVarLong((InputView)in)).isEqualTo(20L);
    }

    @Test
    void testReadVarLong() throws IOException {
        int size = 0;
        VarLengthUtils.writeVarLong((OutputView)this.out, (long)-1L);
        int len1 = VarLengthUtils.sizeOfVarLong((long)-1L);
        size += len1;
        VarLengthUtils.writeVarLong((OutputView)this.out, (long)10L);
        int len2 = VarLengthUtils.sizeOfVarLong((long)10L);
        size += len2;
        VarLengthUtils.writeVarLong((OutputView)this.out, (long)1000L);
        byte[] buffer = new byte[size += VarLengthUtils.sizeOfVarLong((long)1000L)];
        new MemorySegmentInputView(this.out.getMemorySegment()).readFully(buffer, 0, size);
        Assertions.assertThat((long)VarLengthUtils.readVarLong((byte[])buffer, (int)0)).isEqualTo(-1L);
        Assertions.assertThat((long)VarLengthUtils.readVarLong((byte[])buffer, (int)len1)).isEqualTo(10L);
        Assertions.assertThat((long)VarLengthUtils.readVarLong((byte[])buffer, (int)(len1 + len2))).isEqualTo(1000L);
        byte[] buffer2 = new byte[]{-128, -128, -128, -128, -128, -128, -128, -128, -128, -128};
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> VarLengthUtils.readVarLong((byte[])buffer2, (int)0)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("VarLong is too long, most significant bit in the 10th byte is set");
    }
}

