/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.utils;

import com.alibaba.fluss.utils.WrappingProxy;
import com.alibaba.fluss.utils.WrappingProxyUtil;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Fail;
import org.junit.jupiter.api.Test;

public class WrappingProxyUtilTest {
    @Test
    void testThrowsExceptionIfTooManyProxies() {
        try {
            WrappingProxyUtil.stripProxy((WrappingProxy)new SelfWrappingProxy(128));
            Fail.fail((String)"Expected exception not thrown");
        }
        catch (IllegalArgumentException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"Are there loops in the object graph?"});
        }
    }

    @Test
    public void testStripsAllProxies() {
        SelfWrappingProxy wrappingProxy = new SelfWrappingProxy(127);
        Assertions.assertThat((Object)WrappingProxyUtil.stripProxy((WrappingProxy)wrappingProxy)).isNotInstanceOf(SelfWrappingProxy.class);
    }

    private static class SelfWrappingProxy
    extends Wrapped
    implements WrappingProxy<Wrapped> {
        private int levels;

        private SelfWrappingProxy(int levels) {
            this.levels = levels;
        }

        public Wrapped getWrappedDelegate() {
            if (this.levels-- == 0) {
                return new Wrapped();
            }
            return this;
        }
    }

    private static class Wrapped {
        private Wrapped() {
        }
    }
}

