/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.utils.concurrent;

import com.alibaba.fluss.testutils.junit.parameterized.ParameterizedTestExtension;
import com.alibaba.fluss.testutils.junit.parameterized.Parameters;
import com.alibaba.fluss.utils.concurrent.FutureUtils;
import com.alibaba.fluss.utils.types.Tuple2;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class ConjunctFutureTest {
    private static final List<FutureFactory> PARAMETERS = Arrays.asList(new ConjunctFutureFactory(), new WaitingFutureFactory());

    @Parameters
    private static List<FutureFactory> parameters() {
        return PARAMETERS;
    }

    @TestTemplate
    void testConjunctFutureFailsOnEmptyAndNull(FutureFactory futureFactory) throws Exception {
        Assertions.assertThatThrownBy(() -> futureFactory.createFuture(null)).isInstanceOf(NullPointerException.class);
        Assertions.assertThatThrownBy(() -> futureFactory.createFuture(Arrays.asList(new CompletableFuture(), null, new CompletableFuture()))).isInstanceOf(NullPointerException.class);
    }

    @TestTemplate
    void testConjunctFutureCompletion(FutureFactory futureFactory) throws Exception {
        CompletableFuture<Object> future1 = new CompletableFuture<Object>();
        CompletableFuture<Object> future2 = new CompletableFuture<Object>();
        CompletableFuture<Object> future3 = new CompletableFuture<Object>();
        CompletableFuture<Object> future4 = new CompletableFuture<Object>();
        future2.complete(new Object());
        FutureUtils.ConjunctFuture<?> result = futureFactory.createFuture(Arrays.asList(future1, future2, future3, future4));
        CompletableFuture resultMapped = result.thenAccept(value -> {});
        Assertions.assertThat((int)result.getNumFuturesTotal()).isEqualTo(4);
        Assertions.assertThat((int)result.getNumFuturesCompleted()).isEqualTo(1);
        Assertions.assertThat((boolean)result.isDone()).isFalse();
        Assertions.assertThat((boolean)resultMapped.isDone()).isFalse();
        future4.complete(new Object());
        Assertions.assertThat((int)result.getNumFuturesCompleted()).isEqualTo(2);
        Assertions.assertThat((boolean)result.isDone()).isFalse();
        Assertions.assertThat((boolean)resultMapped.isDone()).isFalse();
        future1.complete(new Object());
        Assertions.assertThat((int)result.getNumFuturesCompleted()).isEqualTo(3);
        Assertions.assertThat((boolean)result.isDone()).isFalse();
        Assertions.assertThat((boolean)resultMapped.isDone()).isFalse();
        future1.complete(new Object());
        Assertions.assertThat((int)result.getNumFuturesCompleted()).isEqualTo(3);
        Assertions.assertThat((boolean)result.isDone()).isFalse();
        Assertions.assertThat((boolean)resultMapped.isDone()).isFalse();
        future3.complete(new Object());
        Assertions.assertThat((int)result.getNumFuturesCompleted()).isEqualTo(4);
        Assertions.assertThat((boolean)result.isDone()).isTrue();
        Assertions.assertThat((boolean)resultMapped.isDone()).isTrue();
    }

    @TestTemplate
    void testConjunctFutureFailureOnFirst(FutureFactory futureFactory) throws Exception {
        CompletableFuture future1 = new CompletableFuture();
        CompletableFuture future2 = new CompletableFuture();
        CompletableFuture future3 = new CompletableFuture();
        CompletableFuture future4 = new CompletableFuture();
        FutureUtils.ConjunctFuture<?> result = futureFactory.createFuture(Arrays.asList(future1, future2, future3, future4));
        CompletableFuture resultMapped = result.thenAccept(value -> {});
        Assertions.assertThat((int)result.getNumFuturesTotal()).isEqualTo(4);
        Assertions.assertThat((int)result.getNumFuturesCompleted()).isEqualTo(0);
        Assertions.assertThat((boolean)result.isDone()).isFalse();
        Assertions.assertThat((boolean)resultMapped.isDone()).isFalse();
        future2.completeExceptionally(new IOException());
        Assertions.assertThat((int)result.getNumFuturesCompleted()).isEqualTo(0);
        Assertions.assertThat((boolean)result.isDone()).isTrue();
        Assertions.assertThat((boolean)resultMapped.isDone()).isTrue();
        Assertions.assertThatThrownBy(() -> result.get()).isInstanceOf(ExecutionException.class);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(resultMapped::get).isInstanceOf(ExecutionException.class)).cause().isInstanceOf(IOException.class);
    }

    @TestTemplate
    void testConjunctFutureFailureOnSuccessive(FutureFactory futureFactory) throws Exception {
        CompletableFuture<Object> future1 = new CompletableFuture<Object>();
        CompletableFuture future2 = new CompletableFuture();
        CompletableFuture<Object> future3 = new CompletableFuture<Object>();
        CompletableFuture<Object> future4 = new CompletableFuture<Object>();
        FutureUtils.ConjunctFuture<?> result = futureFactory.createFuture(Arrays.asList(future1, future2, future3, future4));
        Assertions.assertThat((int)result.getNumFuturesTotal()).isEqualTo(4);
        CompletableFuture resultMapped = result.thenAccept(value -> {});
        future1.complete(new Object());
        future3.complete(new Object());
        future4.complete(new Object());
        future2.completeExceptionally(new IOException());
        Assertions.assertThat((int)result.getNumFuturesCompleted()).isEqualTo(3);
        Assertions.assertThat((boolean)result.isDone()).isTrue();
        Assertions.assertThat((boolean)resultMapped.isDone()).isTrue();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> result.get()).isInstanceOf(ExecutionException.class)).cause().isInstanceOf(IOException.class);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> result.get()).isInstanceOf(ExecutionException.class)).cause().isInstanceOf(IOException.class);
    }

    @Test
    void testConjunctFutureValue() throws Exception {
        int numberFutures = 10;
        ArrayList futures = new ArrayList(10);
        for (int i = 0; i < 10; ++i) {
            futures.add(new CompletableFuture());
        }
        FutureUtils.ConjunctFuture result = FutureUtils.combineAll(futures);
        List shuffledFutures = IntStream.range(0, futures.size()).mapToObj(index -> Tuple2.of((Object)index, futures.get(index))).collect(Collectors.toList());
        Collections.shuffle(shuffledFutures);
        for (Tuple2 shuffledFuture : shuffledFutures) {
            Assertions.assertThat((boolean)result.isDone()).isFalse();
            ((CompletableFuture)shuffledFuture.f1).complete(shuffledFuture.f0);
        }
        Assertions.assertThat((boolean)result.isDone()).isTrue();
        Assertions.assertThat((Collection)((Collection)result.get())).isEqualTo(IntStream.range(0, 10).boxed().collect(Collectors.toList()));
    }

    @TestTemplate
    void testConjunctOfNone(FutureFactory futureFactory) throws Exception {
        FutureUtils.ConjunctFuture<?> result = futureFactory.createFuture(Collections.emptyList());
        Assertions.assertThat((int)result.getNumFuturesTotal()).isEqualTo(0);
        Assertions.assertThat((int)result.getNumFuturesCompleted()).isEqualTo(0);
        Assertions.assertThat((boolean)result.isDone()).isTrue();
    }

    private static class WaitingFutureFactory
    implements FutureFactory {
        private WaitingFutureFactory() {
        }

        @Override
        public FutureUtils.ConjunctFuture<?> createFuture(Collection<? extends CompletableFuture<?>> futures) {
            return FutureUtils.waitForAll(futures);
        }
    }

    private static class ConjunctFutureFactory
    implements FutureFactory {
        private ConjunctFutureFactory() {
        }

        @Override
        public FutureUtils.ConjunctFuture<?> createFuture(Collection<? extends CompletableFuture<?>> futures) {
            return FutureUtils.combineAll(futures);
        }
    }

    private static interface FutureFactory {
        public FutureUtils.ConjunctFuture<?> createFuture(Collection<? extends CompletableFuture<?>> var1);
    }
}

