/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.utils.concurrent;

import com.alibaba.fluss.utils.concurrent.ExecutorThreadFactory;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.concurrent.atomic.AtomicBoolean;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class ExecutorThreadFactoryTest {
    @Test
    void testThreadWithWithCustomExceptionHandler() {
        AtomicBoolean hasHandledUncaughtException = new AtomicBoolean(false);
        ExecutorThreadFactory executorThreadFactory = new ExecutorThreadFactory.Builder().setPoolName("test-executor-thread-factory-pool-custom").setThreadPriority(1).setExceptionHandler((Thread.UncaughtExceptionHandler)new TestExceptionHandler(hasHandledUncaughtException)).build();
        Thread thread = executorThreadFactory.newThread(() -> {
            throw new RuntimeException("throw exception");
        });
        thread.start();
        while (!hasHandledUncaughtException.get()) {
            System.out.println("wait");
        }
    }

    @Test
    void testThreadWithWithCustomClassloader() {
        URLClassLoader customClassloader = new URLClassLoader(new URL[0], null);
        ExecutorThreadFactory executorThreadFactory = new ExecutorThreadFactory.Builder().setPoolName("test-executor-thread-factory-pool-custom").setThreadPriority(1).setThreadContextClassloader((ClassLoader)customClassloader).build();
        Thread thread = executorThreadFactory.newThread(() -> {});
        Assertions.assertThat((Object)thread.getContextClassLoader()).isEqualTo((Object)customClassloader);
    }

    private static class TestExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private final AtomicBoolean hasHandledUncaughtException;

        public TestExceptionHandler(AtomicBoolean hasHandledUncaughtException) {
            this.hasHandledUncaughtException = hasHandledUncaughtException;
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            this.hasHandledUncaughtException.set(true);
        }
    }
}

